/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.title;

import com.ericsson.utils.title.ProcessUtil;
import com.ericsson.utils.title.PropertiesUtil;
import com.ericsson.utils.title.ResyncElasticSearchTitlesApp;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class TitleManagerMain {
    private static String database;
    private static String databasePort;

    public static void main(String[] args) {
        TitleManagerMain.checkOS();
        if (args.length <= 0 || args.length >= 4) {
            TitleManagerMain.printUsageAndExit();
        }
        String cmd = args[0];
        if (args.length == 2) {
            database = args[1];
        }
        if (args.length == 3) {
            database = args[1];
            databasePort = args[2];
        }
        if (cmd.equalsIgnoreCase("status")) {
            TitleManagerMain.doStatus();
        } else if (cmd.equalsIgnoreCase("stop")) {
            TitleManagerMain.doStop();
        } else if (cmd.equalsIgnoreCase("start")) {
            TitleManagerMain.doStart();
        } else if (cmd.equalsIgnoreCase("clean")) {
            TitleManagerMain.doClean();
        } else {
            System.out.println("Unknown command: " + cmd);
            System.exit(1);
        }
        System.exit(0);
    }

    private static void doClean() {
        List<ProcessUtil.ProcInfo> list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
        if (!list.isEmpty()) {
            System.out.println("Could not clean. Resync utility is running.");
            ProcessUtil.printProcessList(list);
            return;
        }
        System.out.println("Cleaning...");
        for (int i = 1; i <= 10; ++i) {
            TitleManagerMain.deleteFile("work/titleIds-" + i + ".txt");
            TitleManagerMain.deleteFile("work/titleIds-" + i + ".txt.stat");
            TitleManagerMain.deleteFile("log/titleIds-" + i + ".log");
            TitleManagerMain.deleteFile("work/titleIds-" + i + ".txt.failed");
        }
        System.out.println("Done.");
    }

    private static void deleteFile(String name) {
        File file = new File(name);
        file.delete();
    }

    private static boolean validateProperty(Properties props, String name, String label, String propFileName) {
        return TitleManagerMain.validateProperty(props, name, label, propFileName, true);
    }

    private static boolean validateProperty(Properties props, String name, String label, String propFileName, boolean required) {
        String str = props.getProperty(name);
        if (str == null || str.trim().isEmpty()) {
            String msg = label + " is not set ('" + name + "' property in '" + propFileName + "' file).";
            if (required) {
                System.out.println("ERROR: " + msg);
                return false;
            }
            System.out.println("WARN: " + msg + " Will use default value.");
            return true;
        }
        System.out.println(label + ": " + str);
        return true;
    }

    private static void doStart() {
        List<ProcessUtil.ProcInfo> list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
        if (!list.isEmpty()) {
            System.out.println("Resync utility is running.");
            ProcessUtil.printProcessList(list);
            return;
        }
        Properties props = PropertiesUtil.readProperties();
        if (props == null) {
            return;
        }
        System.out.println("Database Properties:");
        if (!TitleManagerMain.validateProperty(props, "jdbc.driverClassName", "JDBC Driver", "sync.properties")) {
            return;
        }
        if (!TitleManagerMain.validateProperty(props, "jdbc.username", "DB user name", "sync.properties")) {
            return;
        }
        System.out.println();
        int parallelBatches = TitleManagerMain.getParallelBatches(props);
        int batchSize = TitleManagerMain.getBatchSize(props);
        Date modifiedSinceDate = null;
        try {
            modifiedSinceDate = TitleManagerMain.getModifiedSinceDate(props);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        List<Integer> workFiles = TitleManagerMain.getWorkFiles();
        if (workFiles.isEmpty()) {
            System.out.println("Generating title ID files...");
            if (modifiedSinceDate != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                System.out.println("Will only sync titles created or modified since " + df.format(modifiedSinceDate));
            }
            ResyncElasticSearchTitlesApp app = new ResyncElasticSearchTitlesApp(null, database, databasePort);
            app.saveTitleIds(parallelBatches, batchSize, modifiedSinceDate);
            app.close();
        } else {
            System.out.println("Resuming resync...");
        }
        workFiles = TitleManagerMain.getWorkFiles();
        System.out.println("Starting " + parallelBatches + " Parallel batches...");
        for (int i = 0; i < workFiles.size(); ++i) {
            System.out.println("Working on work/titleIds-" + workFiles.get(i) + ".txt");
            TitleManagerMain.startResyncProcess(workFiles.get(i));
        }
        System.out.println("Done.");
    }

    private static boolean startResyncProcess(int num) {
        boolean success = true;
        try {
            String line;
            Process p = Runtime.getRuntime().exec("./bin/sync_title_ids.sh " + database + " " + databasePort + " " + num);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                System.out.println(line);
                success = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            success = false;
        }
        return success;
    }

    private static Date getModifiedSinceDate(Properties props) throws Exception {
        Date date = null;
        String str = props.getProperty("modifiedSince");
        if (str != null && !str.trim().isEmpty()) {
            date = TitleManagerMain.parseDate("yyyy-MM-dd:HH:mm:ss", str);
            if (date == null) {
                date = TitleManagerMain.parseDate("yyyy-MM-dd HH:mm:ss", str);
            }
            if (date == null) {
                throw new Exception("Invalid date format: " + str);
            }
        }
        return date;
    }

    private static Date parseDate(String format, String strDate) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(strDate);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static List<Integer> getWorkFiles() {
        File[] allFiles;
        ArrayList<Integer> workFiles = new ArrayList<Integer>();
        File dir = new File("work");
        if (!dir.exists() && !dir.mkdir()) {
            System.out.println("Error: Cannot make directory \"work\"");
            return workFiles;
        }
        if (!dir.isDirectory()) {
            System.out.println("Error: \"work\" is not a directory");
            return workFiles;
        }
        for (File f : allFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("titleIds-");
            }
        })) {
            String name = f.getName();
            Integer workFile = Integer.parseInt(name.substring(name.indexOf("-") + 1, name.indexOf(".")));
            if (workFiles.contains(workFile)) continue;
            workFiles.add(workFile);
        }
        return workFiles;
    }

    private static int getParallelBatches(Properties props) {
        int parallelBatches = 1;
        String str = props.getProperty("parallelBatches");
        if (str == null || str.trim().isEmpty()) {
            System.out.println("WARN: Number of parallel batches is not set ('parallelBatches' property in 'sync.properties' file). Will use 1.");
        } else {
            try {
                parallelBatches = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parallelBatches < 1) {
            parallelBatches = 1;
        } else if (parallelBatches > 10) {
            parallelBatches = 10;
        }
        System.out.println("Parallel Batches : " + parallelBatches);
        return parallelBatches;
    }

    private static int getBatchSize(Properties props) {
        int batchSize = 100;
        String str = props.getProperty("batchSize");
        if (str == null || str.trim().isEmpty()) {
            System.out.println("WARN: Batch size is not set ('batchSize' property in 'sync.properties' file). Will use 1.");
        } else {
            try {
                batchSize = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (batchSize < 1) {
            batchSize = 0;
        }
        System.out.println("Batch Size : " + batchSize);
        return batchSize;
    }

    private static void doStatus() {
        List<ProcessUtil.ProcInfo> list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
        if (list.isEmpty()) {
            System.out.println("Resync is not running.");
        } else {
            System.out.println("The following processes are running:");
            ProcessUtil.printProcessList(list);
        }
    }

    private static void doStop() {
        System.out.println("Stopping...");
        List<ProcessUtil.ProcInfo> list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
        if (list.isEmpty()) {
            System.out.println("Resync is not running.");
        } else {
            for (ProcessUtil.ProcInfo info : list) {
                TitleManagerMain.kill(info.procId);
            }
            TitleManagerMain.sleep(1);
            list = ProcessUtil.getProcessList("com.ericsson.utils.title.ResyncElasticSearchTitlesMain");
            if (!list.isEmpty()) {
                System.out.println("Could not stop the following processes:");
                ProcessUtil.printProcessList(list);
            } else {
                System.out.println("Stopped.");
            }
        }
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(1000 * seconds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkOS() {
        String osName = System.getProperty("os.name");
        if (osName == null || !osName.toLowerCase().contains("linux")) {
            System.out.println("Unsupported operating system: " + osName);
            System.out.println("Can only run on Linux");
            System.exit(1);
        }
    }

    private static void printUsageAndExit() {
        System.out.println("USAGE:");
        System.out.println("TitleManagerMain <command> [database] [database port]");
        System.out.println("  Commands:");
        System.out.println("  START");
        System.out.println("  STOP");
        System.out.println("  STATUS");
        System.out.println("  CLEAN");
        System.exit(1);
    }

    private static boolean kill(int procId) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("kill " + procId);
            BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = err.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    static {
        databasePort = "5432";
    }
}

