/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.search.utils;

import com.ericsson.cms.search.ElasticSearchService;
import com.tandbergtv.cms.search.utils.Pair;
import com.tandbergtv.cms.search.utils.TitleCountTask;
import com.tandbergtv.cms.search.utils.TitleRetrievalTask;
import com.tandbergtv.cms.search.utils.TitleToElasticSearchTask;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.customfield.persistence.ICustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.util.DataTypeMappingReader;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.ApplicationContextHelper;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.DefaultTitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.TitleManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.context.ApplicationContext;

public class ResyncTitlesToElasticSearch {
    private static final Logger logger = Logger.getLogger(ResyncTitlesToElasticSearch.class);
    public static final String[] LOCAL_CONTEXT_CONFIG = new String[]{"com/tandbergtv/cms/search/utils/SearchHibernateContext.xml"};
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_BATCH_COUNT = 32;
    public static final int DEFAULT_ELASTIC_SEARCH_WRITE_TIMEOUT_MILLIS = 10000;
    public static final DateFormat dfModifiedSince = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZZZ");
    public static final Date DEFAULT_MODIFIED_SINCE = new Date(0L);
    private static Set<String> startedServiceNames = new HashSet<String>();
    private static SortedSet<Integer> batchOffsets = new TreeSet<Integer>();
    private static boolean recordOffsets = true;

    public static void main(String[] args) throws Exception {
        int maxTitlesToSync;
        CommandLine cmd = ResyncTitlesToElasticSearch.parseCommandLine(args);
        if (cmd.hasOption("help")) {
            HelpFormatter f = new HelpFormatter();
            f.printHelp(ResyncTitlesToElasticSearch.class.getName(), ResyncTitlesToElasticSearch.getCommandLineOptions());
            System.exit(0);
        }
        boolean useRecoveryInfo = !cmd.hasOption("all");
        Date modifiedSince = cmd.hasOption("modifiedSince") ? dfModifiedSince.parse(cmd.getOptionValue("modifiedSince")) : DEFAULT_MODIFIED_SINCE;
        int titlesPerBatch = cmd.hasOption("batchSize") ? Integer.parseInt(cmd.getOptionValue("batchSize")) : 100;
        int parallelBatches = cmd.hasOption("batches") ? Integer.parseInt(cmd.getOptionValue("batches")) : 32;
        int maxESWriteMillis = cmd.hasOption("maxESWriteDelay") ? Integer.parseInt(cmd.getOptionValue("maxESWriteMillis")) : 10000;
        int n = maxTitlesToSync = cmd.hasOption("maxTitlesToSync") ? Integer.parseInt(cmd.getOptionValue("maxTitlesToSync")) : Integer.MAX_VALUE;
        if (modifiedSince != DEFAULT_MODIFIED_SINCE) {
            useRecoveryInfo = false;
        }
        recordOffsets = useRecoveryInfo;
        Integer progressOffset = ResyncTitlesToElasticSearch.retrieveLowestUncompleteBatchOffset();
        if (!useRecoveryInfo) {
            progressOffset = 0;
            ResyncTitlesToElasticSearch.deletePersistentFile();
        }
        ResyncTitlesToElasticSearch.initializeContext();
        int countOfTitles = new TitleCountTask(progressOffset, modifiedSince).call();
        int batches = countOfTitles / titlesPerBatch + (countOfTitles % titlesPerBatch != 0 ? 1 : 0);
        int firstPage = progressOffset / titlesPerBatch;
        int batchesAfterRestart = batches - firstPage;
        logger.info((Object)("This application will retrieve " + batchesAfterRestart + " title batches of size " + titlesPerBatch + " each, modulo the modifiedSince and maxTitlesToSync parameter values."));
        if (firstPage != 0) {
            logger.info((Object)"(Restarting after apparently incompletely indexing titles last time ran.)");
        }
        for (int page = firstPage; page < batchesAfterRestart && (page - firstPage) * titlesPerBatch < maxTitlesToSync; page += parallelBatches * 100) {
            int titlesSyncedThusFar = (page - firstPage) * titlesPerBatch;
            int maxTitlesThisIteration = Math.max(0, maxTitlesToSync - titlesSyncedThusFar);
            int maxBatchesThisIteration = maxTitlesThisIteration / titlesPerBatch + (maxTitlesThisIteration % titlesPerBatch != 0 ? 1 : 0);
            int numberOfPagesThisIteration = Math.min(maxBatchesThisIteration, Math.min(batchesAfterRestart - page, parallelBatches * 100));
            ResyncTitlesToElasticSearch.doSeveralBatchesInParallel(page, parallelBatches, titlesPerBatch, modifiedSince, maxESWriteMillis, numberOfPagesThisIteration);
        }
        System.out.println("They've all been pushed successfully.");
        ResyncTitlesToElasticSearch.shutdownAllServices();
        System.exit(0);
    }

    private static void doSeveralBatchesInParallel(int firstPage, int parallelBatches, int titlesPerBatch, Date modifiedSince, final int maxESWriteMillis, final int pages) throws Exception {
        ExecutorService executorForRetrieve = Executors.newFixedThreadPool(parallelBatches);
        final ExecutorCompletionService<Pair<Integer, List<Title>>> ecsRetrieve = new ExecutorCompletionService<Pair<Integer, List<Title>>>(executorForRetrieve);
        ExecutorService executorForPush = Executors.newFixedThreadPool(parallelBatches);
        final ExecutorCompletionService ecsPushToElasticSearch = new ExecutorCompletionService(executorForPush);
        for (int page = firstPage; page < firstPage + pages; ++page) {
            ResyncTitlesToElasticSearch.recordBatchOffsetSubmitted(titlesPerBatch * page);
            ecsRetrieve.submit(new TitleRetrievalTask.Identity(titlesPerBatch * page, titlesPerBatch, modifiedSince));
        }
        logger.info((Object)("Starting retrieval of " + pages + " title batches of size " + titlesPerBatch + " each with a unique set of CompletionService objects."));
        final Object threadSyncLock = new Object();
        Thread reportingThread1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int ii = pages; ii > 0; --ii) {
                        Pair pair = (Pair)ecsRetrieve.take().get();
                        Integer offset = (Integer)pair._1;
                        List titles = (List)pair._2;
                        if (titles.size() == 0) {
                            logger.info((Object)("\tbatch at offset " + offset + " is apparently 0-length"));
                        }
                        ecsPushToElasticSearch.submit(new TitleToElasticSearchTask(offset, titles, maxESWriteMillis));
                        Object object = threadSyncLock;
                        synchronized (object) {
                            threadSyncLock.notifyAll();
                            continue;
                        }
                    }
                }
                catch (Exception ee) {
                    logger.error((Object)"Unexpected error. Cannot deal. Quiting :(", (Throwable)ee);
                }
            }
        };
        Thread reportingThread2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = threadSyncLock;
                synchronized (object) {
                    try {
                        threadSyncLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int countSuccessfullyWritten = 0;
                try {
                    for (int ii = pages; ii > 0; --ii) {
                        Integer offset = (Integer)ecsPushToElasticSearch.take().get();
                        logger.info((Object)("Titles beginning at offset " + offset + " have been fully written to ElasticSearch. " + ++countSuccessfullyWritten + "/" + pages + " title batches complete."));
                        ResyncTitlesToElasticSearch.recordBatchOffsetCompleted(offset);
                    }
                }
                catch (Exception ee) {
                    logger.error((Object)"Unexpected error. Cannot deal. Quiting :(", (Throwable)ee);
                }
            }
        };
        reportingThread2.start();
        Thread.sleep(1000L);
        reportingThread1.start();
        reportingThread1.join();
        reportingThread2.join();
        executorForRetrieve.shutdown();
        executorForRetrieve.awaitTermination(10L, TimeUnit.SECONDS);
        executorForRetrieve = null;
        executorForPush.shutdown();
        executorForPush.awaitTermination(10L, TimeUnit.SECONDS);
        executorForPush = null;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options cliOptions = ResyncTitlesToElasticSearch.getCommandLineOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(cliOptions, args);
        return cmd;
    }

    private static Options getCommandLineOptions() {
        Options cliOptions = new Options();
        cliOptions.addOption("all", false, "If provided, then all titles will be indexed, even if there was a prevoius interrupted run");
        cliOptions.addOption("modifiedSince", true, "'yyyy-MM-dd HH:mm:ss ZZZZ' formatted date. Any and all items modified since this moment will be re-indexed. If not specified, then modifiation date of titles is ignored.");
        cliOptions.addOption("batchSize", true, "Number of titles in each processed batch. Defaults to 100.");
        cliOptions.addOption("batches", true, "Number of batches to process in parallel. Defaults to 5.");
        cliOptions.addOption("maxESWriteMillis", true, "Maximum wait time for individual ElasticSearch writes, in milliseconds");
        cliOptions.addOption("maxTitlesToSync", true, "Maxiumum number of titles to sync with ElasticSearch");
        cliOptions.addOption("help", false, "Print this command-line option message");
        return cliOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeContext() {
        ApplicationContextHelper helper = new ApplicationContextHelper(LOCAL_CONTEXT_CONFIG);
        ApplicationContext context = helper.getContext();
        ITTVDataModelHandler assetDataModelHandler = (ITTVDataModelHandler)context.getBean("TTVSpecHandler");
        ResyncTitlesToElasticSearch.addService((Service)new DefaultTitlePersistenceService(assetDataModelHandler));
        ResyncTitlesToElasticSearch.addService((Service)new ElasticSearchService());
        ResyncTitlesToElasticSearch.addService((Service)new TitleManager());
        HibernateContext.getContext().initializeContext();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        try {
            DataTypeMappingReader dt = DataTypeMappingReader.getInstance();
            ICustomFieldPersistenceService cfs = CustomFieldPersistenceService.getInstance((ApplicationContext)context);
            dt.refreshCustomFieldDataTypeMap(cfs.getAllGroups());
        }
        finally {
            trans.commit();
        }
    }

    private static void shutdownAllServices() {
        for (String serviceName : startedServiceNames) {
            ServiceRegistry.getDefault().lookup(serviceName).stop();
        }
    }

    public static void addService(Service service) {
        String serviceName = service.getServiceName();
        startedServiceNames.add(serviceName);
        ServiceRegistry.getDefault().register(serviceName, service);
        service.start();
    }

    public static synchronized void recordBatchOffsetSubmitted(Integer candidateOffset) {
        batchOffsets.add(candidateOffset);
        ResyncTitlesToElasticSearch.recordLowestUncompleteBatchOffset();
    }

    public static synchronized void recordBatchOffsetCompleted(Integer candidateOffset) {
        batchOffsets.remove(candidateOffset);
        ResyncTitlesToElasticSearch.recordLowestUncompleteBatchOffset();
    }

    private static void recordLowestUncompleteBatchOffset() {
        if (recordOffsets) {
            File persist = ResyncTitlesToElasticSearch.getPersistentFile();
            if (batchOffsets.isEmpty()) {
                persist.delete();
            } else {
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(persist));
                    pw.println(batchOffsets.first());
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Cannot find nor create progress file in user's home directory: " + persist.getAbsolutePath());
                    System.exit(-1);
                }
                catch (IOException ioe) {
                    System.err.println("Unexpected error opening progress file.");
                    ioe.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }

    private static Integer retrieveLowestUncompleteBatchOffset() {
        if (!recordOffsets) {
            return 0;
        }
        File persist = ResyncTitlesToElasticSearch.getPersistentFile();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(persist));
            String line = reader.readLine();
            reader.close();
            return Integer.parseInt(line.trim());
        }
        catch (NullPointerException npe) {
            return 0;
        }
        catch (IOException ioe) {
            return 0;
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)"Unexpected corruption in progress file. Ignoring. Loading all titles.");
            return 0;
        }
    }

    private static void deletePersistentFile() {
        ResyncTitlesToElasticSearch.getPersistentFile().delete();
    }

    private static File getPersistentFile() {
        return new File(System.getProperty("user.home") + System.getProperty("file.separator") + "." + ResyncTitlesToElasticSearch.class.getSimpleName());
    }
}

