/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.search.utils;

import com.tandbergtv.cms.search.utils.CookiedCallable;
import com.tandbergtv.cms.search.utils.Pair;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public abstract class TitleRetrievalTask<SingleResult>
implements CookiedCallable<Integer, List<SingleResult>> {
    private static final Logger logger = Logger.getLogger(TitleRetrievalTask.class);
    private int numberOfTitlesToRetrieve = 0;
    private int offset = 0;
    private Date modifiedSince = new Date(0L);
    private ITitlePersistenceService titlePersistenceService = null;

    public TitleRetrievalTask(int offset, int numberOfTitlesToRetrieve, Date modifiedSince) {
        this.setNumberOfTitlesToRetrieve(numberOfTitlesToRetrieve);
        this.setOffset(offset);
        this.setModifiedSince(modifiedSince);
        this.setTitlePersistenceService((ITitlePersistenceService)ServiceRegistry.getDefault().lookup(ITitlePersistenceService.class));
    }

    public int getNumberOfTitlesToRetrieve() {
        return this.numberOfTitlesToRetrieve;
    }

    public void setNumberOfTitlesToRetrieve(int numberOfTitlesToProcess) {
        this.numberOfTitlesToRetrieve = numberOfTitlesToProcess;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Date getModifiedSince() {
        return this.modifiedSince;
    }

    public void setModifiedSince(Date modifiedSince) {
        this.modifiedSince = modifiedSince;
    }

    public ITitlePersistenceService getTitlePersistenceService() {
        return this.titlePersistenceService;
    }

    public void setTitlePersistenceService(ITitlePersistenceService titlePersistenceService) {
        this.titlePersistenceService = titlePersistenceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<Integer, List<SingleResult>> call() throws Exception {
        Session hibernateSession = this.obtainHibernateSession();
        Transaction trans = hibernateSession.beginTransaction();
        this.startTask(hibernateSession);
        try {
            List titleIDs = hibernateSession.getNamedQuery("Title.GetAllIDsInOrder").setDate("modifiedSince", this.modifiedSince).setFirstResult(this.offset).setMaxResults(this.numberOfTitlesToRetrieve).list();
            ArrayList<SingleResult> results = new ArrayList<SingleResult>(titleIDs.size());
            for (Long titleID : titleIDs) {
                try {
                    Title title = this.titlePersistenceService.get((Serializable)titleID);
                    results.add(this.processTitle(title));
                    hibernateSession.evict((Object)title);
                }
                catch (TitlePersistenceException tpe) {
                    logger.error((Object)("Cannot retrieve title with ID " + titleID), (Throwable)tpe);
                }
            }
            this.stopTask(hibernateSession);
            Pair pair = new Pair(this.offset, results);
            return pair;
        }
        finally {
            trans.commit();
        }
    }

    public Session obtainHibernateSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public abstract SingleResult processTitle(Title var1);

    public void startTask(Session hibernateSession) {
    }

    public void stopTask(Session hibernateSession) {
    }

    public static class Identity
    extends TitleRetrievalTask<Title> {
        public Identity(int offset, int titleCount, Date modifiedSince) {
            super(offset, titleCount, modifiedSince);
        }

        @Override
        public Title processTitle(Title title) {
            return title;
        }
    }
}

