/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.elasticsearch.geosync;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class TransportClientFactory {
    private static final int TRANSPORT_CLIENT_PORT = 9300;

    private TransportClientFactory() {
    }

    public static TransportClient createTransportClient(Properties properties) throws UnknownHostException {
        Settings settings = Settings.builder().put("cluster.name", properties.getProperty("cluster.name")).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        String hosts = properties.getProperty("hosts");
        InetAddress[] addresses = InetAddress.getAllByName(hosts);
        if (addresses != null) {
            for (InetAddress ia : addresses) {
                TransportAddress addr = new TransportAddress(new InetSocketAddress(ia.getHostAddress(), 9300));
                client.addTransportAddress(addr);
                System.out.println("Host added: " + ia.getHostAddress() + ":" + 9300);
            }
        }
        return client;
    }
}

