/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria;

import com.ericsson.cms.criteria.EntityChangeRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ChangesBuilder {
    private List<Object> leftFields = new ArrayList<Object>();
    private List<Object> rightFields = new ArrayList<Object>();

    public ChangesBuilder appendFields(Object leftField, Object rightField) {
        this.leftFields.add(leftField);
        this.rightFields.add(rightField);
        return this;
    }

    public boolean build() {
        for (int i = 0; i < this.leftFields.size(); ++i) {
            Object right;
            Object left = this.leftFields.get(i);
            if (!this.checkField(left, right = this.rightFields.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean checkField(Object left, Object right) {
        if (this.isEntityChangeRecord(left, right)) {
            return this.entityChangeRecordChanged((EntityChangeRecord)left, (EntityChangeRecord)right);
        }
        if (this.isList(left, right)) {
            return this.listChanged((List)left, (List)right);
        }
        if (this.isSet(left, right)) {
            return this.setChanged((Set)left, (Set)right);
        }
        return !Objects.equals(left, right);
    }

    private boolean isSet(Object left, Object right) {
        return left instanceof Set || right instanceof Set;
    }

    private boolean isList(Object left, Object right) {
        return left instanceof List || right instanceof List;
    }

    private boolean isEntityChangeRecord(Object left, Object right) {
        return left instanceof EntityChangeRecord || right instanceof EntityChangeRecord;
    }

    private boolean listChanged(List left, List right) {
        if (this.nullOrEmptyList(left)) {
            return !this.nullOrEmptyList(right);
        }
        if (this.nullOrEmptyList(right)) {
            return true;
        }
        if (left.size() != right.size()) {
            return true;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (!this.checkField(left.get(i), right.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean setChanged(Set left, Set right) {
        if (this.nullOrEmptyList(left)) {
            return !this.nullOrEmptyList(right);
        }
        return !left.equals(right);
    }

    private boolean entityChangeRecordChanged(EntityChangeRecord left, EntityChangeRecord right) {
        if (left == null) {
            return right != null;
        }
        if (right == null) {
            return true;
        }
        if (!left.getClass().getName().equals(right.getClass().getName())) {
            return true;
        }
        return left.hasChanges(right);
    }

    private boolean nullOrEmptyList(Collection list) {
        if (list == null) {
            return true;
        }
        return list.isEmpty();
    }
}

