/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria.info;

import com.ericsson.cms.criteria.info.InvalidSortException;

public enum SortOrder {
    ASCENDING("ASC"),
    DESCENDING("DESC");

    private String sql;

    private SortOrder(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return " " + this.sql + " ";
    }

    public static SortOrder lookup(String sortOrder) throws InvalidSortException {
        for (SortOrder value : SortOrder.values()) {
            String upperSortOrder = sortOrder.toUpperCase();
            if (!upperSortOrder.equals(value.name()) && !upperSortOrder.equals(value.sql)) continue;
            return value;
        }
        throw new InvalidSortException();
    }
}

