/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.criteria.info;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.info.SortOrder;

public class SortingInfo {
    private String sortItemName;
    private SortOrder order;
    private String assetType;
    private FieldType fieldType;

    public SortingInfo(String sortItemName, SortOrder order, String assetType, FieldType fieldType) {
        this.sortItemName = sortItemName;
        this.order = order;
        this.assetType = assetType;
        this.fieldType = fieldType;
        if (sortItemName == null || sortItemName.isEmpty() || order == null || fieldType == null) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public boolean isMetaDataSort() {
        if (this.fieldType != null) {
            return this.fieldType.equals((Object)FieldType.ASSET);
        }
        return false;
    }

    public boolean isTitleSort() {
        if (this.fieldType != null) {
            return this.fieldType.equals((Object)FieldType.PMM_TITLE);
        }
        return false;
    }

    public String getSortItemName() {
        return this.sortItemName;
    }

    public void setSortItemName(String sortItemName) {
        this.sortItemName = sortItemName;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public void setOrder(SortOrder order) {
        this.order = order;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String toString() {
        return "sortItemName='" + this.sortItemName + "'order|='" + (Object)((Object)this.order) + "'|assetType='" + this.assetType + "'|fieldType='" + (Object)((Object)this.fieldType) + "'";
    }
}

