/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import java.util.Collection;

public class MetadataMapInfo {
    private static final String TITLEID_PREFIX = "titleId:";
    private Status status;
    private StringBuffer mappedTitles = new StringBuffer();
    private StringBuffer duplicateAssets = new StringBuffer();

    public MetadataMapInfo(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void addMappedTitle(Long titleId, boolean validationSuccess, Collection<String> mappedAssetsInfo) {
        if (this.mappedTitles.length() > 0) {
            this.mappedTitles.append(", ");
        }
        this.mappedTitles.append("[").append(TITLEID_PREFIX).append(titleId).append("|").append("Validation ").append(validationSuccess ? "Success" : "Failure").append("|");
        boolean firstTime = true;
        if (mappedAssetsInfo != null) {
            for (String mappedAssetInfo : mappedAssetsInfo) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.mappedTitles.append(", ");
                }
                this.mappedTitles.append(mappedAssetInfo);
            }
        }
        this.mappedTitles.append("]");
    }

    public void addDuplicateAssets(Long titleId, Collection<String> assetNames, Collection<String> assetIds) {
        if (this.duplicateAssets.length() > 0) {
            this.duplicateAssets.append(", ");
        }
        this.duplicateAssets.append("[").append(TITLEID_PREFIX).append(titleId).append("|");
        boolean firstTime = true;
        if (assetNames != null) {
            for (String assetId : assetIds) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.duplicateAssets.append(", ");
                }
                this.duplicateAssets.append(assetId);
            }
        }
        this.duplicateAssets.append("|");
        firstTime = true;
        if (assetIds != null) {
            for (String assetName : assetNames) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.duplicateAssets.append(", ");
                }
                this.duplicateAssets.append(assetName);
            }
        }
        this.duplicateAssets.append("]");
    }

    public String getMappedTitles() {
        return this.mappedTitles.toString();
    }

    public String getDuplicateAssets() {
        return this.duplicateAssets.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: ").append((Object)this.status).append(" | ");
        sb.append("Mapped Titles: ").append(this.mappedTitles);
        sb.append("Duplicate Assets: ").append(this.duplicateAssets);
        return sb.toString();
    }

    public static enum Status {
        TITLES_NOT_FOUND,
        TITLES_MERGED,
        DUPLICATE_ASSETS_FOUND;

    }
}

