/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import java.io.Serializable;

public class TitleValidationMessage
implements Serializable {
    private static final long serialVersionUID = -1386739566384755137L;
    private Type type;
    private String code;
    private String message;
    private String assetType;
    private String fieldXPath;
    private String displayId;
    private boolean isEmailNotify = false;

    private TitleValidationMessage(Type type, String assetType) {
        this.type = type;
        this.assetType = assetType;
    }

    private TitleValidationMessage(Type type) {
        this(type, null);
    }

    public static TitleValidationMessage createErrorAssetMessage(String assetType, String code, String message) {
        TitleValidationMessage msg = new TitleValidationMessage(Type.Error, assetType);
        msg.code = code;
        msg.message = message;
        return msg;
    }

    public static TitleValidationMessage createMessage(Type type, String code, String message) {
        TitleValidationMessage msg = new TitleValidationMessage(type);
        msg.code = code;
        msg.message = message;
        return msg;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "[type=" + (Object)((Object)this.type) + ", assetType=" + this.assetType + ", fieldXPath=" + this.fieldXPath + "] : " + this.message;
    }

    public String getCode() {
        return this.code;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public String getFieldXPath() {
        return this.fieldXPath;
    }

    public String getMessage() {
        return this.message;
    }

    public void setFieldXPath(String fieldXPath) {
        this.fieldXPath = fieldXPath;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public boolean getIsEmailNotify() {
        return this.isEmailNotify;
    }

    public void setIsEmailNotify(boolean isEmailNotify) {
        this.isEmailNotify = isEmailNotify;
    }

    public static enum Type {
        Info("info"),
        Warning("warning"),
        Error("error");

        private String i18nKey;

        private Type(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String toString() {
            return this.i18nKey;
        }
    }
}

