/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.BooleanVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.ComplexVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomField;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFieldGroup;
import com.tandbergtv.watchpoint.pmm.title.conf.CustomFields;
import com.tandbergtv.watchpoint.pmm.title.conf.DateVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.FloatVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.IntegerVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.SimpleVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.StringVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TimeVariable;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConfMetadata;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.conf.Variable;
import com.tandbergtv.watchpoint.pmm.title.conf.VariableOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TitleConf {
    private UISpecification specification;
    private String name;
    private String alias;
    private String path;
    private int maxOccurs;
    private TitleConf parent;
    private List<TitleConf> children = new ArrayList<TitleConf>();
    private List<Variable> metadata = Collections.unmodifiableList(new ArrayList());
    private CustomFields customFields = new CustomFields();

    public TitleConf(UISpecification specification) {
        this.specification = specification;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String getAlias() {
        if (this.alias == null || this.alias.length() == 0) {
            return this.name;
        }
        return this.specification.getBundleString(this.alias);
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public UISpecification getSpecification() {
        return this.specification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TitleConf getParent() {
        return this.parent;
    }

    public void setParent(TitleConf parent) {
        this.parent = parent;
    }

    public String getParentName() {
        return this.parent != null ? this.parent.getName() : null;
    }

    public List<TitleConf> getChildren() {
        return this.children;
    }

    public void setChildren(List<TitleConf> children) {
        if (children != null) {
            for (TitleConf child : children) {
                child.setParent(this);
            }
        }
        this.children = children != null ? children : new ArrayList();
    }

    public synchronized List<Variable> getMetadata() {
        return this.metadata;
    }

    public synchronized TitleConfMetadata getTitleConfMetadata() {
        TitleConfMetadata md = new TitleConfMetadata();
        md.coreFields = this.metadata;
        md.customFields = this.customFields;
        return md;
    }

    public synchronized void updateCustomFields(List<CustomFieldGroup> groups) {
        ArrayList<Variable> newMetadata = new ArrayList<Variable>();
        for (Variable var : this.metadata) {
            if ("CustomFields".equalsIgnoreCase(var.getName())) continue;
            newMetadata.add(var);
        }
        if (groups == null || groups.isEmpty()) {
            this.customFields = new CustomFields();
            this.metadata = Collections.unmodifiableList(newMetadata);
            return;
        }
        ComplexVariable fieldsVar = new ComplexVariable();
        fieldsVar.setDisplayName("Custom Fields");
        fieldsVar.setName("CustomFields");
        fieldsVar.setXPath("/Fields/CustomFields");
        for (CustomFieldGroup group : groups) {
            if (group.fields == null) continue;
            for (CustomField cf : group.fields) {
                Variable var = this.createCustomFieldVar(cf);
                fieldsVar.getChildren().add(var);
            }
        }
        newMetadata.add(fieldsVar);
        this.customFields = new CustomFields(groups);
        this.metadata = Collections.unmodifiableList(newMetadata);
    }

    public Variable createCustomFieldVar(CustomField cf) {
        ComplexVariable rootVar = new ComplexVariable();
        rootVar.setShowCollapsed(true);
        rootVar.setDisplayName(cf.displayName);
        rootVar.setName("CustomField[@name=" + cf.name + "]");
        rootVar.setXPath("/Fields/CustomFields/CustomField[@name=" + cf.name + "]");
        Variable var = null;
        switch (cf.dataType) {
            case BOOLEAN: {
                var = new BooleanVariable();
                break;
            }
            case DATE: {
                var = new DateVariable();
                break;
            }
            case FLOAT: {
                var = new FloatVariable();
                break;
            }
            case INTEGER: {
                var = new IntegerVariable();
                break;
            }
            case STRING: {
                var = new StringVariable();
                ((StringVariable)var).setLongFormat(cf.multiLine);
                break;
            }
            case TIME: {
                var = new TimeVariable();
            }
        }
        var.setName("value");
        var.setDisplayName(cf.displayName);
        ((SimpleVariable)var).setAttribute(true);
        var.setXPath("/Fields/CustomFields/CustomField[@name=" + cf.name + "]/@value");
        ((SimpleVariable)var).setGroupId(cf.groupId);
        ((SimpleVariable)var).setJobParameter(cf.jobParameter);
        ((SimpleVariable)var).setJobRuleParameter(cf.jobScheduleParameter);
        if (cf.dropDown) {
            ((SimpleVariable)var).setOptions(new ArrayList<VariableOption>());
            ((SimpleVariable)var).setAnyValueAllowed(false);
        }
        rootVar.getChildren().add(var);
        return rootVar;
    }

    public synchronized void setMetadata(List<Variable> metadata) {
        this.metadata = metadata != null ? metadata : new ArrayList();
    }

    public synchronized Variable getMetadataVariableByXPath(String xpath) {
        return this.getMetadataVariableByXPath(this.metadata, xpath);
    }

    private Variable getMetadataVariableByXPath(List<Variable> variables, String xpath) {
        if (variables == null) {
            return null;
        }
        Variable match = null;
        for (Variable variable : variables) {
            if (xpath.equals(variable.getXPath())) {
                match = variable;
            } else if (variable instanceof ComplexVariable) {
                ComplexVariable complexVariable = (ComplexVariable)variable;
                match = this.getMetadataVariableByXPath(complexVariable.getChildren(), xpath);
            }
            if (match == null) continue;
            break;
        }
        return match;
    }

    public TitleConf getChild(String name) {
        if (this.children != null) {
            for (TitleConf child : this.children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public void addChild(TitleConf titleConf) {
        titleConf.setParent(this);
        this.children.add(titleConf);
    }

    public List<TitleConf> getAllDescendants() {
        ArrayList<TitleConf> allDecendants = new ArrayList<TitleConf>();
        for (TitleConf child : this.getChildren()) {
            allDecendants.add(child);
            allDecendants.addAll(child.getAllDescendants());
        }
        return allDecendants;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : super.hashCode();
    }

    public boolean equals(Object o) {
        if (this.name != null) {
            return o instanceof TitleConf && this.name.equals(((TitleConf)o).name);
        }
        return super.equals(o);
    }

    public String toString() {
        String newLineString = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("TitleConf:\n");
        sb.append("Name: " + this.name).append(" (").append(this.getAlias()).append(")").append(newLineString);
        sb.append("Parent Name: " + this.getParentName()).append(newLineString);
        sb.append("Metadata: \n");
        for (Variable v : this.metadata) {
            sb.append(v).append(newLineString);
        }
        sb.append("Children: \n");
        for (TitleConf child : this.children) {
            sb.append(child).append(newLineString);
        }
        return sb.toString();
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

