/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.AggregationSearchCommand;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

public class CountByTermSearchCommand
extends AggregationSearchCommand {
    String field;
    final String AGG_NAME = "count_by_term";

    public CountByTermSearchCommand(String field, ExpNode rootNode, SearchParameters params) {
        super(rootNode, params);
        this.field = field;
    }

    @Override
    public AbstractAggregationBuilder getAggregationBuilder() {
        return ((TermsAggregationBuilder)AggregationBuilders.terms((String)"count_by_term").field(this.field)).size(0);
    }

    public Map<String, Long> getAggregationSearchResults() {
        LinkedHashMap<String, Long> countByTerm = new LinkedHashMap<String, Long>();
        Terms countBySiteAggregation = this.getTermsResult();
        for (Terms.Bucket entry : countBySiteAggregation.getBuckets()) {
            countByTerm.put(String.valueOf(entry.getKey()), entry.getDocCount());
        }
        return countByTerm;
    }

    private Terms getTermsResult() {
        return (Terms)this.getAggregationResult().get("count_by_term");
    }
}

