/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import com.ericsson.cms.search.ESMetadataFields;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.search.util.QuickSearchStringBuilder;
import com.ericsson.cms.search.util.TitleUpdateUtil;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.TimeCodeType;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ElasticSearchTitleBuilder {
    private static Logger logger = Logger.getLogger(ElasticSearchTitleBuilder.class);
    private XContentBuilder bld;
    private Map<String, Boolean> missingFilesMap;
    private List<String> unparsableFields = new ArrayList<String>();
    private List<String> contentMapping = new ArrayList<String>();
    private QuickSearchStringBuilder quickSearchBuilder = new QuickSearchStringBuilder();
    private Set<String> notEmptyXpaths = new HashSet<String>();
    private ESMetadataFields metadataFields = new ESMetadataFields();

    public XContentBuilder createTitle(ElasticSearchIndexType titleType, Title title, List<String> requiresFileAssets) throws Exception {
        if (title == null) {
            throw new IllegalArgumentException("Title is null.");
        }
        this.missingFilesMap = new HashMap<String, Boolean>();
        for (Asset asset : title.getAllAssets(false)) {
            if (requiresFileAssets == null || !this.isMissingOriginalFile(asset) || !requiresFileAssets.contains(asset.getPath())) continue;
            this.missingFilesMap.put(this.getMissingContent(asset), null);
        }
        this.bld = XContentFactory.jsonBuilder();
        this.bld.prettyPrint();
        this.bld.startObject();
        this.addNonMetadataFields(titleType, title);
        this.addMetadataFields(title);
        this.addUnparsableField();
        this.addMissingContentField();
        this.addContentMapping();
        this.addQuickSearchField();
        this.bld.endObject();
        return this.bld;
    }

    private String getMissingContent(Asset asset) {
        String assetPath = asset.getPath();
        String missingFile = asset.getContentFileName() != null ? asset.getContentFileName() : "";
        logger.debug((Object)("Saving missing asset file to ElasticSearch: " + assetPath + "(" + missingFile + ")"));
        return assetPath + "(" + missingFile + ")";
    }

    private void addQuickSearchField() throws Exception {
        this.bld.field("quickSearch", this.quickSearchBuilder.getQuickSearchString());
    }

    private void addUnparsableField() throws Exception {
        if (this.unparsableFields == null || this.unparsableFields.isEmpty()) {
            return;
        }
        this.bld.startArray("unparsable");
        for (String unParse : this.unparsableFields) {
            this.bld.value(unParse);
        }
        this.bld.endArray();
    }

    private void addMissingContentField() throws Exception {
        if (this.missingFilesMap == null || this.missingFilesMap.isEmpty()) {
            return;
        }
        ArrayList<String> missingXpaths = new ArrayList<String>();
        for (Map.Entry<String, Boolean> missingFile : this.missingFilesMap.entrySet()) {
            missingXpaths.add(missingFile.getKey());
        }
        if (missingXpaths.isEmpty()) {
            return;
        }
        this.bld.startArray("missingContent");
        for (String path : missingXpaths) {
            this.bld.value(path);
        }
        this.bld.endArray();
    }

    private void addContentMapping() throws Exception {
        if (this.contentMapping == null || this.contentMapping.isEmpty()) {
            return;
        }
        this.bld.startArray("contentMapping");
        for (String value : this.contentMapping) {
            this.bld.value(value);
        }
        this.bld.endArray();
    }

    private void addNonMetadataFields(ElasticSearchIndexType titleType, Title title) throws Exception {
        ElasticSearchUtil.addField(this.bld, "id", title.getId());
        this.quickSearchBuilder.addTitleId(title.getId());
        if (title.getContentClassId() != null) {
            ElasticSearchUtil.addField(this.bld, "contentClassId", title.getContentClassId());
        }
        if (title.getPartnerId() != null) {
            ElasticSearchUtil.addField(this.bld, "partnerId", title.getPartnerId());
        }
        if (title.getDocumentId() != null) {
            ElasticSearchUtil.addField(this.bld, "documentId", title.getDocumentId());
        }
        if (title.getStatus() != null) {
            ElasticSearchUtil.addField(this.bld, "status", title.getStatus().toString());
        }
        if (title.getOriginalId() != null) {
            ElasticSearchUtil.addField(this.bld, "originalId", title.getOriginalId());
        }
        if (title.getCreateDate() != null) {
            ElasticSearchUtil.addField(this.bld, "createDate", title.getCreateDate());
        }
        if (title.getLastModifiedTime() != null) {
            ElasticSearchUtil.addField(this.bld, "lastModifiedTime", title.getLastModifiedTime());
        }
        if (title.getRetirementDate() != null) {
            ElasticSearchUtil.addField(this.bld, "retirementDate", title.getRetirementDate());
        }
        if (title.getProcessingStatus() != null) {
            ElasticSearchUtil.addField(this.bld, "processingStatus", title.getProcessingStatus().toString());
        }
        if (titleType == ElasticSearchIndexType.MASTER) {
            Asset rootAsset;
            if (title.getDistributionStatus() != null) {
                ElasticSearchUtil.addField(this.bld, "distributionStatus", title.getDistributionStatus());
            }
            if (title.getDistributionDate() != null) {
                ElasticSearchUtil.addField(this.bld, "distributionDate", title.getDistributionDate());
            }
            if ((rootAsset = title.getAsset()) != null && rootAsset instanceof Group) {
                Group rootGroup = (Group)rootAsset;
                if (rootGroup.getSeriesDocumentId() != null) {
                    ElasticSearchUtil.addField(this.bld, "seriesDocumentId", rootGroup.getSeriesDocumentId());
                }
                if (rootGroup.getSeasonAssetId() != null) {
                    ElasticSearchUtil.addField(this.bld, "seasonAssetId", rootGroup.getSeasonAssetId());
                }
                if (rootGroup.getReferencedTitleIds() != null && !rootGroup.getReferencedTitleIds().isEmpty()) {
                    ElasticSearchUtil.addArray(this.bld, "referencedTitleIds", rootGroup.getReferencedTitleIds());
                }
            }
        }
    }

    private void addMetadataFields(Title title) throws Exception {
        if (title == null) {
            return;
        }
        this.processAsset(title.getAsset());
        this.metadataFields.build(this.bld);
    }

    private boolean isMissingOriginalFile(Asset asset) {
        if (asset == null) {
            return false;
        }
        if (asset.getRelations() != null) {
            for (Relation r : asset.getRelations()) {
                com.tandbergtv.metadatamanager.model.File fileAsset;
                Asset childAsset = r.getTargetAsset();
                if (!(childAsset instanceof com.tandbergtv.metadatamanager.model.File) || !(fileAsset = (com.tandbergtv.metadatamanager.model.File)childAsset).isOriginal() || fileAsset.getURL() == null || fileAsset.getURL().trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private void processAsset(Asset asset) {
        Boolean value;
        if (asset == null) {
            return;
        }
        String assetPath = asset.getPath();
        if ("SERIES/SEASON".equalsIgnoreCase(assetPath)) {
            this.metadataFields.addField("/" + assetPath + "/assetId", asset.getId());
        }
        if (this.missingFilesMap.containsKey(assetPath) && ((value = this.missingFilesMap.get(assetPath)) == null || !value.booleanValue())) {
            this.missingFilesMap.put(assetPath, this.isMissingOriginalFile(asset));
        }
        for (Field field : asset.getFields()) {
            String key = ElasticSearchUtil.createElasticSearchKey(assetPath, field.getTtvXPath());
            if (field.getParsable().booleanValue()) {
                this.processFieldForAdvancedSearch(asset, key, field);
                this.quickSearchBuilder.addField(field);
                continue;
            }
            this.unparsableFields.add(key);
        }
        for (Relation r : asset.getRelations()) {
            this.processAsset(r.getTargetAsset());
        }
    }

    private void handleDuration(String key, Object typedValue) {
        if ("/PACKAGE/TITLE/Fields/Duration/Duration".equalsIgnoreCase(key)) {
            Date date = (Date)typedValue;
            int hours = date.getHours();
            int mins = date.getMinutes();
            int secs = date.getSeconds();
            long duration = secs + 60 * mins + 3600 * hours;
            ElasticSearchUtil.addField(this.bld, "/PACKAGE/TITLE/durationSec", duration);
        }
    }

    private void handleTimeCode(String key, Object typedValue) {
        if (key.contains("/TimeCode")) {
            TimeCodeType timecode = (TimeCodeType)typedValue;
            this.metadataFields.addField(key + "Float", Float.valueOf(timecode.getFloatValue()));
        }
    }

    private void handleIsEmpty(String key) {
        String[] paths = key.split("/");
        StringBuilder strBld = new StringBuilder();
        for (int i = 1; i < paths.length - 1; ++i) {
            strBld.append("/");
            strBld.append(paths[i]);
            String partialXpath = strBld.toString();
            if (this.notEmptyXpaths.contains(partialXpath)) continue;
            this.notEmptyXpaths.add(partialXpath);
            ElasticSearchUtil.addField(this.bld, partialXpath, true);
        }
    }

    private void handleContentMapping(Asset asset, Field field) {
        try {
            if ("/Fields/Content/Locator/Uri".equals(field.getTtvXPath())) {
                File file = new File(field.getValue());
                String fileName = file.getName();
                String value = fileName + ";" + asset.getId();
                this.contentMapping.add(value);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Could not proccess file name for content mapping.", (Throwable)ex);
        }
    }

    private void processFieldForAdvancedSearch(Asset asset, String key, Field field) {
        Object typedValue = field.getTypedValue();
        this.metadataFields.addField(key, typedValue);
        this.handleDuration(key, typedValue);
        this.handleContentMapping(asset, field);
        this.handleTimeCode(key, typedValue);
        this.handleIsEmpty(key);
    }

    public Map<String, Object> updateTitle(Map<String, Object> oldSource, String distributionStatus) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        newFields.put("distributionStatus", distributionStatus);
        try {
            return TitleUpdateUtil.updateSource(oldSource, newFields);
        }
        catch (Exception ex) {
            logger.error((Object)"Could not update title source", (Throwable)ex);
            return null;
        }
    }
}

