/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.search.AdvancedSearchQueryBuilder;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.cmd.BaseSearchCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;

public class QuickSearchCommand
extends BaseSearchCommand {
    private String searchString;
    protected ExpNode rootNode;

    public QuickSearchCommand(String searchString, SearchParameters params) {
        this(searchString, params, null);
    }

    public QuickSearchCommand(String searchString, SearchParameters params, ExpNode rootNode) {
        super(params);
        this.searchString = searchString;
        this.rootNode = rootNode;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        try {
            BoolQueryBuilder queryFilter = null;
            if (this.searchString != null && this.searchString.trim().length() > 0) {
                QueryStringQueryBuilder query = QueryBuilders.queryStringQuery((String)this.searchString);
                query.defaultField("quickSearch");
                queryFilter = QueryBuilders.boolQuery().must((QueryBuilder)query);
            }
            TermsQueryBuilder partnerFilter = null;
            if (this.params.getPartnerIds() != null) {
                partnerFilter = QueryBuilders.termsQuery((String)"partnerId", (long[])this.params.getPartnerIds());
            }
            SearchRequestBuilder searchRequest = this.createSearchRequest(esConnection);
            if (this.params.getTitleIndexType() == ElasticSearchIndexType.SITE && this.params.getSiteId() != 0) {
                String siteStatusKey = ElasticSearchUtil.createSiteStatusKey(this.params.getSiteId());
                ExistsQueryBuilder siteFilter = this.params.getSiteStatus() == null ? QueryBuilders.existsQuery((String)siteStatusKey) : QueryBuilders.termQuery((String)siteStatusKey, (String)this.params.getSiteStatus().toLowerCase());
                BoolQueryBuilder andFilter = QueryBuilders.boolQuery().must((QueryBuilder)siteFilter);
                if (queryFilter != null) {
                    andFilter.must((QueryBuilder)queryFilter);
                }
                if (this.params.getPartnerIds() != null) {
                    andFilter.must((QueryBuilder)partnerFilter);
                }
                searchRequest.setPostFilter((QueryBuilder)andFilter);
            } else if (this.params.getPartnerIds() != null) {
                BoolQueryBuilder andFilter = QueryBuilders.boolQuery().must((QueryBuilder)partnerFilter);
                if (queryFilter != null) {
                    andFilter.must((QueryBuilder)queryFilter);
                }
                this.addQuickSearchFilter(andFilter);
                searchRequest.setPostFilter((QueryBuilder)andFilter);
            } else if (queryFilter != null) {
                BoolQueryBuilder andFilter = QueryBuilders.boolQuery().must((QueryBuilder)queryFilter);
                this.addQuickSearchFilter(andFilter);
                searchRequest.setPostFilter((QueryBuilder)andFilter);
            } else {
                searchRequest.setPostFilter((QueryBuilder)QueryBuilders.matchAllQuery());
            }
            this.search(esConnection, searchRequest);
            return true;
        }
        catch (Exception ex) {
            this.setException(ex);
            return false;
        }
    }

    protected void addQuickSearchFilter(BoolQueryBuilder andFilter) {
        if (this.rootNode != null) {
            AdvancedSearchQueryBuilder query = new AdvancedSearchQueryBuilder(this.params.getTitleIndexType());
            QueryBuilder rootFilter = query.build(this.rootNode);
            andFilter.must(rootFilter);
        }
    }
}

