/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchSeasonBuilder;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import org.apache.log4j.Logger;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SaveSeasonCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(SaveSeasonCommand.class);
    private Title title;
    private Asset season;

    public SaveSeasonCommand(Title title, Asset season) {
        super(ElasticSearchIndexType.SEASON);
        this.title = title;
        this.season = season;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient esClient = esConnection.getTransportClient();
        String strSeasonId = String.valueOf(this.season.getId());
        try {
            ElasticSearchSeasonBuilder bld = new ElasticSearchSeasonBuilder();
            XContentBuilder source = bld.createSeason(this.title, this.season);
            IndexRequestBuilder request = esClient.prepareIndex(this.indexName, this.typeName, strSeasonId);
            request.setSource(source);
            request.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not index season " + strSeasonId), (Throwable)ex);
            return false;
        }
    }
}

