/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.cmd;

import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchSiteTitleBuilder;
import com.ericsson.cms.search.cmd.BaseTitleCommand;
import com.ericsson.cms.search.cmd.GetSiteTitleStatusesWork;
import com.ericsson.cms.search.util.ElasticSearchConnection;
import com.ericsson.cms.search.util.SiteStatusCollection;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.util.Map;
import org.apache.log4j.Logger;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;

public class UpdateSiteStatusesCommand
extends BaseTitleCommand {
    private static Logger logger = Logger.getLogger(UpdateSiteStatusesCommand.class);
    private long titleId;
    private SiteStatusCollection statuses;

    public UpdateSiteStatusesCommand(long titleId) {
        this(titleId, null);
    }

    public UpdateSiteStatusesCommand(long titleId, SiteStatusCollection statuses) {
        super(ElasticSearchIndexType.SITE);
        this.titleId = titleId;
        this.statuses = statuses;
    }

    @Override
    public boolean run(ElasticSearchConnection esConnection) {
        TransportClient client = esConnection.getTransportClient();
        try {
            if (this.statuses == null) {
                GetSiteTitleStatusesWork work = new GetSiteTitleStatusesWork(this.titleId);
                Session session = HibernateContext.getContext().getCurrentSession();
                session.doWork((Work)work);
                this.statuses = work.getStatuses();
            }
            GetRequestBuilder request = client.prepareGet(this.indexName, this.typeName, String.valueOf(this.titleId));
            GetResponse response = (GetResponse)request.execute().actionGet(esConnection.getReadTimeoutMs());
            long version = response.getVersion();
            ElasticSearchSiteTitleBuilder titleBuilder = new ElasticSearchSiteTitleBuilder();
            Map source = response.getSourceAsMap();
            Map<String, Object> newSource = titleBuilder.updateTitle((Map<String, Object>)source, this.statuses);
            if (newSource == null) {
                return true;
            }
            IndexRequestBuilder saveRequest = client.prepareIndex(this.indexName, this.typeName, String.valueOf(this.titleId));
            saveRequest.setSource(newSource);
            saveRequest.setVersion(version);
            saveRequest.execute().actionGet(esConnection.getWriteTimeoutMs());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)("Could not update title " + this.titleId), (Throwable)ex);
            return false;
        }
    }
}

