/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.search.predicate.PredicateUtil;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RegexpQueryBuilder;

public class PredicateBuilderText {
    private static String REGEXP_RESERVED = ".?+*|{}[]()\"\\";
    private static String CONTAINS_RESERVED = ".?+*|{}[]()\"\\#&<>";

    private PredicateBuilderText() {
    }

    public static QueryBuilder doContains(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createContainsRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() == true;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return regexpFilter;
    }

    public static QueryBuilder doListContains(Predicate predicate) {
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createListContainsRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean isNot = predicate.getNot() != null && predicate.getNot() == true;
        return isNot ? QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key)) : regexpFilter;
    }

    public static QueryBuilder doStartsWith(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        PrefixQueryBuilder filter = QueryBuilders.prefixQuery((String)key, (String)value.toLowerCase());
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() == true;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)filter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return filter;
    }

    public static QueryBuilder doEndsWith(Predicate predicate) {
        boolean isNot;
        String key = PredicateUtil.getElasticSearchKey(predicate);
        if (key == null) {
            return null;
        }
        String value = PredicateUtil.getFirstRawStringValue(predicate, key);
        if (value == null) {
            return null;
        }
        String encodedValue = PredicateBuilderText.createEndsWithRegexp(value.toLowerCase());
        RegexpQueryBuilder regexpFilter = QueryBuilders.regexpQuery((String)key, (String)encodedValue);
        boolean bl = isNot = predicate.getNot() != null && predicate.getNot() == true;
        if (isNot) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)regexpFilter).must((QueryBuilder)QueryBuilders.existsQuery((String)key));
        }
        return regexpFilter;
    }

    public static String createEndsWithRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder(".*");
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (REGEXP_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
        }
        return bld.toString();
    }

    public static String createContainsRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder(".*");
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (CONTAINS_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
        }
        bld.append(".*");
        return bld.toString();
    }

    public static String createListContainsRegexp(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder bld = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (CONTAINS_RESERVED.indexOf(ch) >= 0) {
                bld.append('\\');
            }
            bld.append(ch);
        }
        return bld.toString();
    }
}

