/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search.predicate;

import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.predicate.PredicateBuilderDate;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.metadatamanager.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class PredicateUtil {
    private static Logger logger = Logger.getLogger(PredicateUtil.class);

    private PredicateUtil() {
    }

    public static String getAssetPath(Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        return FieldType.ASSET == predicate.getFieldTypeLhs() ? predicate.getFieldLeftSectionType() : null;
    }

    public static String getElasticSearchKey(Predicate predicate) {
        if (predicate == null) {
            logger.warn((Object)"Predicate is NULL.");
            return null;
        }
        String assetPath = PredicateUtil.getAssetPath(predicate);
        String fieldPath = predicate.getFieldLeft();
        return ElasticSearchUtil.createElasticSearchKey(assetPath, fieldPath);
    }

    public static Object createTypedObject(String value, String dataType) {
        if ("string".equalsIgnoreCase(dataType)) {
            return value.toLowerCase().trim();
        }
        if ("integer".equalsIgnoreCase(dataType) || "long".equalsIgnoreCase(dataType)) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (Exception ex) {
                logger.error((Object)("Could not parse " + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("float".equalsIgnoreCase(dataType) || "double".equalsIgnoreCase(dataType)) {
            try {
                return Double.parseDouble(value.trim());
            }
            catch (Exception ex) {
                logger.error((Object)("Could not parse " + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("date".equalsIgnoreCase(dataType)) {
            try {
                Date date = DateUtil.convertDate((String)value.trim());
                String strDate = PredicateBuilderDate.toElasticSearchDateString(date);
                return strDate;
            }
            catch (Exception ex) {
                logger.error((Object)("Could not parse " + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("time".equalsIgnoreCase(dataType)) {
            try {
                SimpleDateFormat fromFormat = new SimpleDateFormat("HH:mm:ss");
                Date time = fromFormat.parse(value.trim());
                String strTime = PredicateBuilderDate.toElasticSearchDateString(time);
                return strTime;
            }
            catch (Exception ex) {
                logger.error((Object)("Could not parse " + dataType), (Throwable)ex);
                return value;
            }
        }
        if ("boolean".equalsIgnoreCase(dataType)) {
            return "true".equalsIgnoreCase(value);
        }
        logger.error((Object)("Unknown data type " + dataType));
        return value;
    }

    public static Object getFirstValue(Predicate predicate, String key) {
        if (predicate == null) {
            logger.warn((Object)"Predicate is NULL.");
            return null;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.size() == 0) {
                logger.warn((Object)("Predicate value is NULL for key " + key));
                return null;
            }
            String dataType = predicate.getDataType();
            return PredicateUtil.createTypedObject((String)values.get(0), dataType);
        }
        logger.warn((Object)("Predicate value is NULL for key " + key));
        return null;
    }

    public static Object[] getValues(Predicate predicate, String key) {
        if (predicate == null) {
            logger.warn((Object)"Predicate is NULL.");
            return null;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.size() == 0) {
                logger.warn((Object)("Predicate value is NULL for key " + key));
                return null;
            }
            String dataType = predicate.getDataType();
            int size = values.size();
            Object[] array = new Object[size];
            for (int i = 0; i < size; ++i) {
                array[i] = PredicateUtil.createTypedObject((String)values.get(i), dataType);
            }
            return array;
        }
        logger.warn((Object)("Predicate value is NULL for key " + key));
        return null;
    }

    public static int getFirstIntValue(Predicate predicate, String key) {
        String str = PredicateUtil.getFirstRawStringValue(predicate, key);
        return Integer.parseInt(str);
    }

    public static String getFirstRawStringValue(Predicate predicate, String key) {
        if (predicate == null) {
            throw new RuntimeException("Predicate is NULL.");
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.isEmpty()) {
                throw new RuntimeException("Predicate value is NULL for key " + key);
            }
            return ((String)values.get(0)).trim();
        }
        throw new RuntimeException("Predicate value is NULL for key " + key);
    }

    public static String getSecondRawStringValue(Predicate predicate, String key) {
        if (predicate == null) {
            throw new RuntimeException("Predicate is NULL.");
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            if (values == null || values.size() < 2) {
                throw new RuntimeException("Second predicate value is NULL for key " + key);
            }
            return ((String)values.get(1)).trim();
        }
        throw new RuntimeException("Second predicate value is NULL for key " + key);
    }

    public static int getNumValues(Predicate predicate, String key) {
        if (predicate == null) {
            return 0;
        }
        if (predicate instanceof PredicateRightValue) {
            List values = ((PredicateRightValue)predicate).getValue();
            return values == null ? 0 : values.size();
        }
        return 0;
    }
}

