/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.image;

import com.tandbergtv.content.image.IThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGenerator;
import com.tandbergtv.content.image.ThumbnailGeneratorFactory;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class DefaultThumbnailGeneratorFactory
extends ThumbnailGeneratorFactory {
    private static final Logger logger = Logger.getLogger(DefaultThumbnailGeneratorFactory.class);
    private static final String PREFERRED_HEIGHT = "preferredHeight";
    private static final String PREFERRED_WIDTH = "preferredWidth";
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final int PREFERRED_HEIGHT_VALUE = 100;
    private static final int PREFERRED_WIDTH_VALUE = 100;
    private static final String OUTPUT_FORMAT_VALUE = "PNG";

    public DefaultThumbnailGeneratorFactory() {
        this.readPreferredHeight();
        this.readPreferredWidth();
        this.readOutputFormat();
    }

    public IThumbnailGenerator createThumbnailGenerator() {
        return new ThumbnailGenerator(this.getPreferredHeight(), this.getPreferredWidth(), this.getThumbnailFormat());
    }

    private void readPreferredHeight() {
        int height = -1;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName());
            String heightValue = bundle.getString(PREFERRED_HEIGHT);
            height = Integer.parseInt(heightValue);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the preffered thumbnail image height, using default value.", (Throwable)e);
        }
        if (height <= 0) {
            height = 100;
        }
        this.setPreferredHeight(height);
    }

    private void readPreferredWidth() {
        int width = -1;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName());
            String widthValue = bundle.getString(PREFERRED_WIDTH);
            width = Integer.parseInt(widthValue);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the preffered thumbnail image height, using default value.", (Throwable)e);
        }
        if (width <= 0) {
            width = 100;
        }
        this.setPreferredWidth(width);
    }

    private void readOutputFormat() {
        String format = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName());
            format = bundle.getString(OUTPUT_FORMAT);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to read the output format to use for thumbnail image, using default value.", (Throwable)e);
        }
        if (format == null || format.trim().length() == 0) {
            format = OUTPUT_FORMAT_VALUE;
        }
        this.setThumbnailFormat(format);
    }
}

