/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.lookupkey;

import com.tandbergtv.content.lookupkey.entities.LookupKey;
import com.tandbergtv.content.lookupkey.service.ILookupKeyManager;
import com.tandbergtv.content.lookupkey.service.LookupKeyValidationException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;

public class LookupKeyManager
implements ILookupKeyManager {
    private static final int NAME_SIZE = 50;
    private static final int DESCRIPTION_SIZE = 255;

    public LookupKey get(long id) {
        Session session = this.getSession();
        return (LookupKey)session.load(LookupKey.class, (Serializable)Long.valueOf(id));
    }

    public LookupKey save(LookupKey lookupKey) throws LookupKeyValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(lookupKey.getName())) {
            validationMessages.add("Name is required.");
        } else if (lookupKey.getName().length() > 50) {
            validationMessages.add("The maximum Name size is 50");
        }
        if (this.isBlank(lookupKey.getDescription())) {
            validationMessages.add("Description is required.");
        } else if (lookupKey.getDescription().length() > 255) {
            validationMessages.add("The maximum Description size is 255");
        }
        LookupKey lookupKeyDB = this.getByName(lookupKey.getName());
        if (lookupKey.getId() == null && lookupKeyDB != null) {
            validationMessages.add("The LookupKey Name must be unique.");
        } else if (!(lookupKey.getId() == null || lookupKeyDB != null && lookupKey.getId().equals(lookupKeyDB.getId()))) {
            validationMessages.add("The LookupKey Name cannot be changed.");
        }
        if (!validationMessages.isEmpty()) {
            throw new LookupKeyValidationException(validationMessages);
        }
        try {
            Session session = this.getSession();
            if (lookupKeyDB != null) {
                session.evict((Object)lookupKeyDB);
            }
            session.saveOrUpdate((Object)lookupKey);
            return lookupKey;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save LookupKey: " + lookupKey, e);
        }
    }

    public List<LookupKey> getLookupKeys() {
        return this.getLookupKeys("name", true);
    }

    public List<LookupKey> getLookupKeys(String sortByProperty, boolean isAscending) {
        if (!sortByProperty.equalsIgnoreCase("name") && !sortByProperty.equalsIgnoreCase("description")) {
            throw new RuntimeException("Invalid sort property: " + sortByProperty);
        }
        Session session = this.getSession();
        String queryStr = "FROM com.tandbergtv.content.lookupkey.entities.LookupKey ORDER BY " + sortByProperty;
        queryStr = isAscending ? queryStr + " ASC" : queryStr + " DESC";
        Query query = session.createQuery(queryStr);
        return query.list();
    }

    public List<LookupKey> getLookupKeysByAssetType(String assetType) {
        Session session = this.getSession();
        String queryStr = "SELECT lk FROM com.tandbergtv.content.lookupkey.entities.LookupKey lk INNER JOIN lk.assetTypes AS at WHERE at = :asset_type";
        Query query = session.createQuery(queryStr);
        query.setParameter("asset_type", (Object)assetType);
        return query.list();
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private LookupKey getByName(String name) {
        String queryStr;
        LookupKey lookupKey = null;
        Session session = this.getSession();
        Query query = session.createQuery(queryStr = "SELECT lk FROM com.tandbergtv.content.lookupkey.entities.LookupKey lk WHERE lk.name = '" + name + "'");
        List lookupKeys = query.list();
        if (lookupKeys.size() == 1) {
            lookupKey = (LookupKey)lookupKeys.get(0);
        }
        return lookupKey;
    }

    public String getServiceName() {
        return "LookupKeyManagerService";
    }

    public void start() {
    }

    public void stop() {
    }

    public int delete(long lookupKeyId) throws LookupKeyValidationException {
        this.deleteLookupKeysAssetType(lookupKeyId);
        Session session = this.getSession();
        String queryStr = "DELETE FROM com.tandbergtv.content.lookupkey.entities.LookupKey WHERE id = :lookupkyeId";
        Query query = session.createQuery(queryStr);
        query.setParameter("lookupkyeId", (Object)lookupKeyId);
        int rowsAffected = query.executeUpdate();
        return rowsAffected;
    }

    private void deleteLookupKeysAssetType(long lookupKeyId) throws LookupKeyValidationException {
        Session session = this.getSession();
        String queryStr = "DELETE FROM cms_lookup_key_asset_type WHERE id_lookup_key = :lookupkyeId";
        SQLQuery query = session.createSQLQuery(queryStr);
        query.setParameter("lookupkyeId", (Object)lookupKeyId);
        query.executeUpdate();
    }
}

