/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListPersistenceService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.AssetList;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class AssetListPersistenceService<E extends AssetList>
implements IAssetListPersistenceService<E> {
    private Logger logger = Logger.getLogger(this.getClass());
    private String serviceName;

    public AssetListPersistenceService(String serviceName) {
        this.serviceName = serviceName;
    }

    @Transactional
    public void delete(Serializable id) {
        try {
            this.delete(this.get(id));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete enity with id: " + id, e);
        }
    }

    @Transactional
    public void delete(E entity) {
        try {
            Session session = this.getSession();
            entity.setIsActive(Boolean.valueOf(false));
            entity.removeTitles();
            session.saveOrUpdate(entity);
            this.logger.debug((Object)("Deleted entity " + entity));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete " + entity, e);
        }
    }

    @Transactional
    public E get(Serializable id) {
        Session session = this.getSession();
        return (E)((AssetList)session.load(AssetList.class, id));
    }

    @Transactional
    public E save(E entity) {
        try {
            Session session = this.getSession();
            session.saveOrUpdate(entity);
            this.logger.debug((Object)("Updated: " + entity));
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save " + entity, e);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public void addTitles(long assetListId, List<Long> titleIds) {
        E entity = this.get(Long.valueOf(assetListId));
        ArrayList<Title> titlesToAdd = new ArrayList<Title>();
        for (long id : titleIds) {
            Title title = this.getTitleManager().get(Long.valueOf(id));
            if (!title.getIsActive().booleanValue()) {
                throw new RuntimeException("Cannot add inactive title[" + id + "] to the asset list[" + assetListId + "].");
            }
            titlesToAdd.add(title);
        }
        entity.addTitles(titlesToAdd);
        this.save(entity);
    }

    @Transactional
    public void removeTitles(long assetListId, List<Long> titleIds) {
        E entity = this.get(Long.valueOf(assetListId));
        ArrayList<Title> titlesToRemove = new ArrayList<Title>();
        for (Title t : entity.getTitles()) {
            if (!titleIds.contains(t.getId())) continue;
            titlesToRemove.add(t);
        }
        entity.removeTitles(titlesToRemove);
        this.save(entity);
    }

    private ITitleManager getTitleManager() {
        return (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

