/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.assetlist;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.assetlist.IAssetListSearchService;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.IAssetList;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;

public class AssetListSearchService<L extends IAssetList>
implements IAssetListSearchService<L> {
    private Logger logger = Logger.getLogger(this.getClass());
    private String serviceName;

    public AssetListSearchService(String serviceName) {
        this.serviceName = serviceName;
    }

    @Transactional
    public int count(SearchCriteria criteria) {
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        this.logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        Session session = this.getSession();
        Query query = session.createQuery(s);
        long count = (Long)query.uniqueResult();
        return (int)count;
    }

    @Transactional
    public Collection<L> search(SearchCriteria criteria) {
        String s = this.getQuery(criteria);
        this.logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        Session session = this.getSession();
        Query query = session.createQuery(s);
        query.setFirstResult(criteria.getStartingRecordNumber());
        query.setMaxResults(criteria.getRecordsCount() == 0 ? Integer.MAX_VALUE : criteria.getRecordsCount());
        return query.list();
    }

    public String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void start() {
    }

    public void stop() {
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }
}

