/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class GetContextIdMessageHandler
implements MessageHandler {
    private static final String LOOKUP_KEY = "lookupKey";
    private static final String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    private static final String CONTEXT_ID = "contextId";
    private static final String DEFAULT_VALUE = "";
    private static ICacheService<IContainer> containerCache;

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        Util.validateRequired(message, LOOKUP_KEY);
        String lookupKey = Util.getStringValueTrimmed(message, LOOKUP_KEY);
        String contextId = this.search(lookupKey);
        WorkflowMessage response = new WorkflowMessage(message.getMessageUID(), message.getKey(), WorkflowMessage.MessageType.ack);
        response.putValue(CONTEXT_ID, contextId);
        return response;
    }

    private String search(String value) {
        String contextIdMatchingProviderId = DEFAULT_VALUE;
        for (Serializable key : GetContextIdMessageHandler.getCacheService().getKeys()) {
            Partner patrner = (Partner)containerCache.get(key);
            if (this.isMatched(value, patrner.getLookupKey())) {
                return key.toString();
            }
            if (!DEFAULT_VALUE.equals(contextIdMatchingProviderId) || !this.isMatched(value, patrner.getProviderId())) continue;
            contextIdMatchingProviderId = key.toString();
        }
        return contextIdMatchingProviderId;
    }

    private boolean isMatched(String expected, String actual) {
        return StringUtils.isNotBlank((String)actual) && expected.equals(actual.trim());
    }

    private static ICacheService<IContainer> getCacheService() {
        if (Objects.isNull(containerCache)) {
            containerCache = (ICacheService)ServiceRegistry.getDefault().lookup(CONTAINER_CACHE_SERVICE_NAME);
        }
        return containerCache;
    }
}

