/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.communication.handlers;

import com.tandbergtv.watchpoint.communication.Util;
import com.tandbergtv.watchpoint.communication.config.MessageHandler;
import com.tandbergtv.watchpoint.communication.config.MessageHandlerException;
import com.tandbergtv.watchpoint.pmm.entities.ContainerProperty;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.util.ContextManager;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;

public class GetNamedContainerProperty
implements MessageHandler {
    protected static final String CONTEXT_ID = "contextId";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PROPERTY_VALUE = "value";
    protected static final String CONTEXT_NOT_FOUND = "Entity associated with the given context does not exist.";
    protected static final String PROPERTY_NOT_FOUND = "Named property does not not exist for the given context.";

    @Override
    public WorkflowMessage handleMessage(WorkflowMessage message) throws Exception {
        this.validateRequest(message);
        Long contextId = Util.getLongValue(message, CONTEXT_ID);
        Context context = ContextManager.getInstance().getContext(contextId.longValue());
        if (context == null) {
            throw new MessageHandlerException("ERR-003", CONTEXT_NOT_FOUND);
        }
        return this.constructResponse(context, message);
    }

    protected void validateRequest(WorkflowMessage message) {
        Util.validateRequired(message, CONTEXT_ID, PROPERTY_NAME);
    }

    protected WorkflowMessage constructResponse(Context context, WorkflowMessage message) throws Exception {
        String propertyName = Util.getStringValueTrimmed(message, PROPERTY_NAME);
        ContainerProperty property = context.propertyExists(propertyName);
        if (property == null) {
            throw new MessageHandlerException("ERR-003", PROPERTY_NOT_FOUND);
        }
        IMessageUID uid = message.getMessageUID();
        IMessageKey key = message.getKey();
        WorkflowMessage response = new WorkflowMessage(uid, key, WorkflowMessage.MessageType.ack);
        response.putValue(PROPERTY_VALUE, property.getValue());
        return response;
    }
}

