/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.core;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.watchpoint.pmm.util.PMMProperties;
import java.util.List;
import org.apache.log4j.Logger;

public class PMMUtil {
    private static final Logger logger = Logger.getLogger(PMMUtil.class);
    private static String UNMAPPED_FILE_FILTER_FIELD = "unmappedFileFilterField";
    private static String FILTER_FIELD_DELIMITER = ",";

    public static String getPathFilterFieldValue(Asset rootAsset) {
        String filterField = PMMProperties.getInstance().getProperty(UNMAPPED_FILE_FILTER_FIELD);
        String[] filterFieldBits = filterField.split(FILTER_FIELD_DELIMITER);
        if (filterFieldBits.length == 2) {
            List assets;
            String itemType = filterFieldBits[0];
            String ttvXpath = filterFieldBits[1];
            String seriesType = Group.GroupType.SERIES.name();
            String packageType = Group.GroupType.PACKAGE.name();
            if (rootAsset.getAssetType().equalsIgnoreCase(seriesType) && itemType.equalsIgnoreCase(packageType)) {
                itemType = seriesType;
            }
            if ((assets = rootAsset.getAllAssetsOfType(itemType)) == null || assets.size() == 0) {
                return null;
            }
            Field f = ((Asset)assets.get(0)).getFirstField(ttvXpath);
            if (f == null || f.getValue() == null || f.getValue().trim().length() == 0) {
                return null;
            }
            return f.getValue();
        }
        return null;
    }
}

