/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.ericsson.cms.scheduler.IScheduler;
import com.ericsson.cms.search.PartnerSearchColumn;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalRegister;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.entities.ContentClassPartner;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.util.SecurityInfo;
import com.tandbergtv.watchpoint.pmm.core.PMMException;
import com.tandbergtv.watchpoint.pmm.core.PMMMultiplePartnersFoundException;
import com.tandbergtv.watchpoint.pmm.core.PMMPartnerNotFoundException;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerContact;
import com.tandbergtv.watchpoint.pmm.entities.PartnerThumbnail;
import com.tandbergtv.watchpoint.pmm.entities.PartnerType;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.partner.dao.PartnerHDAO;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.pmm.title.ContainerCacheMessage;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.util.DataOperationException;
import com.tandbergtv.watchpoint.pmm.util.DistributedTopic;
import com.tandbergtv.watchpoint.pmm.util.LocalizedMessageUtil;
import com.tandbergtv.watchpoint.pmm.util.ParterSearchCriteriaUtil;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.util.CollectionUtils;

public class PartnerManager
implements IPartnerManagement {
    private static final long serialVersionUID = -4872778570643399528L;
    private static final Logger logger = Logger.getLogger(PartnerManager.class);
    private static final String CONTAINER_CACHE_SERVICE_NAME = "Container Cache";
    IPartnerUserManager pUserManager;
    List<Long> processedPartnersIdList;
    IScheduler scheduler;
    IScheduleSearchService searchService;
    IContentClassService contentClassService;
    private static LocalizedMessageUtil messageUtil = new LocalizedMessageUtil("partner", "com.tandbergtv.watchpoint.pmm.partner.messages.DataOperationMessages");

    @Transactional
    public List<Partner> getPartnersBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        List<Partner> partnerList = null;
        try {
            long t1 = System.currentTimeMillis();
            String userName = this.getUserForPartnersDataSegmentation();
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Time to get user for partner data segmentation:" + (t2 - t1)));
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findActiveBySearchCriteria(userName, searchCriteria, false, false, null, true, types);
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time to get partners from db:" + (t3 - t2)));
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.retrieve"), e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    @Transactional
    public List<Partner> getActiveTopPartnersForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        return this.getActivePartnersForCurrentUser(searchCriteria, true, true, null, true, types);
    }

    @Transactional
    public List<Partner> getActiveTopPartnersForCurrentUserInSpecificList(SearchCriteria searchCriteria, List<Partner> searchPartners, PartnerType ... types) {
        return this.getActivePartnersForCurrentUser(searchCriteria, true, false, searchPartners, false, types);
    }

    private List<Partner> getActivePartnersForCurrentUser(SearchCriteria searchCriteria, boolean isTopLevel, boolean fetchTopLevlForMatchedChildren, List<Partner> searchPartners, boolean pageLimitation, PartnerType ... types) {
        List<Partner> partnerList = null;
        try {
            long t1 = System.currentTimeMillis();
            String userName = this.getUserForPartnersDataSegmentation();
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Time to get user for partner data segmentation:" + (t2 - t1)));
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerList = partnerDAO.findActiveBySearchCriteria(userName, searchCriteria, isTopLevel, fetchTopLevlForMatchedChildren, searchPartners, pageLimitation, types);
            long t3 = System.currentTimeMillis();
            logger.debug((Object)("Time to get partners from db:" + (t3 - t2)));
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.retrieve"), e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partnerList;
    }

    @Transactional
    private List<Partner> getPartnersBySearchCriteriaForCurrentUserWithChildren(PartnerType ... types) {
        List partnerIdList = new ArrayList();
        ArrayList<Partner> partners = new ArrayList<Partner>();
        try {
            String userName = this.getUserForPartnersDataSegmentation();
            String queryStr = this.getActivePartnersContextIdQuery(userName);
            String orderClause = " order by substring(partner.AFFILIATION_CODE, 1, 10) asc, length(partner.AFFILIATION_CODE) asc";
            String typeClause = "";
            if (types != null && types.length != 0) {
                typeClause = String.format(" and partner.PARTNERTYPE IN ( %s )  ", org.springframework.util.StringUtils.collectionToCommaDelimitedString(this.getTypeIdList(types)));
            }
            queryStr = queryStr + typeClause + orderClause;
            Session session = this.getSession();
            SQLQuery sqlQuery = session.createSQLQuery(queryStr);
            sqlQuery.addScalar("contextid", (Type)StandardBasicTypes.LONG);
            if (userName != null) {
                sqlQuery.setParameter("userName", (Object)userName);
            }
            partnerIdList = sqlQuery.list();
            for (Long contextId : partnerIdList) {
                Partner partner = this.getPartnerByContextId(contextId);
                partner.setChildPartnerList(null);
                partners.add(partner);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.retrieve"), e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return partners;
    }

    @Transactional
    public int getTopLevelPartnersCountBySearchCriteriaForCurrentUser(SearchCriteria searchCriteria, PartnerType ... types) {
        int count = 0;
        try {
            String userName = this.getUserForPartnersDataSegmentation();
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            count = partnerDAO.findTopLevelCountActiveBySearchCriteria(userName, searchCriteria, types);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.retrieve"), e);
        }
        catch (Throwable t) {
            logger.error((Object)"Error while searching for partners: ", t);
        }
        return count;
    }

    @Transactional
    public List<Partner> getAllActivePartnersForCurrentUser() {
        return this.getPartnersBySearchCriteriaForCurrentUser(null, new PartnerType[0]);
    }

    @Transactional
    public List<Partner> getAllActivePartnersForCurrentUserWithChildren() {
        this.processedPartnersIdList = new ArrayList<Long>();
        ArrayList<Partner> resultList = new ArrayList<Partner>();
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)new ValueParameter("isActive", SearchType.NUMERIC, (Object)1));
        long t1 = System.currentTimeMillis();
        List<Partner> partnerList = this.getPartnersBySearchCriteriaForCurrentUserWithChildren(PartnerType.SELF, PartnerType.SOURCE);
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time to get all partners from partnerHDAO:" + (t2 - t1)));
        List<Partner> topParentList = this.getAllTopParentList(partnerList);
        long t3 = System.currentTimeMillis();
        logger.debug((Object)("Time to process parent list form all partners:" + (t3 - t2)));
        if (!CollectionUtils.isEmpty(topParentList)) {
            for (Partner partner : topParentList) {
                List<Partner> allChildren = this.getChildrenForPartner(partner, partnerList);
                this.addPartnerTreeChild(allChildren, partner);
            }
            resultList.addAll(topParentList);
        }
        long t4 = System.currentTimeMillis();
        logger.debug((Object)("Time to build hierarchy of partners  step1:" + (t4 - t3)));
        List<Partner> independentChildList = this.getIndependentChildren(partnerList, resultList);
        if (!CollectionUtils.isEmpty(independentChildList)) {
            for (Partner partner : independentChildList) {
                List<Partner> allChildren = this.getChildrenForPartner(partner, independentChildList);
                if (!CollectionUtils.isEmpty(allChildren)) {
                    this.addPartnerTreeChild(allChildren, partner);
                }
                if (this.contains(partner.getId())) continue;
                resultList.add(partner);
                this.processedPartnersIdList.add(partner.getId());
            }
        }
        long t5 = System.currentTimeMillis();
        logger.debug((Object)("Time to add independent children partners:" + (t5 - t4)));
        return resultList;
    }

    private boolean contains(long id) {
        for (Long pId : this.processedPartnersIdList) {
            if (id != pId) continue;
            return true;
        }
        return false;
    }

    private List<Partner> getChildrenForPartner(Partner partner, List<Partner> independentChidList) {
        ArrayList<Partner> childList = new ArrayList<Partner>();
        String aCode = partner.getAffiliationCode();
        if (aCode == null) {
            return childList;
        }
        for (Partner p : independentChidList) {
            if (p.getAffiliationCode() == null || !p.getAffiliationCode().startsWith(aCode) || p.getAffiliationCode().length() <= aCode.length()) continue;
            childList.add(p);
        }
        return childList;
    }

    private List<Partner> getIndependentChildren(List<Partner> partnerList, List<Partner> resultList) {
        ArrayList<Partner> childList = new ArrayList<Partner>();
        for (Partner partner : partnerList) {
            if (resultList.contains(partner)) continue;
            childList.add(partner);
        }
        return childList;
    }

    private List<Partner> getAllTopParentList(List<Partner> partnerList) {
        partnerList.forEach(p -> p.setChildPartnerList(null));
        return partnerList.stream().filter(Partner::isTopLevelPartner).collect(Collectors.toList());
    }

    private void addPartnerTreeChild(List<Partner> childList, Partner p) {
        if (p.getAffiliationCode() == null || CollectionUtils.isEmpty(childList)) {
            return;
        }
        int parentParentCodeLen = p.getAffiliationCode().length();
        for (Partner partner : childList) {
            String code = partner.getAffiliationCode();
            if (code == null || !code.startsWith(p.getAffiliationCode()) || code.length() != Partner.MIN_AFFILIATION_CODE_LEN + parentParentCodeLen || this.contains(partner.getId())) continue;
            p.addChildPartnerList(partner);
            this.processedPartnersIdList.add(partner.getId());
            this.addPartnerTreeChild(childList, partner);
        }
    }

    @Transactional
    public List<Partner> getAllActivePartnerDTOsForCurrentUser() {
        ArrayList<Partner> partners = new ArrayList<Partner>();
        String userName = this.getUserForPartnersDataSegmentation();
        String queryStr = this.getActivePartnersQuery(userName);
        Session session = this.getSession();
        SQLQuery sqlQuery = session.createSQLQuery(queryStr);
        sqlQuery.addScalar("id_", (Type)StandardBasicTypes.LONG).addScalar("name").addScalar("partnerTypeName").addScalar("isactive", (Type)StandardBasicTypes.BOOLEAN).addScalar("lookupkey").addScalar("notes").addScalar("providerid");
        if (userName != null) {
            sqlQuery.setParameter("userName", (Object)userName);
        }
        List resultsList = sqlQuery.list();
        for (Object[] resultRow : resultsList) {
            Partner partner = new Partner(((Long)resultRow[0]).longValue());
            String partnerName = (String)resultRow[1];
            String partnerTypeName = (String)resultRow[2];
            Boolean isActive = (Boolean)resultRow[3];
            String lookupKey = (String)resultRow[4];
            String notes = (String)resultRow[5];
            String providerId = (String)resultRow[6];
            PartnerType partnerType = PartnerType.valueOf((String)partnerTypeName);
            partner.setName(partnerName);
            partner.setType(partnerType);
            partner.setIsActive(isActive);
            lookupKey = lookupKey != null ? lookupKey.trim() : "";
            partner.setLookupKey(lookupKey);
            partner.setNotes(notes);
            partner.setProviderId(providerId);
            partners.add(partner);
        }
        return partners;
    }

    protected Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    protected String getActivePartnersQuery(String userName) {
        String queryStr = "select partner.id_, partner.name, partnerType.name as partnerTypeName, partner.isactive, partner.lookupkey, partner.notes, partner.providerid from pmm_partner partner, pmm_partnertype partnerType where partner.isactive = 1 and partner.partnertype = partnerType.id_ ";
        if (userName != null) {
            queryStr = queryStr + "and partner.id_ IN \t        (SELECT partnerUser.PARTNER_ID from PMM_PARTNER_USERS partnerUser \t        WHERE partnerUser.USERNAME = :userName) ";
        }
        return queryStr;
    }

    protected String getActivePartnersContextIdQuery(String userName) {
        String queryStr = "select partner.contextid from pmm_partner partner, pmm_partnertype partnerType where partner.isactive = 1 and partner.partnertype = partnerType.id_ ";
        if (userName != null) {
            queryStr = queryStr + "and partner.id_ IN \t        (SELECT partnerUser.PARTNER_ID from PMM_PARTNER_USERS partnerUser \t        WHERE partnerUser.USERNAME = :userName) ";
        }
        return queryStr;
    }

    private String getUserForPartnersDataSegmentation() {
        String userName;
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
        if (partnerUserManager.isSelfPartnerUser(userName = SecurityInfo.getCallerPrincipal().getName())) {
            userName = null;
        }
        return userName;
    }

    @Transactional
    public Partner createPartner(Partner partner) {
        partner.setIsActive(Boolean.valueOf(true));
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.create(partner);
            if (partner.getType() != PartnerType.DISTRIBUTION) {
                this.associatePartnerWithContentClasses(partner);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.create"), e);
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterSave(partner));
        return partner;
    }

    private void associatePartnerWithContentClasses(Partner partner) throws ContentClassPersistenceException {
        this.contentClassService = this.getContentClassService();
        Long defaultContentClassId = this.contentClassService.getDefaultContentClassId();
        this.contentClassService.saveContentClassPartner(new ContentClassPartner(defaultContentClassId.longValue(), partner.getId()));
        Long categoryContentClassId = this.contentClassService.getCategoryContentClassId();
        this.contentClassService.saveContentClassPartner(new ContentClassPartner(categoryContentClassId.longValue(), partner.getId()));
        Long seriesContentClassId = this.contentClassService.getSeriesContentClassId();
        this.contentClassService.saveContentClassPartner(new ContentClassPartner(seriesContentClassId.longValue(), partner.getId()));
        Long offerContentClassId = this.contentClassService.getOfferContentClassId();
        this.contentClassService.saveContentClassPartner(new ContentClassPartner(offerContentClassId.longValue(), partner.getId()));
    }

    @Transactional
    public Partner createPartnerCopy(Partner copiedPartner, long originalPartnerId) {
        throw new RuntimeException(messageUtil.getMessageValue("partner.error.method.not.implemented"));
    }

    @Transactional
    public boolean hasChildPartners(long partnerId) {
        List<Partner> childPartners = this.findAllChildPartners(partnerId);
        return !CollectionUtils.isEmpty(childPartners);
    }

    @Transactional
    public synchronized boolean deletePartner(long partnerId) throws DataOperationException {
        Partner partner = this.getPartner(partnerId);
        long contextId = partner.getContainerContextId();
        List lsJobs = PartnerType.SELF.equals((Object)partner.getType()) ? this.getScheduler().getJobsByAssociatedEntityType(PartnerType.SELF.name()) : this.getScheduler().getJobsByAssociatedEntity(partner.getType().name(), partnerId);
        if (!CollectionUtils.isEmpty((Collection)lsJobs)) {
            String message = messageUtil.getMessageValue("partner.error.jobs.associated", new Object[]{partnerId});
            logger.error((Object)("Partner [" + partnerId + "] cannot be deleted since there are jobs associated with it."));
            throw new DataOperationException(message, "partner.error.jobs.associated");
        }
        int schedulesCount = 0;
        PartnerType partnerType = partner.getType();
        if (partnerType == PartnerType.SOURCE) {
            schedulesCount = this.countPlanners(partnerId);
        } else if (partnerType == PartnerType.DISTRIBUTION) {
            schedulesCount = this.countPitchSchedules(contextId);
        }
        if (schedulesCount > 0) {
            String message = messageUtil.getMessageValue("partner.error.schedule.associated", new Object[]{partnerId});
            logger.error((Object)("Partner [" + partnerId + "] cannot be deleted since there are schedules associated with it."));
            throw new DataOperationException(message, "partner.error.schedule.associated");
        }
        if (this.anyTitleAssociatedWithPartner(partnerId)) {
            String message = messageUtil.getMessageValue("partner.error.titles.associated", new Object[]{partnerId});
            logger.error((Object)("Partner [" + partnerId + "] cannot be deleted since there are titles associated."));
            throw new DataOperationException(message, "partner.error.titles.associated");
        }
        try {
            List contentClasses = this.getContentClassService().getPartnerContentClassesWithoutMetadata(partnerId);
            if (contentClasses != null) {
                for (ContentClass cc : contentClasses) {
                    if (cc.isDefault() || cc.getType() == ContentClass.Type.Category || cc.getType() == ContentClass.Type.Series || cc.getType() == ContentClass.Type.Offer) {
                        this.getContentClassService().deleteContentClassPartner(new ContentClassPartner(cc.getId(), partnerId));
                        continue;
                    }
                    String message = messageUtil.getMessageValue("partner.error.contentclass.associated", new Object[]{partnerId});
                    logger.error((Object)("Partner [" + partnerId + "] cannot be deleted since there are user-defined content classes associated."));
                    throw new DataOperationException(message, "partner.error.contentclass.associated");
                }
            }
        }
        catch (ContentClassPersistenceException e) {
            String message = messageUtil.getMessageValue("partner.error.contentclass.dissociating", new Object[]{partnerId});
            logger.error((Object)("Partner [" + partnerId + "] cannot be deleted since failed to dissociating content classes from partner."), (Throwable)e);
            throw new DataOperationException(message, "partner.error.contentclass.dissociating");
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partner.setIsActive(Boolean.valueOf(false));
            partner.setIsTenant(Boolean.valueOf(false));
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            logger.error((Object)("Error while deleting partner (id: " + partnerId + "): "), (Throwable)e);
            return false;
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterDelete(partner));
        return true;
    }

    private boolean anyTitleAssociatedWithPartner(long partnerId) {
        String sql = "select id_ from pmm_title where titlestatusid <> 5 and partner_id = ?";
        Session session = HibernateContext.getContext().getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.setLong(0, partnerId);
        query.addScalar("id_", (Type)StandardBasicTypes.LONG);
        query.setMaxResults(1);
        return query.uniqueResult() != null;
    }

    @Transactional
    public int countPitchSchedules(Long contextId) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("pitch", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        criteria.addParameter((SearchParameterBase)e);
        return this.getScheduleSearchService().count(criteria);
    }

    private int countPlanners(long partnerId) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter("sourcePartnerID", SearchType.NUMERIC, (Object)partnerId));
        criteria.addParameter((SearchParameterBase)e);
        return this.getScheduleSearchService().count(criteria);
    }

    @Transactional
    public Partner getPartner(long partnerId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return (Partner)partnerDAO.findByKey(partnerId);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get"), e);
        }
    }

    @Transactional
    public Partner getPartnerByContextId(long contextId) {
        return (Partner)this.getContainerCacheService().get((Serializable)Long.valueOf(contextId));
    }

    @Transactional
    public Partner getPartnerByName(String name) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findByName(name);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get"), e);
        }
    }

    @Transactional
    public Partner getPartnerByProviderId(String providerId) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findByProviderId(providerId);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get"), e);
        }
    }

    @Transactional
    public Partner getPartnerByLookupKey(String lookupKey) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findByLookupKey(lookupKey);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get"), e);
        }
    }

    @Transactional
    public List<Partner> findAllChildPartners(long id) {
        try {
            String affiliationCode = this.getPartner(id).getAffiliationCode();
            return this.findAllChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get.child"), e);
        }
    }

    @Transactional
    public List<Partner> findPartnersWithChildPartnersLevel(String affilidationCode, int level) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findPartnersWithChildPartnersLevel(affilidationCode, level);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get.child"), e);
        }
    }

    @Transactional
    public List<Partner> findAllChildPartners(String affiliationCode) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findAllChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get.child"), e);
        }
    }

    @Transactional
    public List<Partner> findDirectChildPartners(String affiliationCode) {
        if (affiliationCode == null) {
            return new ArrayList<Partner>();
        }
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findDirectChildPartners(affiliationCode);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.get.child"), e);
        }
    }

    @Transactional
    public List<Partner> getAllActivePartners() {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            return partnerDAO.findByActive(true);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.retrieve"), e);
        }
    }

    @Transactional
    public synchronized Partner updatePartner(Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            partnerDAO.update(partner);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.update"), e);
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterSave(partner));
        return partner;
    }

    @Transactional
    public void updateServicePartner(Partner partner) {
        try {
            Session session = HibernateContext.getContext().getCurrentSession();
            PartnerHDAO partnerDAO = new PartnerHDAO(session);
            Partner p = (Partner)partnerDAO.findByKey(partner.getId());
            session.evict((Object)p);
            this.copy(p, partner);
            partnerDAO.update(p);
        }
        catch (Exception e) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.update"), e);
        }
        TransactionalRegister.getInstance().registerCommitCallback(t -> this.syncAfterSave(partner));
    }

    private void copy(Partner to, Partner from) {
        to.setProviderId(from.getProviderId());
        to.setLookupKey(from.getLookupKey());
        PartnerContact updatedContact = from.getContact();
        PartnerContact existingContact = to.getContact();
        List existingPropList = to.getProperties();
        if (existingContact != null) {
            if (updatedContact != null) {
                existingContact.setFirstName(updatedContact.getFirstName());
                existingContact.setLastName(updatedContact.getLastName());
                existingContact.setEmail(updatedContact.getEmail());
                if (existingPropList != null) {
                    to.updateProperties(from.getProperties());
                } else {
                    to.setProperties(from.getProperties());
                }
            } else {
                existingContact.setFirstName(null);
                existingContact.setLastName(null);
                existingContact.setEmail(null);
                if (existingPropList != null) {
                    to.updateProperties(null);
                }
            }
        }
    }

    public Partner getSourcePartner(String providerId) throws PMMException {
        return this.getPartnerOfType(providerId, PartnerType.SOURCE);
    }

    public Partner getSourceOrSelfPartner(String providerId) throws PMMException {
        return this.getPartnerOfType(providerId, PartnerType.SOURCE, PartnerType.SELF);
    }

    private Partner getPartnerOfType(String providerId, PartnerType ... allowedTypes) throws PMMException {
        boolean isProviderIdCaseSensitive = TitleUtil.isProviderIdCaseSensitive();
        return this.getPartnerOfType(providerId, isProviderIdCaseSensitive, allowedTypes);
    }

    private Partner getPartnerOfType(String providerId, boolean isCaseSensitive, PartnerType ... allowedTypes) throws PMMException {
        long start = System.currentTimeMillis();
        ArrayList<Partner> resultList = new ArrayList<Partner>();
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        for (Serializable key : containerCache.getKeys()) {
            Partner partner;
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || StringUtils.isBlank((String)(partner = (Partner)container).getProviderId()) || !TitleUtil.compareProviderId(partner.getProviderId(), providerId, isCaseSensitive) || !this.isPartnerTypeInArray(allowedTypes, partner)) continue;
            resultList.add(partner);
        }
        logger.debug((Object)("Time taken to getPartnerOfType - time: " + (System.currentTimeMillis() - start)));
        if (resultList.isEmpty()) {
            throw new PMMPartnerNotFoundException(messageUtil.getMessageValue("partner.error.not.find.providerid", new Object[]{providerId}));
        }
        if (resultList.size() > 1) {
            throw new PMMMultiplePartnersFoundException(messageUtil.getMessageValue("partner.error.multiple.not.find.providerid", new Object[]{providerId}));
        }
        return (Partner)resultList.get(0);
    }

    public boolean isPartnersDuplicatedInNameCaseInsensitive() {
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        for (Serializable key : containerCache.getKeys()) {
            IContainer container = (IContainer)containerCache.get(key);
            if (container.getContainerType() != ContainerType.PARTNER || StringUtils.isBlank((String)((Partner)container).getProviderId())) continue;
            String providerId = ((Partner)container).getProviderId();
            try {
                this.getPartnerOfType(providerId, false, PartnerType.SOURCE, PartnerType.SELF);
            }
            catch (PMMMultiplePartnersFoundException pmme) {
                return true;
            }
            catch (PMMException pMMException) {
            }
        }
        return false;
    }

    public String checkDuplicateProviderIdPartner(String providerId, Long partnerId) {
        boolean isDuplicated = false;
        Partner partnerFound = null;
        boolean isProviderIdCaseSensitive = TitleUtil.isProviderIdCaseSensitive();
        try {
            partnerFound = this.getPartnerOfType(providerId, isProviderIdCaseSensitive, PartnerType.SOURCE, PartnerType.SELF);
        }
        catch (PMMMultiplePartnersFoundException pmme) {
            isDuplicated = true;
        }
        catch (PMMException pMMException) {
            // empty catch block
        }
        if (!(partnerFound == null || partnerId != null && partnerId.equals(partnerFound.getId()))) {
            isDuplicated = true;
        }
        if (!isDuplicated) {
            return "";
        }
        return isProviderIdCaseSensitive ? messageUtil.getMessageValue("partner.error.exist.providerid", new Object[]{""}) : messageUtil.getMessageValue("partner.error.exist.providerid", new Object[]{"partner.case.insensitive"});
    }

    private boolean isPartnerTypeInArray(PartnerType[] typesArray, Partner partner) {
        if (typesArray == null || partner == null) {
            return false;
        }
        return Arrays.asList(typesArray).contains(partner.getType());
    }

    @Transactional
    public int getTotalActivePartnerCountForCurrentUser(PartnerType ... types) {
        return this.getPartnersBySearchCriteriaForCurrentUser(null, types).size();
    }

    @Transactional
    public boolean isPartnerActive(long partnerId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetIsActive");
        query.setParameter("partnerID", (Object)partnerId);
        Boolean result = (Boolean)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.nonexistent.id", new Object[]{partnerId}));
        }
        return result;
    }

    @Transactional
    public boolean isPartnerTenant(long partnerId) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetIsTenant");
        query.setParameter("partnerID", (Object)partnerId);
        List res = query.list();
        if (res.isEmpty()) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.nonexistent.id", new Object[]{partnerId}));
        }
        if (res.get(0) == null) {
            return false;
        }
        return (Boolean)res.get(0);
    }

    @Transactional
    public int getNumberOfTenants() {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("Partner.GetTenantCount");
        Long result = (Long)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.failed.get.tenants.total"));
        }
        return result.intValue();
    }

    @Transactional
    public PartnerThumbnail getPartnerThumbnail(long partnerID) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerID");
        query.setParameter("partnerID", (Object)partnerID);
        PartnerThumbnail result = (PartnerThumbnail)query.uniqueResult();
        if (result == null) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.cannot.get.thumbnail", new Object[]{partnerID}));
        }
        return result;
    }

    @Transactional
    public Collection<PartnerThumbnail> getPartnerThumbnails(Collection<Long> partnerIds) {
        if (CollectionUtils.isEmpty(partnerIds)) {
            return new ArrayList<PartnerThumbnail>();
        }
        Session session = HibernateContext.getContext().getCurrentSession();
        Query query = session.getNamedQuery("PartnerThumbnail.GetByPartnerIDs");
        query.setParameterList("partnerIDs", partnerIds);
        return query.list();
    }

    @Transactional
    public PartnerThumbnail updatePartnerThumbnail(PartnerThumbnail thumbnail) {
        Session session = HibernateContext.getContext().getCurrentSession();
        Partner partner = this.getPartner(thumbnail.getPartnerId());
        if (!partner.getIsActive().booleanValue()) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.cannot.update.thumbnail.inactive"));
        }
        if (PartnerType.DISTRIBUTION.equals((Object)partner.getType())) {
            throw new RuntimeException(messageUtil.getMessageValue("partner.error.cannot.update.thumbnail.distribution"));
        }
        return (PartnerThumbnail)session.merge((Object)thumbnail);
    }

    private ICacheService<IContainer> getContainerCacheService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (ICacheService)registry.lookup(CONTAINER_CACHE_SERVICE_NAME);
    }

    private void postToOtherNodes(int operation, long contextId, IContainer container) {
        DistributedTopic topic = (DistributedTopic)ServiceRegistry.getDefault().lookup("TITLE_TOPIC");
        ContainerCacheMessage msg = new ContainerCacheMessage(4, operation, contextId, container);
        topic.publish((Object)msg);
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
    }

    public void stop() {
    }

    @Transactional
    public void disassociateChildrenPartners(String[] childPartnersIds, String pContextId) {
        Partner parent = this.getPartnerByContextId(Long.valueOf(pContextId));
        if (childPartnersIds != null) {
            for (int i = 0; i < childPartnersIds.length; ++i) {
                String childId = childPartnersIds[i];
                Partner childPartner = this.getPartner(Long.valueOf(childId));
                this.removerParentUserFromChildren(parent, childPartner);
                this.removeParentAffiliationCode(childPartner, parent.getAffiliationCode());
                this.updatePartner(childPartner);
            }
        }
    }

    private void removeParentAffiliationCode(Partner partner, String parentAffiliationCode) {
        String affiliationCode = partner.getAffiliationCode();
        List<Partner> allOtherChildren = this.findAllChildPartners(partner.getAffiliationCode());
        if (!CollectionUtils.isEmpty(allOtherChildren)) {
            for (Partner otherChild : allOtherChildren) {
                String otherChildACode = otherChild.getAffiliationCode();
                otherChild.setAffiliationCode(otherChildACode.substring(parentAffiliationCode.length()));
                this.updatePartner(otherChild);
            }
        }
        partner.setAffiliationCode(affiliationCode.substring(parentAffiliationCode.length()));
    }

    @Transactional
    public List<Partner> searchTopLevelPartnersByName(String partnerName) {
        PartnerType[] seachTypes = new PartnerType[]{PartnerType.SOURCE, PartnerType.SELF};
        SearchCriteria searchCriteria = new SearchCriteria();
        ParterSearchCriteriaUtil.addBasicSearch(searchCriteria, PartnerSearchColumn.NAME, partnerName);
        return this.getActivePartnersForCurrentUser(searchCriteria, true, false, null, false, seachTypes);
    }

    @Transactional
    public void associateChildrenPartners(String[] selectedPartners, String pContextId) {
        if (selectedPartners != null) {
            for (int i = 0; i < selectedPartners.length; ++i) {
                String childId = selectedPartners[i];
                Partner parent = this.getPartnerByContextId(Long.valueOf(pContextId));
                if (org.springframework.util.StringUtils.isEmpty((Object)parent.getAffiliationCode())) {
                    parent.setAffiliationCode(parent.createAffiliationCode());
                    this.updatePartner(parent);
                }
                Partner childPartner = this.getPartner(Long.valueOf(childId));
                this.addParentAffiliationCode(childPartner, parent.getAffiliationCode());
                this.addParentUserToChildren(parent, childPartner);
                this.updatePartner(childPartner);
            }
        }
    }

    public void addParentUserToChildren(Partner parent, Partner childPartner) {
        List existingParentUserList = this.getPartnerUserManager().getAllUsersAssociatedWithPartner(Long.valueOf(parent.getContainerContextId()));
        if (!CollectionUtils.isEmpty((Collection)existingParentUserList)) {
            for (PartnerUser existingUser : existingParentUserList) {
                this.getPartnerUserManager().create(existingUser);
            }
        }
    }

    private void removerParentUserFromChildren(Partner parent, Partner childPartner) {
        List existingParentUserList = this.getPartnerUserManager().getAllUsersAssociatedWithPartner(Long.valueOf(parent.getContainerContextId()));
        if (!CollectionUtils.isEmpty((Collection)existingParentUserList)) {
            for (PartnerUser existingUser : existingParentUserList) {
                this.getPartnerUserManager().deleteUserForChildrenOnly(existingUser.getId());
            }
        }
    }

    private void addParentAffiliationCode(Partner childPartner, String parentAffiliationCode) {
        if (childPartner.getAffiliationCode() != null) {
            String childAffiCode = childPartner.getAffiliationCode();
            if (childAffiCode.equals(parentAffiliationCode)) {
                throw new IllegalArgumentException(messageUtil.getMessageValue("partner.error.associate.itself"));
            }
            if (childAffiCode.contains(parentAffiliationCode)) {
                throw new IllegalArgumentException(messageUtil.getMessageValue("partner.error.child.already.added"));
            }
            childPartner.setAffiliationCode(parentAffiliationCode + childAffiCode);
            List<Partner> allOtherChildren = this.findAllChildPartners(childAffiCode);
            if (allOtherChildren != null && !allOtherChildren.isEmpty()) {
                for (Partner otherChild : allOtherChildren) {
                    otherChild.setAffiliationCode(parentAffiliationCode + otherChild.getAffiliationCode());
                    this.updatePartner(otherChild);
                }
            }
        } else {
            childPartner.setAffiliationCode(parentAffiliationCode + childPartner.createAffiliationCode());
        }
    }

    private List<Integer> getTypeIdList(PartnerType ... types) {
        ArrayList<Integer> typeIds = new ArrayList<Integer>();
        for (PartnerType type : types) {
            typeIds.add(type.getTypeId());
        }
        return typeIds;
    }

    private IPartnerUserManager getPartnerUserManager() {
        if (this.pUserManager == null) {
            this.pUserManager = (IPartnerUserManager)ServiceRegistry.getDefault().lookup(IPartnerUserManager.class);
        }
        return this.pUserManager;
    }

    private IScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = (IScheduler)InjectionUtil.injectInstance((String)"cms/Scheduler/local", IScheduler.class);
        }
        return this.scheduler;
    }

    private IScheduleSearchService getScheduleSearchService() {
        if (this.searchService == null) {
            this.searchService = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        }
        return this.searchService;
    }

    private IContentClassService getContentClassService() {
        if (this.contentClassService == null) {
            this.contentClassService = (IContentClassService)InjectionUtil.injectInstance((String)"cms/ContentClassService/local", IContentClassService.class);
        }
        return this.contentClassService;
    }

    private void syncAfterSave(Partner partner) {
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        containerCache.add((Serializable)Long.valueOf(partner.getContainerContextId()), (Object)partner);
        this.postToOtherNodes(0, partner.getContainerContextId(), (IContainer)partner);
    }

    private void syncAfterDelete(Partner partner) {
        ICacheService<IContainer> containerCache = this.getContainerCacheService();
        containerCache.remove((Serializable)Long.valueOf(partner.getContainerContextId()));
        this.postToOtherNodes(1, partner.getContainerContextId(), (IContainer)partner);
    }
}

