/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.partner;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.util.SecurityInfo;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.PartnerUser;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

public class PartnerUserManager
implements IPartnerUserManager {
    private static final long serialVersionUID = -943269048414518699L;

    @Transactional
    public PartnerUser get(Long partnerUserId) {
        return (PartnerUser)this.getCurrentSession().load(PartnerUser.class, (Serializable)partnerUserId);
    }

    @Transactional
    public PartnerUser create(PartnerUser partnerUser) {
        IPartnerManagement pm = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        Partner partner = pm.getPartner(partnerUser.getPartnerId().longValue());
        String affiliationCode = partner.getAffiliationCode();
        partnerUser.setInheritedFlag(Boolean.valueOf(false));
        List childPartnerList = pm.findAllChildPartners(affiliationCode);
        IPartnerUserManager partnerUserManager = this.getPartnerUserManager();
        if (!(childPartnerList.isEmpty() || partnerUser.getInheritedFlag() != null && partnerUser.getInheritedFlag().booleanValue())) {
            for (Partner p : childPartnerList) {
                PartnerUser childPartnerUser = new PartnerUser();
                childPartnerUser.setUserName(partnerUser.getUserName());
                childPartnerUser.setPartnerId(Long.valueOf(p.getId()));
                childPartnerUser.setInheritedFlag(Boolean.valueOf(true));
                PartnerUser existingPartnerUser = partnerUserManager.getByPartnerAndUserName(childPartnerUser.getPartnerId(), childPartnerUser.getUserName());
                if (existingPartnerUser == null) {
                    this.getCurrentSession().persist((Object)childPartnerUser);
                    continue;
                }
                if (existingPartnerUser.getInheritedFlag() != null && existingPartnerUser.getInheritedFlag().booleanValue()) continue;
                existingPartnerUser.setInheritedFlag(Boolean.valueOf(true));
                this.getCurrentSession().persist((Object)existingPartnerUser);
            }
        }
        this.getCurrentSession().persist((Object)partnerUser);
        return partnerUser;
    }

    @Transactional
    public boolean delete(Long partnerUserId) {
        IPartnerManagement pm = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        PartnerUser partnerUser = this.getPartnerUser(partnerUserId);
        if (partnerUser == null) {
            return false;
        }
        if (partnerUser.getInheritedFlag() != null && partnerUser.getInheritedFlag().booleanValue()) {
            return false;
        }
        String userName = partnerUser.getUserName();
        Partner partner = pm.getPartner(partnerUser.getPartnerId().longValue());
        String affiliationCode = partner.getAffiliationCode();
        List childPartnerList = pm.findAllChildPartners(affiliationCode);
        IPartnerUserManager partnerUserManager = this.getPartnerUserManager();
        if (!childPartnerList.isEmpty()) {
            for (Partner p : childPartnerList) {
                PartnerUser existingPartnerUser = partnerUserManager.getByPartnerAndUserName(Long.valueOf(p.getId()), userName);
                if (existingPartnerUser == null) continue;
                this.getCurrentSession().delete((Object)existingPartnerUser);
            }
        }
        this.getCurrentSession().delete((Object)partnerUser);
        return true;
    }

    @Transactional
    public boolean deleteUserForChildrenOnly(Long parentPartnerUserId) {
        IPartnerManagement pm = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        PartnerUser partnerUser = this.getPartnerUser(parentPartnerUserId);
        if (partnerUser == null) {
            return false;
        }
        if (partnerUser.getInheritedFlag() != null && partnerUser.getInheritedFlag().booleanValue()) {
            return false;
        }
        String userName = partnerUser.getUserName();
        Partner partner = pm.getPartner(partnerUser.getPartnerId().longValue());
        String affiliationCode = partner.getAffiliationCode();
        List childPartnerList = pm.findAllChildPartners(affiliationCode);
        IPartnerUserManager partnerUserManager = this.getPartnerUserManager();
        if (!childPartnerList.isEmpty()) {
            for (Partner p : childPartnerList) {
                PartnerUser existingPartnerUser = partnerUserManager.getByPartnerAndUserName(Long.valueOf(p.getId()), userName);
                if (existingPartnerUser == null) continue;
                this.getCurrentSession().delete((Object)existingPartnerUser);
            }
        }
        return true;
    }

    @Transactional
    public PartnerUser getByPartnerAndUserName(Long partnerId, String userName) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetByPartnerAndUserName");
        query.setParameter("partnerID", (Object)partnerId);
        query.setParameter("userName", (Object)userName);
        return (PartnerUser)query.uniqueResult();
    }

    @Transactional
    public List<PartnerUser> getByPartner(Long partnerId) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetByPartner");
        query.setParameter("partnerID", (Object)partnerId);
        return query.list();
    }

    @Transactional
    public List<PartnerUser> getByUserName(String userName) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetByUserName");
        query.setParameter("userName", (Object)userName);
        return query.list();
    }

    @Transactional
    public List<PartnerUser> getByCurrentUser() {
        String userName = this.getCurrentUser();
        return this.getByUserName(userName);
    }

    @Transactional
    public List<Partner> getPartnersByUserName(String userName) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetPartnersByUserName");
        query.setParameter("userName", (Object)userName);
        query.setReadOnly(true);
        return query.list();
    }

    @Transactional
    public List<Partner> getDirectPartnersByUserName(String userName) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetDirectPartnersByUserName");
        query.setParameter("userName", (Object)userName);
        query.setReadOnly(true);
        return query.list();
    }

    @Transactional
    public List<Partner> getPartnersByCurrentUser() {
        String userName = this.getCurrentUser();
        return this.getPartnersByUserName(userName);
    }

    @Transactional
    public List<Partner> getDirectPartnersByCurrentUser() {
        String userName = this.getCurrentUser();
        return this.getDirectPartnersByUserName(userName);
    }

    @Transactional
    public boolean isSelfPartnerUser(String userName) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetIsSelfPartnerUser");
        query.setParameter("userName", (Object)userName);
        Number result = (Number)query.uniqueResult();
        return result != null && result.intValue() > 0;
    }

    @Transactional
    public List<PartnerUser> getAllUsersAssociatedWithPartner(Long contextId) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetUsersByPartner");
        query.setParameter("contextId", (Object)contextId);
        List partnerUsers = query.list();
        return partnerUsers;
    }

    @Transactional
    public boolean isSelfPartnerUser() {
        String userName = this.getCurrentUser();
        return this.isSelfPartnerUser(userName);
    }

    @Transactional
    public List<PartnerUser> getUsersByTitleId(Long titleId) {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetUsersByTitle");
        query.setParameter("id", (Object)titleId);
        List partnerUsers = query.list();
        return partnerUsers;
    }

    @Transactional
    public List<PartnerUser> getSelfPartnerUsers() {
        Query query = this.getCurrentSession().getNamedQuery("PartnerUser.GetSelfPartnerUsers");
        List partnerUsers = query.list();
        return partnerUsers;
    }

    private PartnerUser getPartnerUser(Long partnerUserId) {
        return (PartnerUser)this.getCurrentSession().get(PartnerUser.class, (Serializable)partnerUserId);
    }

    private String getCurrentUser() {
        return SecurityInfo.getCallerPrincipal().getName();
    }

    private Session getCurrentSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    public String getServiceName() {
        return this.getClass().getSimpleName();
    }

    public void start() {
    }

    public void stop() {
    }

    private IPartnerUserManager getPartnerUserManager() {
        IPartnerUserManager partnerUserManager = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
        return partnerUserManager;
    }
}

