/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.tandbergtv.watchpoint.pmm.entities.ContainerType;
import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationSetting;
import com.tandbergtv.watchpoint.pmm.schedule.notify.SlimSchedule;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;

public class PlannerNotificationGenerator
extends AbstractNotificationGenerator {
    @Override
    protected String getType() {
        return "planner";
    }

    @Override
    protected void addMessage(Notification notification, Collection<Title> titles) {
        String message = super.constructMessage(titles);
        SlimSchedule schedule = notification.getSchedule();
        String date = new SimpleDateFormat("yyyy-MM-dd").format(schedule.getDate());
        String source = this.getSource(schedule);
        notification.addMessage("Expected assets for planner dated " + date + " from " + source + " are late: " + message);
    }

    private String getSource(SlimSchedule schedule) {
        IPartnerManagement pm;
        Partner partner;
        long partnerId = schedule.getSourcePartnerID();
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Container Cache");
        if (cache != null) {
            for (Serializable key : cache.getKeys()) {
                IContainer container = (IContainer)cache.get(key);
                long id = container.getContainerId();
                if (container.getContainerType() != ContainerType.PARTNER || id != partnerId) continue;
                return container.getContainerName();
            }
        }
        if ((partner = (pm = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class)).getPartner(partnerId)) != null) {
            return partner.getName();
        }
        throw new ScheduleRuntimeException("Cannot find partner " + partnerId);
    }

    @Override
    protected boolean isTitleDelayed(Title title) {
        return title.getStatus() != TitleStatus.READY && title.getStatus() != TitleStatus.APPROVED;
    }

    @Override
    protected NotificationSetting getNoficiationOffset() {
        Map<String, String> progSettings = this.getConfiguration();
        return new NotificationSetting(Integer.parseInt(progSettings.get(PROP_PLANNER_STATUS_OFFSET)));
    }
}

