/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.notify;

import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Partner;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.TitleListType;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerUserManager;
import com.tandbergtv.watchpoint.pmm.schedule.notify.AbstractNotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ClusterNodeNotificationsManager;
import com.tandbergtv.watchpoint.pmm.schedule.notify.INotificationGenerator;
import com.tandbergtv.watchpoint.pmm.schedule.notify.IScheduleNotifier;
import com.tandbergtv.watchpoint.pmm.schedule.notify.Notification;
import com.tandbergtv.watchpoint.pmm.schedule.notify.NotificationGeneratorFactory;
import com.tandbergtv.watchpoint.pmm.schedule.notify.ScheduleStatistics;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ScheduleNotifierService
implements IScheduleNotifier {
    private Scheduler<Void> scheduler = new Scheduler("Notifications", 1, 1);
    private HazelcastInstance haz;
    IClusterService hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    private IMap<Long, Notification> notificationsMap;
    private boolean becameMaster;
    public static final String SERVICE_NAME = "Schedule Notifier";
    private static final Logger logger = Logger.getLogger(ScheduleNotifierService.class);
    private IConfigurationService configurationService;
    private int generateNotificationInterval;
    private int pastDays;
    private int futureDays;
    private ScheduleStatistics statistics;
    private Future<?> currentNotificationTask;

    public ScheduleNotifierService() {
        this.haz = this.hzcs.getInstance();
        this.notificationsMap = this.haz.getMap("scheduleNotificationListHaz");
        this.refershNeptuneSetting();
        this.statistics = new ScheduleStatistics(this);
    }

    public ScheduleStatistics getScheduleStatistics() {
        return this.statistics;
    }

    private void refershNeptuneSetting() {
        this.setGenerteNotificationsInterval();
        this.setNumberOfPastDays();
        this.setNumberOfFutureDays();
    }

    public IConfigurationService getConfigService() {
        if (this.configurationService == null) {
            this.configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        }
        return this.configurationService;
    }

    private void setNumberOfFutureDays() {
        Map<String, String> progSettings = this.getConfiguration();
        this.futureDays = Integer.parseInt(progSettings.get(AbstractNotificationGenerator.PROP_FUTURE));
        logger.debug((Object)("Notifications will be generated for schedules " + this.futureDays + " days from today."));
    }

    private void setNumberOfPastDays() {
        Map<String, String> progSettings = this.getConfiguration();
        this.pastDays = Integer.parseInt(progSettings.get(AbstractNotificationGenerator.PROP_PAST));
        logger.debug((Object)("Notifications will be generated for schedules " + this.pastDays + " days in the past from today."));
    }

    public void setGenerteNotificationsInterval() {
        Map<String, String> progSettings = this.getConfiguration();
        this.generateNotificationInterval = Integer.parseInt(progSettings.get(AbstractNotificationGenerator.PROP_NOTIFICATION_GENERATION_INTERAL));
        logger.debug((Object)("Set the generate notifications interval to: " + this.generateNotificationInterval + " seconds"));
    }

    private Map<String, String> getConfiguration() {
        return this.getConfigService().getProperties(AbstractNotificationGenerator.PROGRESS_UI_SETTINGS_GROUP);
    }

    public Notification getNotification(Schedule schedule) {
        return (Notification)this.notificationsMap.get((Object)schedule.getId());
    }

    public Collection<Notification> getCurrentNotifications() {
        return this.notificationsMap.values();
    }

    public Collection<Notification> getCurrentNotificationsForCurrentUser() {
        Collection notifications = this.notificationsMap.values();
        HashSet<Notification> un = new HashSet<Notification>();
        IPartnerUserManager service = (IPartnerUserManager)InjectionUtil.injectInstance((String)"cms/PartnerUserManager/local", IPartnerUserManager.class);
        if (service.isSelfPartnerUser()) {
            un.addAll(notifications);
        } else {
            List partners = service.getPartnersByCurrentUser();
            HashSet<Long> partnerIds = new HashSet<Long>();
            if (partners != null) {
                for (Partner p : partners) {
                    partnerIds.add(p.getId());
                }
            }
            for (Notification n : notifications) {
                TitleListType type = n.getSchedule().getType();
                boolean isPlannerOrPitch = type == TitleListType.PLANNER || type == TitleListType.PITCH;
                if (!isPlannerOrPitch || !partnerIds.contains(n.getSchedule().getSourcePartnerID())) continue;
                un.add(n);
            }
        }
        return un;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        com.hazelcast.core.Cluster cluster = this.hzcs.getInstance().getCluster();
        if (this.hzcs.isMaster() && !this.becameMaster) {
            this.becameMaster = true;
            this.restartNotificationThread();
        }
        cluster.addMembershipListener((MembershipListener)new ClusterNodeNotificationsManager(this));
    }

    public void restartNotificationThread() {
        if (!this.hzcs.isMaster()) {
            return;
        }
        if (this.currentNotificationTask != null) {
            this.currentNotificationTask.cancel(true);
        }
        this.refershNeptuneSetting();
        this.currentNotificationTask = this.scheduler.schedule(() -> {
            try {
                this.generate();
            }
            catch (Exception e) {
                logger.error((Object)"Failure during generating notifications", (Throwable)e);
            }
        }, 0L, TimeUnit.SECONDS.toMillis(this.generateNotificationInterval));
    }

    public void stop() {
        if (this.hzcs.isMaster()) {
            this.scheduler.stop();
        }
    }

    @Transactional
    public void generate() {
        logger.debug((Object)"generate shcedule notification");
        Collection<Schedule> schedules = this.getSchedules();
        this.removeNotifications();
        for (Schedule schedule : schedules) {
            Notification notification = this.generate(schedule);
            if (notification == null) continue;
            this.notify(schedule, notification);
        }
    }

    private Notification generate(Schedule schedule) {
        if (!(schedule instanceof Planner) && !(schedule instanceof DistributionSchedule)) {
            return null;
        }
        NotificationGeneratorFactory factory = NotificationGeneratorFactory.newInstance();
        INotificationGenerator generator = factory.newGenerator(schedule);
        return generator.getNotification(schedule);
    }

    private void notify(Schedule schedule, Notification notification) {
        this.addNotification(schedule, notification);
        if (logger.isEnabledFor((Priority)Level.WARN)) {
            for (String message : notification.getMessages()) {
                logger.warn((Object)message);
            }
        }
    }

    private void addNotification(Schedule schedule, Notification notification) {
        this.notificationsMap.put((Object)schedule.getId(), (Object)notification);
    }

    private void removeNotifications() {
        this.notificationsMap.clear();
    }

    private Collection<Schedule> getSchedules() {
        IScheduleSearchService service = (IScheduleSearchService)ServiceRegistry.getDefault().lookup(IScheduleSearchService.class);
        Collection schedules = service.search(this.getSearchCriteria(DistributionSchedule.class));
        schedules.addAll(service.search(this.getSearchCriteria(Planner.class)));
        return schedules;
    }

    private SearchCriteria getSearchCriteria(Class<?> clazz) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", clazz, "s");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter(this.getDateRangeCriterion());
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        return criteria;
    }

    private SearchParameterBase getDateRangeCriterion() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date from = this.getWindowStart();
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(from));
        Date to = this.getWindowEnd();
        range.setTo(formatter.format(to));
        return range;
    }

    private Date getWindowStart() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, -this.pastDays);
        return calendar.getTime();
    }

    private Date getWindowEnd() {
        Date today = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(today);
        ((Calendar)calendar).add(5, this.futureDays);
        return calendar.getTime();
    }
}

