/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleFileManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleFileRequest;
import com.tandbergtv.watchpoint.pmm.title.TitleServiceException;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.util.NormalizedItem;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleFileManager
implements ITitleFileManager {
    private static Logger logger = Logger.getLogger(TitleFileManager.class);
    private static final String COMPONENT_NAME = "Content Management";
    private static final String FILE_TYPE_ORIGINAL = "ORIGINAL";
    private static final String FILE_TYPE_HISTORICAL = "HISTORICAL";
    private static final String LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final String FILE_TYPE_XPATH = "/Fields/Locator/Description/Text";
    private ITitleStatusService statusService;
    private ITitleManager titleManager;

    public String getServiceName() {
        return "Title File Service";
    }

    public void start() {
        this.statusService = new TitleStatusService();
    }

    public void stop() {
    }

    public ISavedTitle registerFile(TitleFileRequest request) throws TitleServiceException {
        boolean isEditingFile = request.getOriginalFilePath() != null && !"".equals(request.getOriginalFilePath().trim());
        Title title = this.getTitle(request);
        this.processFile(request, isEditingFile, this.getAsset(request.getAssetId(), title));
        NormalizedItem normalizedItem = new NormalizedItem(title);
        TitleStatus status = title.getStatus();
        boolean isValid = false;
        List errorMessages = new ArrayList();
        try {
            errorMessages = this.getTitleManager().validate(title, false);
            isValid = true;
        }
        catch (TitleValidationException e) {
            logger.warn((Object)"Exception: ", (Throwable)e);
            errorMessages = e.getMessages();
            isValid = false;
        }
        try {
            ISavedTitle savedTitle;
            if (isValid && status != TitleStatus.DRAFT) {
                normalizedItem = this.triggerNormalization(title, request.getEvent());
                title = normalizedItem.getTitle();
            }
            TitleActionSource source = new TitleActionSource(COMPONENT_NAME, null, request.getUsername());
            if (status != TitleStatus.DRAFT) {
                savedTitle = this.getTitleManager().update(title, (ITitleActionSource)source);
                if (savedTitle.getTitle().getStatus() != TitleStatus.DRAFT) {
                    this.statusService.sendStatus(title, ProgressStatusHelper.NORMALIZED, normalizedItem.getNormalizationChangeInfo(), true, COMPONENT_NAME, null, request.getUsername());
                    this.triggerContentProcessing(request.getTitleId(), request.getEvent());
                }
            } else {
                savedTitle = this.getTitleManager().update(title, true, (ITitleActionSource)source);
                savedTitle.getValidationMessages().addAll(errorMessages);
            }
            return savedTitle;
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred : " + e), (Throwable)e);
            throw new TitleServiceException(null, "Exception updating title : " + e, (Throwable)e);
        }
    }

    private void processFile(TitleFileRequest request, boolean isEditingFile, Asset targetAsset) {
        this.updateFileAsset(request, isEditingFile, targetAsset);
        com.tandbergtv.metadatamanager.model.File newFile = this.createFile(request, isEditingFile);
        Asset target = isEditingFile ? this.getTargetFile(request, targetAsset) : targetAsset;
        target.addChild((Asset)newFile);
    }

    private com.tandbergtv.metadatamanager.model.File createFile(TitleFileRequest request, boolean isEditingFile) {
        com.tandbergtv.metadatamanager.model.File newFile = new com.tandbergtv.metadatamanager.model.File();
        newFile.setFileType(isEditingFile ? FileType.DERIVED : FileType.ORIGINAL);
        this.addField(newFile, FieldName.FILE_URL.toString(), request.getFilePath());
        this.addField(newFile, LOOKUP_KEY_XPATH, request.getLookupKey());
        this.addField(newFile, FieldName.FILE_NAME.toString(), request.getFilePath().substring(request.getFilePath().lastIndexOf(File.separatorChar) + 1));
        try {
            this.addField(newFile, FieldName.FILE_SIZE.toString(), String.valueOf(new File(request.getFilePath()).length()));
        }
        catch (Exception e) {
            logger.warn((Object)"cannot get file size", (Throwable)e);
        }
        return newFile;
    }

    private void updateFileAsset(TitleFileRequest request, boolean isEditingFile, Asset targetAsset) {
        for (Asset asset : targetAsset.getDirectDescendantFiles()) {
            Field lookupKeyField;
            Field fileTypeField;
            if (!(asset instanceof com.tandbergtv.metadatamanager.model.File)) continue;
            if (!isEditingFile && (fileTypeField = asset.getFirstField(FILE_TYPE_XPATH)) != null && fileTypeField.getTypedValue().equals(FILE_TYPE_ORIGINAL)) {
                fileTypeField.setValue(FILE_TYPE_HISTORICAL);
            }
            if ((lookupKeyField = asset.getFirstField(LOOKUP_KEY_XPATH)) == null || !lookupKeyField.getTypedValue().equals(request.getLookupKey())) continue;
            lookupKeyField.setValue("");
        }
    }

    private Asset getTargetFile(TitleFileRequest request, Asset targetAsset) {
        for (Asset asset : targetAsset.getAllDescendantItems(true)) {
            com.tandbergtv.metadatamanager.model.File file;
            if (!(asset instanceof com.tandbergtv.metadatamanager.model.File) || !(file = (com.tandbergtv.metadatamanager.model.File)com.tandbergtv.metadatamanager.model.File.class.cast(asset)).getURL().equals(request.getOriginalFilePath())) continue;
            return file;
        }
        throw new TitleServiceException(null, "Did not find a file object for assetId=" + request.getAssetId() + " and originalFilePath=" + request.getOriginalFilePath());
    }

    private Asset getAsset(long assetId, Title title) {
        Asset groupAsset = title.getAsset();
        if (groupAsset == null) {
            throw new TitleServiceException(null, "Did not get a group object for a given title.");
        }
        if (groupAsset.getId() == assetId) {
            return groupAsset;
        }
        for (Asset asset : groupAsset.getAllDescendantAssets()) {
            if (asset.getId() != assetId) continue;
            return asset;
        }
        throw new TitleServiceException(null, "Did not get an item object for a given assetId=" + assetId + "  titledId=" + title.getId());
    }

    private Title getTitle(TitleFileRequest request) {
        Title title = null;
        try {
            title = this.getTitleManager().getForUpdate(Long.valueOf(request.getTitleId()));
        }
        catch (Exception e) {
            throw new TitleServiceException(null, "Failed to read the Title from the persistence service, error: " + e.getMessage(), (Throwable)e);
        }
        if (title == null) {
            throw new TitleServiceException(null, "Did not get a Title from the persistence service.");
        }
        return title;
    }

    private NormalizedItem triggerNormalization(Title title, String event) {
        if (event == null || "".equals(event.trim())) {
            logger.debug((Object)"empty event, no rule getting trigger");
            return new NormalizedItem(title);
        }
        return this.getTitleManager().normalizeTitleWithMetadataEnhancement(title, event, null);
    }

    private void triggerContentProcessing(long titleId, String event) {
        if ("UIUPDATED".equals(event)) {
            RulesEngineFacade.sendUIUpdatedEvent(titleId);
        }
    }

    private void addField(com.tandbergtv.metadatamanager.model.File origFile, String path, String value) {
        if (value != null && path != null && !path.trim().isEmpty()) {
            origFile.addField(new Field(path, value));
        }
    }

    private ITitleManager getTitleManager() {
        if (this.titleManager == null) {
            this.titleManager = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        }
        return this.titleManager;
    }
}

