/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.ElasticSearchTitleCallback;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.ericsson.cms.sites.core.SiteManagementException;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalRegister;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitlePersistenceException;
import com.tandbergtv.watchpoint.pmm.core.TitlePropertyManager;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.ProgressItem;
import com.tandbergtv.watchpoint.pmm.entities.SaveResult;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleDistributionStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleProcessingStatus;
import com.tandbergtv.watchpoint.pmm.entities.TitleProperty;
import com.tandbergtv.watchpoint.pmm.entities.TitleResource;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleStatusUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.entities.event.TitleUpdatedEvent;
import com.tandbergtv.watchpoint.pmm.title.ITitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleDeleteCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistCallback;
import com.tandbergtv.watchpoint.pmm.title.ITitlePersistenceService;
import com.tandbergtv.watchpoint.pmm.title.ITitleResourceManager;
import com.tandbergtv.watchpoint.pmm.title.TitleAssetManager;
import com.tandbergtv.watchpoint.pmm.title.TitleDeleteException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentActionException;
import com.tandbergtv.watchpoint.pmm.title.TitleDocumentManager;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.TitleThumbnailHandler;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.TitleValidator;
import com.tandbergtv.watchpoint.pmm.title.autofill.AutoFillService;
import com.tandbergtv.watchpoint.pmm.title.conf.ISpecificationManager;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import com.tandbergtv.watchpoint.pmm.title.resource.FileManager;
import com.tandbergtv.watchpoint.pmm.util.NormalizedItem;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.w3c.dom.Document;

public class TitleManager
implements ITitleManager {
    private ITitlePersistenceService titlePersistenceService;
    private ITitleStatusService statusService;
    private ITitleAssetManager titleAssetManager;
    private ITitleDocumentManager titleDocumentManager;
    private TitleValidator titleValidator;
    private TitleThumbnailHandler thumbnailHandler;
    private FileManager fileManager;
    private ITitleSearchService titleSearchService;
    private static final String SERVICE_NAME = "Title Manager Service";
    private static final String OLD_ASSET_RECEIVED_ACTION_SUFFIX = "RECEIVED";
    static final String FILE_LOOKUP_KEY_XPATH = "/Fields/CustomFields/CustomField[@name=LookupKey]/@value";
    private static final Logger logger = Logger.getLogger(TitleManager.class);
    private static final int MAX_PAGE_SIZE = 10000;
    private static final int MAX_REF_TITLES = 200;
    private static final String COULD_NOT_UPDATE_ELASTICSEARCH = "Could not update ElasticSearch. ";
    private static final String TITLE_CANNOT_BE_NULL = "Title cannot be null. ";
    private static final String CONTENT_EVENT_NAME_CANNOT_BE_NULL = "Param contentEventName can't be null. ";
    private static final String TITLE_ID_CANNOT_BE_NULL = "Title ID cannot be null. ";
    private static final String TITLE_NOT_ACTIVATE = "Cannot update title since it is not active.";
    private static final String TITLE_ID = "titleId";

    @Transactional
    public ISavedTitle create(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (title.getId() != null) {
            throw new TitlePersistenceException("Cannot create title since ID is already defined.");
        }
        ISavedTitle titleObject = this.save(title, false, draft, source, ProgressStatusHelper.CREATED, null, false);
        if (titleObject != null && titleObject.getTitle() != null) {
            TitleUtil.buildTitleMetricsLog(titleObject.getTitle(), TitleOperationTypeEnum.Created);
        }
        return titleObject;
    }

    @Transactional
    public ISavedTitle update(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (!this.isActive(title.getId())) {
            throw new TitlePersistenceException(TITLE_NOT_ACTIVATE);
        }
        return this.save(title, false, draft, source, ProgressStatusHelper.UPDATED, null, false);
    }

    @Transactional
    public void updateDistributionStatus(Title title) throws TitleValidationException {
        if (title.isCopy()) {
            logger.error((Object)"To be used only for master titles and not site titles");
            throw new TitlePersistenceException("To be used only for master titles and not site titles");
        }
        if (!this.isActive(title.getId())) {
            throw new TitlePersistenceException(TITLE_NOT_ACTIVATE);
        }
        Map<String, String> siteDistributionStatusMap = this.titlePersistenceService.getSiteDistributionStatusMap(title.getId());
        TitleDistributionStatus tds = TitleUtil.getAggregatedDistributionStatus(siteDistributionStatusMap);
        title.setDistributionStatus(tds);
        this.updateDistributionStatus(title.getId(), tds.toString());
        Date date = null;
        if (tds == TitleDistributionStatus.DISTRIBUTED) {
            date = new Date();
        }
        title.setDistributionDate(date);
        this.updateDistributionDate(title.getId(), date);
        if (tds == TitleDistributionStatus.DISTRIBUTED) {
            long titleDistributionTime;
            TitleUtil.buildTitleMetricsLog(title, TitleOperationTypeEnum.Distributed);
            Date ingestDate = this.getLastIngestDate(title);
            if (ingestDate != null && (titleDistributionTime = (System.currentTimeMillis() - ingestDate.getTime()) / 1000L) > 0L) {
                TitleUtil.buildTitleE2ELog(title, titleDistributionTime);
            }
        }
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException(COULD_NOT_UPDATE_ELASTICSEARCH, (Throwable)ex);
        }
    }

    @Transactional
    public void updateProcessingStatus(Title title) throws TitleValidationException {
        if (title.isCopy()) {
            logger.warn((Object)("Processing status not updated for site title. Title Id=" + title.getId()));
            return;
        }
        if (!this.isActive(title.getId())) {
            logger.warn((Object)("Processing status not updated for inactive master title. Title Id=" + title.getId()));
            return;
        }
        TitleProcessingStatus tps = title.getProcessingStatus();
        Session session = HibernateContext.getContext().getCurrentSession();
        Transaction trans = session.beginTransaction();
        session.getNamedQuery("Title.udpateProcStatus").setString("proc_status", tps.toString()).setLong(TITLE_ID, title.getId().longValue());
        trans.commit();
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException(COULD_NOT_UPDATE_ELASTICSEARCH, (Throwable)ex);
        }
        logger.debug((Object)("Updated processing status of master title " + title.getId() + " with status " + tps.toString()));
    }

    private Date getLastIngestDate(Title title) {
        Date lastIngestDate = null;
        String recdName = ProgressStatusHelper.getAssetReceivedStatusName("").trim();
        Collection progItems = title.getProgressItems();
        for (ProgressItem item : progItems) {
            String itemName = item.getName();
            boolean isNewStyleAssetReceiveItem = itemName.contains(recdName);
            boolean isOldStyleAssetReceiveItem = itemName.endsWith(OLD_ASSET_RECEIVED_ACTION_SUFFIX);
            if (!isNewStyleAssetReceiveItem && !isOldStyleAssetReceiveItem) continue;
            Date ingestDate = item.getTimestamp();
            if (lastIngestDate != null && ingestDate.getTime() <= lastIngestDate.getTime()) continue;
            lastIngestDate = ingestDate;
        }
        return lastIngestDate;
    }

    @Transactional
    public ISavedTitle update(Title title, ITitleActionSource source) throws TitleValidationException {
        if (!this.isActive(title.getId())) {
            throw new TitlePersistenceException(TITLE_NOT_ACTIVATE);
        }
        boolean draft = false;
        return this.save(title, true, draft, source, ProgressStatusHelper.UPDATED, null, false);
    }

    private ISavedTitle save(Title title, boolean validateForTitleStatus, boolean draft, ITitleActionSource source, String statusName, String statusValue, boolean distributionStatusUpdate) throws TitleValidationException {
        return this.saveOrRollback(title, null, validateForTitleStatus, draft, source, statusName, statusValue, false, distributionStatusUpdate, false);
    }

    @Transactional
    public ISavedTitle rollback(Long titleID, String version, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (!this.isActive(titleID)) {
            throw new TitlePersistenceException("Cannot rollback title since it is not active.");
        }
        Title title = this.getForUpdate(titleID);
        if (title.getStatus(version) == TitleStatus.DRAFT) {
            throw new TitlePersistenceException("Cannot rollback to a DRAFT version.");
        }
        Title oldTitle = this.get(titleID, version);
        title.setAsset(oldTitle.getAsset());
        return this.rollback(title, version, draft, source, ProgressStatusHelper.ROLLED_BACK, null);
    }

    private ISavedTitle rollback(Title oldTitle, String version, boolean draft, ITitleActionSource source, String statusName, String statusValue) throws TitleValidationException {
        return this.saveOrRollback(oldTitle, version, false, draft, source, statusName, statusValue, true, false, false);
    }

    private ISavedTitle saveOrRollback(Title title, String version, boolean validateForTitleStatus, boolean draft, ITitleActionSource source, String statusName, String statusValue, boolean isRollback, boolean distributionStatusUpdate, boolean isPlannerTitle) throws TitleValidationException {
        List<TitleValidationMessage> messages;
        ISpecificationManager specManager = this.getService(ISpecificationManager.class);
        UISpecification uiSpec = specManager.getUISpecification(UISpecification.Type.PACKAGE);
        ContentClass contentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            contentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            logger.error((Object)"Exception: ", (Throwable)ex);
        }
        if (contentClass == null) {
            String str = "Unable to get content class with id: " + title.getContentClassId();
            TitleValidationMessage msg = TitleValidationMessage.createMessage((TitleValidationMessage.Type)TitleValidationMessage.Type.Error, (String)"ContentClass", (String)str);
            ArrayList<TitleValidationMessage> list = new ArrayList<TitleValidationMessage>(1);
            list.add(msg);
            throw new TitleValidationException(list);
        }
        AutoFillService autoFillService = this.getAutoFillService(uiSpec, contentClass, title);
        autoFillService.autoFill();
        long t1 = System.currentTimeMillis();
        if (isPlannerTitle) {
            messages = this.titleValidator.validateWithoutRules(title);
        } else if (!validateForTitleStatus) {
            messages = this.validate(title, draft);
        } else {
            messages = this.titleValidator.validate(title);
            if (TitleValidator.hasErrors(messages)) {
                draft = true;
                logger.debug((Object)String.format("Rules validation failed, save title as draft for title id = %d", title.getId()));
            }
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)String.format("Time taken to validate - time:%d ms, titleId = %d, originalTitleId = %d", t2 - t1, title.getId(), title.getOriginalId()));
        TitleStatus oldStatus = title.getStatus();
        if (isPlannerTitle) {
            if (title.getId() == null) {
                title.setStatus(TitleStatus.PLANNED);
            }
        } else if (draft) {
            title.setStatus(TitleStatus.DRAFT);
        } else {
            this.statusService.updateTitleStatus(title, contentClass);
        }
        if (title.getCreateDate() == null) {
            title.setCreateDate(new Date());
        }
        title.setLastModifiedTime(new Date());
        title.setRetirementDate(null);
        Title oldTitle = null;
        if (title.getAsset() != null && title.getAsset().getId() > 0L) {
            Asset rootAsset = this.titlePersistenceService.getAsset(title.getAsset().getId());
            oldTitle = new Title(title.getId());
            oldTitle.setAsset(rootAsset);
            long t3 = System.currentTimeMillis();
            logger.debug((Object)String.format("Time taken to getmetadata - time: %d ms, titleId = %d, originalTitleId = %d", t3 - t2, title.getId(), title.getOriginalId()));
        }
        ElasticSearchIndexType titleType = ElasticSearchIndexType.MASTER;
        try {
            titleType = ElasticSearchUtil.getTitleType(title);
        }
        catch (Exception e) {
            logger.error((Object)"Error getting TitleType", (Throwable)e);
        }
        if (titleType.equals((Object)ElasticSearchIndexType.MASTER) && !isRollback && !draft && distributionStatusUpdate) {
            Map<String, String> siteDistributionStatusMap = this.titlePersistenceService.getSiteDistributionStatusMap(title.getId());
            title.setDistributionStatus(TitleUtil.getAggregatedDistributionStatus(siteDistributionStatusMap));
            title.setDistributionDate(new Date());
        }
        this.beforePersist(title);
        long t3 = System.currentTimeMillis();
        if (isRollback) {
            this.titlePersistenceService.rollback(title, version);
        } else {
            this.titlePersistenceService.save(title, distributionStatusUpdate);
        }
        long t4 = System.currentTimeMillis();
        logger.debug((Object)String.format("Time taken to persist - time: %d ms, titleId = %d, originalTitleId = %d", t3 - t4, title.getId(), title.getOriginalId()));
        this.onPersist(title);
        TransactionalRegister.getInstance().registerRollbackCallback((Object)("saveTitle_" + title.getId()), t -> this.syncElasticSearch(title));
        this.thumbnailHandler.updateThumbnails(title, oldTitle);
        if (!draft) {
            if (title.getStatus() != oldStatus) {
                TitleStatusUpdatedEvent event = new TitleStatusUpdatedEvent((Object)this, title, oldStatus, title.getStatus());
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)event);
            }
            TitleUpdatedEvent titleUpdatedEvent = new TitleUpdatedEvent((Object)this, title);
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)titleUpdatedEvent);
        }
        String newStatusName = statusName;
        if (draft) {
            newStatusName = statusName == ProgressStatusHelper.CREATED ? ProgressStatusHelper.CREATED_AS_DRAFT : ProgressStatusHelper.UPDATED_AS_DRAFT;
        }
        this.statusService.sendStatus(title, newStatusName, statusValue, true, source.getComponentName(), source.getEntityName(), source.getID());
        if (!draft) {
            this.statusService.sendStatus(title, ProgressStatusHelper.VALIDATION_SUCCESS, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        }
        return new SaveResult(title, messages);
    }

    private AutoFillService getAutoFillService(UISpecification uiSpec, ContentClass contentClass, Title title) {
        return new AutoFillService(uiSpec, contentClass, title);
    }

    private void beforePersist(Title title) {
        ServiceLoader<ITitlePersistCallback> loader = ServiceLoader.load(ITitlePersistCallback.class);
        Iterator<ITitlePersistCallback> serviceIterator = loader.iterator();
        if (serviceIterator == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        while (serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onBeforePersist(title);
            }
            catch (Exception ex) {
                logger.error((Object)"ITitlePersistCallback.onBeforePersist", (Throwable)ex);
            }
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)String.format("Time taken to onBeforePersist - time: %d ms, titleId = %d, originalTitleId = %d", t1 - t2, title.getId(), title.getOriginalId()));
    }

    private void onPersist(Title title) {
        ServiceLoader<ITitlePersistCallback> loader = ServiceLoader.load(ITitlePersistCallback.class);
        Iterator<ITitlePersistCallback> serviceIterator = loader.iterator();
        if (serviceIterator == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        while (serviceIterator.hasNext()) {
            try {
                long t2 = System.currentTimeMillis();
                ITitlePersistCallback cb = serviceIterator.next();
                cb.onPersist(title);
                long t3 = System.currentTimeMillis();
                logger.debug((Object)String.format("Time taken to onPostPersist - time: %d ms, class = %s, titleId = %d, originalTitleId = %d", t2 - t3, cb.getClass().getName(), title.getId(), title.getOriginalId()));
            }
            catch (Exception ex) {
                logger.error((Object)"ITitlePersistCallback.onPersist", (Throwable)ex);
            }
        }
        long t4 = System.currentTimeMillis();
        logger.debug((Object)String.format("Time taken to onPostPersistTotal - time: %d ms, titleId = %d, originalTitleId = %d", t1 - t4, title.getId(), title.getOriginalId()));
    }

    @Transactional
    public boolean delete(Long titleID) throws TitleDeleteException {
        if (!this.isActive(titleID)) {
            return false;
        }
        Title title = this.getForUpdate(titleID);
        if (this.isPackage(title.getId())) {
            try {
                List<Long> associatedOfferIds = this.getOfferIds(title.getId());
                if (associatedOfferIds != null && !associatedOfferIds.isEmpty()) {
                    throw new TitleDeleteException("OFFER_TITLE", ". This title is associated in Offer Title " + associatedOfferIds);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Title is referenced in offers", (Throwable)e);
                throw new TitleDeleteException("OFFER_TITLE", e.getLocalizedMessage());
            }
        }
        this.onBeforeDelete(title);
        boolean result = this.titlePersistenceService.delete(titleID);
        this.onDelete(title);
        TransactionalRegister.getInstance().registerRollbackCallback(t -> this.syncElasticSearch(title));
        if (!title.isCopy()) {
            RulesEngineFacade.sendDeletedEvent(this.get(titleID));
        }
        if (result) {
            TitleUtil.buildTitleMetricsLog(title, TitleOperationTypeEnum.Deleted);
        }
        return result;
    }

    private void onBeforeDelete(Title title) {
        ServiceLoader<ITitleDeleteCallback> loader = ServiceLoader.load(ITitleDeleteCallback.class);
        Iterator<ITitleDeleteCallback> serviceIterator = loader.iterator();
        if (serviceIterator == null) {
            return;
        }
        while (serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onBeforeDelete(title);
            }
            catch (Exception e) {
                if (e.getCause() instanceof SiteManagementException && ((SiteManagementException)e.getCause()).getErrorCode() != null && "SITE_OFFER_EX".equalsIgnoreCase(((SiteManagementException)e.getCause()).getErrorCode())) {
                    String msg = "since one or more of its site titles are referenced to site offers. Try to Delete or Re-target offer.";
                    throw new TitleDeleteException(((SiteManagementException)e.getCause()).getErrorCode(), msg);
                }
                logger.error((Object)"Execute onBeforeDelete error", (Throwable)e);
            }
        }
    }

    private void onDelete(Title title) {
        ServiceLoader<ITitleDeleteCallback> loader = ServiceLoader.load(ITitleDeleteCallback.class);
        Iterator<ITitleDeleteCallback> serviceIterator = loader.iterator();
        if (serviceIterator == null) {
            return;
        }
        while (serviceIterator.hasNext()) {
            try {
                serviceIterator.next().onDelete(title);
            }
            catch (Exception ex) {
                logger.error((Object)"ITitleDeleteCallback.onDelete", (Throwable)ex);
            }
        }
    }

    @Transactional
    public Title get(Long titleID) {
        return this.titlePersistenceService.get(titleID);
    }

    @Transactional
    public Title get(Long titleID, boolean ignoreDraft) {
        return this.titlePersistenceService.get((Serializable)titleID, ignoreDraft);
    }

    @Transactional
    public Title getForUpdate(Long titleID) {
        return this.titlePersistenceService.getTitleForUpdate(titleID);
    }

    @Transactional
    public Title get(Long titleID, String version) {
        return this.titlePersistenceService.get((Serializable)titleID, version);
    }

    @Transactional
    @Deprecated
    public Title getWithHistory(Long titleID) {
        return this.titlePersistenceService.getWithHistory(titleID);
    }

    @Transactional
    public Long getIDByAssetID(Long rootAssetID) {
        return this.titlePersistenceService.getIdByAssetId(rootAssetID);
    }

    @Transactional
    public boolean isActive(Long titleID) {
        return this.titlePersistenceService.isActiveTitle(titleID);
    }

    @Transactional
    public boolean isExisting(Long titleID) {
        return this.titlePersistenceService.isExistingTitle(titleID);
    }

    @Transactional
    public void verifyTitleExists(Long titleID) {
        if (!this.isExisting(titleID)) {
            String msg = "The title[" + titleID + "] does not exist.";
            String errorCode = "TPS-007";
            TitlePersistenceException error = new TitlePersistenceException(errorCode, msg);
            error.getParameters().add(String.valueOf(titleID));
            error.getParameters().add("The title does not exist");
            throw error;
        }
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title, boolean draft) throws TitleValidationException {
        return this.titleValidator.validate(title, draft);
    }

    public com.tandbergtv.metadatamanager.model.File createDerivedFile() {
        return this.titleAssetManager.createDerivedFile();
    }

    public com.tandbergtv.metadatamanager.model.File createOriginalFile() {
        return this.titleAssetManager.createOriginalFile();
    }

    public Set<String> getFileLookupKeys(Asset asset) {
        return this.titleAssetManager.getFileLookupKeys(asset);
    }

    public String getFileLookupKey(com.tandbergtv.metadatamanager.model.File file) {
        return this.titleAssetManager.getFileLookupKey(file);
    }

    public com.tandbergtv.metadatamanager.model.File getFileWithLookupKey(Asset asset, String fileLookupKey) {
        return this.titleAssetManager.getFileWithLookupKey(asset, fileLookupKey);
    }

    public Collection<com.tandbergtv.metadatamanager.model.File> getFilesWithoutLookupKey(Asset asset) {
        return this.titleAssetManager.getFilesWithoutLookupKey(asset);
    }

    public void filterFiles(Asset asset, Set<String> fileLookupKeys) {
        this.titleAssetManager.filterFiles(asset, fileLookupKeys);
    }

    public void filterFiles(Asset asset, String fileLookupKey) {
        this.titleAssetManager.filterFiles(asset, fileLookupKey);
    }

    public void updateWithFileMetadata(Asset asset, String fileLookupKey) throws MetadataException {
        this.titleAssetManager.updateWithFileMetadata(asset, fileLookupKey);
    }

    public void setLookupKey(com.tandbergtv.metadatamanager.model.File file, String value) {
        this.titleAssetManager.setLookupKey(file, value);
    }

    public Document getDocument(Title title, Specification specification) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title, specification);
    }

    @Deprecated
    public Document getDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getDocument(title);
    }

    public Document getTTVDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTTVDocument(title);
    }

    public Document getECMFDocument(Title title) throws TitleDocumentActionException {
        return this.titleDocumentManager.getECMFDocument(title);
    }

    public Title getTitle(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitle(document);
    }

    public List<Long> getTitleIDs(Document document) throws TitleDocumentActionException {
        return this.titleDocumentManager.getTitleIDs(document);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titlePersistenceService = this.getService(ITitlePersistenceService.class);
        this.statusService = new TitleStatusService();
        this.titleValidator = new TitleValidator();
        this.titleAssetManager = new TitleAssetManager();
        this.titleDocumentManager = new TitleDocumentManager(this);
        this.thumbnailHandler = new TitleThumbnailHandler();
        this.fileManager = new FileManager();
        this.titleSearchService = this.getService(ITitleSearchService.class);
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    @Transactional
    public ISavedTitle retire(Long titleID, ITitleActionSource source) throws TitleValidationException {
        Title title = this.getForUpdate(titleID);
        this.removePhysicalFiles(title);
        this.deleteResourcesFromTitle(titleID);
        if (title.getIsActive().booleanValue()) {
            this.removeAssetFiles(title);
            title.setStatus(TitleStatus.RETIRED);
        }
        Date now = new Date();
        title.setLastModifiedTime(now);
        title.setRetirementDate(now);
        this.titlePersistenceService.retire(title);
        this.statusService.sendStatus(title, ProgressStatusHelper.RETIRED, null, true, source.getComponentName(), source.getEntityName(), source.getID());
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(title);
        }
        catch (Exception ex) {
            throw new TitlePersistenceException(COULD_NOT_UPDATE_ELASTICSEARCH, (Throwable)ex);
        }
        return new SaveResult(title, new LinkedList());
    }

    private void removePhysicalFiles(Title title) {
        List files = title.getAllFiles();
        HashSet<String> deletedFileUrls = new HashSet<String>();
        for (com.tandbergtv.metadatamanager.model.File file : files) {
            if (this.titleSearchService.isSharedFilePathAllcopies(file.getURL(), title.getId())) continue;
            deletedFileUrls.add(file.getURL());
        }
        this.collectOldRevisionFiles(title, deletedFileUrls);
        for (String fileUrl : deletedFileUrls) {
            this.deleteContentFile(fileUrl);
        }
    }

    private void collectOldRevisionFiles(Title title, Set<String> deletedFileUrls) {
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        AssetSearchService searchService = specHandler.getSearchService();
        String path = "/" + AssetType.FILE.toString() + FieldName.FILE_URL.toString();
        long documentId = title.getDocumentId();
        deletedFileUrls.addAll(searchService.getFieldValuesFromForRevision(path, Long.valueOf(documentId)));
    }

    private void deleteContentFile(String fileUrl) {
        try {
            if (fileUrl != null) {
                File ioFile = new File(fileUrl);
                this.fileManager.deleteFile(ioFile);
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Failed to delete title content file: %s, error: %s", fileUrl, e.getMessage()));
        }
    }

    private void removeAssetFiles(Title title) {
        for (com.tandbergtv.metadatamanager.model.File file : title.getAllFiles()) {
            title.removeAsset((Asset)file);
        }
    }

    private void deleteResourcesFromTitle(Long titleID) {
        List<TitleResource> resources = this.titleResourceManager().getByTitle(titleID);
        for (TitleResource resource : resources) {
            this.titleResourceManager().delete(resource.getId());
        }
    }

    @Transactional
    public Map<String, String> getProperties(Long titleID) {
        if (titleID == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        this.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        List<TitleProperty> properties = propertyManager.retrieveAll(titleID, null, null);
        HashMap<String, String> result = new HashMap<String, String>();
        for (TitleProperty tp : properties) {
            result.put(tp.getName(), tp.getValue());
        }
        return result;
    }

    @Transactional
    public String getProperty(Long titleID, String name) {
        if (titleID == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        this.verifyTitleExists(titleID);
        TitlePropertyManager propertyManager = TitlePropertyManager.getInstance();
        TitleProperty property = propertyManager.retrieve(name, titleID, null, null);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    @Transactional
    public void setProperty(Long titleID, String name, String value) {
        this.verifyTitleExists(titleID);
        TitleProperty property = this.createProperty(titleID, name, value);
        if (value == null || "".equals(value)) {
            TitlePropertyManager.getInstance().remove(property);
        } else {
            TitlePropertyManager.getInstance().store(property);
        }
    }

    private TitleProperty createProperty(Long titleID, String name, String value) {
        TitleProperty result = new TitleProperty();
        result.setTitleId(titleID);
        result.setName(name);
        result.setValue(value);
        return result;
    }

    @Deprecated
    public Title normalize(Title title, String contentEventName) {
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException(CONTENT_EVENT_NAME_CANNOT_BE_NULL);
        }
        return RulesEngineFacade.nationalize(title, contentEventName, null);
    }

    @Deprecated
    public Title normalizeWithMetadataEnhancement(Title title, String contentEventName, String meRequestKey) {
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException(CONTENT_EVENT_NAME_CANNOT_BE_NULL);
        }
        return RulesEngineFacade.nationalize(title, contentEventName, meRequestKey);
    }

    public NormalizedItem normalizeTitle(Title title, String contentEventName) {
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException(CONTENT_EVENT_NAME_CANNOT_BE_NULL);
        }
        return RulesEngineFacade.nationalizeTitle(title, contentEventName, null);
    }

    public NormalizedItem normalizeTitleWithMetadataEnhancement(Title title, String contentEventName, String meRequestKey) {
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        if (contentEventName == null) {
            throw new IllegalArgumentException(CONTENT_EVENT_NAME_CANNOT_BE_NULL);
        }
        return RulesEngineFacade.nationalizeTitle(title, contentEventName, meRequestKey);
    }

    public ISavedTitle save(Title title, ITitleActionSource source) throws TitleValidationException {
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        try {
            return this.createOrUpdate(title, false, source);
        }
        catch (TitleValidationException e) {
            ISavedTitle savedTitle = this.createOrUpdate(title, true, source);
            Title title2 = savedTitle.getTitle();
            this.statusService.sendStatus(title2, ProgressStatusHelper.VALIDATION_FAILURE, e.getMessage(), false, source.getComponentName(), source.getEntityName(), source.getID());
            return new SaveResult(savedTitle, e);
        }
    }

    @Transactional
    public ISavedTitle savePlannerTitle(Title title, ITitleActionSource source) throws TitleValidationException {
        ISavedTitle titleObject;
        if (title == null) {
            throw new IllegalArgumentException(TITLE_CANNOT_BE_NULL);
        }
        if (title.getId() == null) {
            titleObject = this.saveOrRollback(title, null, false, false, source, ProgressStatusHelper.CREATED, null, false, false, true);
            if (titleObject != null && titleObject.getTitle() != null) {
                TitleUtil.buildTitleMetricsLog(titleObject.getTitle(), TitleOperationTypeEnum.Created);
            }
        } else {
            titleObject = this.saveOrRollback(title, null, false, false, source, ProgressStatusHelper.UPDATED, null, false, false, true);
        }
        return titleObject;
    }

    @Transactional
    public ISavedTitle associateTitleToSeries(Long titleID, Long seriesDocumentId, Long seasonAssetId, ITitleActionSource source) throws TitleValidationException {
        Title episodeTitle;
        TitleStatus status;
        if (titleID == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        Long seriesTitleId = this.getIDByAssetID(seriesDocumentId);
        if (seriesTitleId == null) {
            throw new IllegalArgumentException("No series title found for given seriesDocumentId");
        }
        Long episodePartnerId = this.getPartnerId(titleID);
        Long seriesPartnerId = this.getPartnerId(seriesTitleId);
        if (episodePartnerId != null && seriesPartnerId != null && episodePartnerId.longValue() != seriesPartnerId.longValue()) {
            throw new IllegalArgumentException("You cannot associate to a series title with different partner id");
        }
        if (seasonAssetId != null) {
            Asset seriesRootAsset = this.getAsset(seriesDocumentId);
            List seasons = seriesRootAsset.getTargetAssets("Season");
            if (seasons.isEmpty()) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
            boolean isValid = false;
            for (Asset a : seasons) {
                Long assetId = a.getId();
                if (assetId.longValue() != seasonAssetId.longValue()) continue;
                isValid = true;
                break;
            }
            if (!isValid) {
                throw new IllegalArgumentException("Invalid seasonAssetId");
            }
        }
        if ((status = (episodeTitle = this.getForUpdate(titleID)).getStatus()) == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot associate a deleted title to a series title");
        }
        if (episodeTitle.isCopy()) {
            throw new IllegalArgumentException("You cannot associate a site title to a series title");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        String rootAssetType = episodeRootAsset.getAssetType();
        if ("SERIES".equalsIgnoreCase(rootAssetType)) {
            throw new IllegalArgumentException("You cannot associate a series title to another series title.");
        }
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, seriesDocumentId, seasonAssetId);
        }
        catch (Exception e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
        }
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(episodeTitle);
        }
        catch (Exception ex) {
            throw new RuntimeException(COULD_NOT_UPDATE_ELASTICSEARCH, ex);
        }
        return new SaveResult(episodeTitle, msgs);
    }

    @Transactional
    public void dissociateTitleFromSeries(Long titleID) throws TitleValidationException {
        if (titleID == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        Title episodeTitle = this.getForUpdate(titleID);
        TitleStatus status = episodeTitle.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot dissociate a deleted title");
        }
        Asset episodeRootAsset = episodeTitle.getAsset();
        ISpecHandler specHandler = SpecHandlerFactory.getInstance((String)"TTV");
        ArrayList<TitleValidationMessage> msgs = new ArrayList<TitleValidationMessage>();
        try {
            specHandler.associateTitleToSeries(episodeRootAsset, null, null);
        }
        catch (MetadataException e) {
            TitleValidationMessage msg = TitleValidationMessage.createErrorAssetMessage((String)"Package", (String)"", (String)e.getMessage());
            msgs.add(msg);
            throw new TitleValidationException(msgs);
        }
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        try {
            elasticSearchService.saveTitle(episodeTitle);
        }
        catch (Exception ex) {
            throw new RuntimeException(COULD_NOT_UPDATE_ELASTICSEARCH, ex);
        }
    }

    private ISavedTitle createOrUpdate(Title title, boolean draft, ITitleActionSource source) throws TitleValidationException {
        if (title.getId() == null) {
            return this.create(title, draft, source);
        }
        return this.update(title, draft, source);
    }

    public Long getPartnerId(Long titleId) {
        return this.titlePersistenceService.getPartnerId(titleId);
    }

    public ITitleResourceManager titleResourceManager() {
        return (ITitleResourceManager)ServiceRegistry.getDefault().lookup(ITitleResourceManager.class);
    }

    public Asset getAsset(Long id) {
        return this.titleAssetManager.getAsset(id);
    }

    @Transactional
    public void saveProcessingStatus(long titleID, TitleProcessingStatus processingStatus, ITitleActionSource titleActionSource) throws TitleValidationException {
        Title title = this.getForUpdate(titleID);
        title.setProcessingStatus(processingStatus);
        this.updateProcessingStatus(title);
    }

    @Transactional
    public boolean isOriginalTitle(long titleId) {
        return this.titlePersistenceService.isOriginalTitle(Long.valueOf(titleId));
    }

    @Transactional
    public void updateDistributionStatus(Long id, String status) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.getNamedQuery("Title.udpateDistStatus").setString("dist_status", status).setLong(TITLE_ID, id.longValue()).executeUpdate();
    }

    @Transactional
    public void updateDistributionDate(Long id, Date date) {
        Session session = HibernateContext.getContext().getCurrentSession();
        session.getNamedQuery("Title.updateDistDate").setTimestamp("dist_date", date).setLong(TITLE_ID, id.longValue()).executeUpdate();
    }

    @Transactional
    public ISavedTitle addTitleToOffer(Long titleId, Long offerTitleId, ITitleActionSource source) throws TitleValidationException {
        if (titleId == null || offerTitleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        if (!this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot update offer title since it is not active");
        }
        Title title = this.get(titleId);
        TitleStatus status = title.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot add a deleted title to an offer");
        }
        if (title.isCopy()) {
            throw new IllegalArgumentException("You cannot add a site title to an offer");
        }
        Title offerTitle = this.getForUpdate(offerTitleId);
        IContentClassService ccService = this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        ContentClass offerContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(title.getContentClassId().longValue());
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Series) {
            throw new IllegalArgumentException("You cannot add a series to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Category) {
            throw new IllegalArgumentException("You cannot add a category to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Offer) {
            throw new IllegalArgumentException("You cannot add an offer to another offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        int refCount = ((Group)rootAsset).getReferencedTitleIds().size();
        if (refCount >= 200) {
            throw new RuntimeException("Cannot add any more referenced titles. The limit is 200 titles");
        }
        ((Group)rootAsset).addReferencedTitleId(titleId);
        return this.save(offerTitle, source);
    }

    public void addTitleToOfferValidation(Long titleId) {
        if (titleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        Title title = this.get(titleId);
        TitleStatus status = title.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot add a deleted title [" + title.getId() + "] to an offer");
        }
        if (title.isCopy()) {
            throw new IllegalArgumentException("You cannot add a site title [" + title.getId() + "]  to an offer");
        }
        IContentClassService ccService = this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(title.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (titleContentClass.getType() == ContentClass.Type.Series) {
            throw new IllegalArgumentException("You cannot add a series [" + title.getId() + "] to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Category) {
            throw new IllegalArgumentException("You cannot add a category [" + title.getId() + "] to an offer");
        }
        if (titleContentClass.getType() == ContentClass.Type.Offer) {
            throw new IllegalArgumentException("You cannot add an offer [" + title.getId() + "] to another offer");
        }
    }

    @Transactional
    public ISavedTitle removeTitleFromOffer(Long titleId, Long offerTitleId, ITitleActionSource source) throws TitleValidationException {
        if (titleId == null || offerTitleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        if (!this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot update offer title since it is not active");
        }
        IContentClassService ccService = this.getService(IContentClassService.class);
        Title offerTitle = this.getForUpdate(offerTitleId);
        ContentClass offerContentClass = null;
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        List refTitleIds = ((Group)rootAsset).getReferencedTitleIds();
        if (refTitleIds == null || !refTitleIds.contains(titleId)) {
            throw new IllegalArgumentException("Referenced title cannot be removed as there is no such title in the offer");
        }
        refTitleIds.remove(titleId);
        return this.save(offerTitle, source);
    }

    @Transactional
    public List<Long> getReferencedTitleIdsFromOffer(Long offerTitleId) throws TitleValidationException {
        if (offerTitleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        if (!this.isActive(offerTitleId)) {
            throw new IllegalArgumentException("You cannot get referenced Title IDs from offer title since it is not active");
        }
        Title offerTitle = this.get(offerTitleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (offerContentClass.getType() != ContentClass.Type.Offer) {
            throw new IllegalArgumentException("Title having id " + offerTitleId + " is not an offer");
        }
        Asset rootAsset = offerTitle.getAsset();
        List titleIds = ((Group)rootAsset).getReferencedTitleIds();
        ArrayList<Long> refTitleIds = new ArrayList<Long>();
        refTitleIds.addAll(titleIds);
        return refTitleIds;
    }

    @Transactional
    public boolean isOffer(Long titleId) {
        boolean result = false;
        if (titleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        if (!this.isActive(titleId)) {
            throw new IllegalArgumentException("Title Id [" + titleId + "] it is not active");
        }
        Title offerTitle = this.get(titleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get Offer contentclass");
        }
        if (offerContentClass.getType() == ContentClass.Type.Offer) {
            result = true;
        }
        return result;
    }

    @Transactional
    public List<Long> getOfferIds(Long referenceTitleId) throws TitleValidationException {
        if (referenceTitleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        if (!this.isActive(referenceTitleId)) {
            throw new RuntimeException("You cannot get associated Offer IDs from a title that is not active");
        }
        Title refTitle = this.get(referenceTitleId);
        TitleStatus status = refTitle.getStatus();
        if (status == TitleStatus.DELETED) {
            throw new IllegalArgumentException("You cannot get associated Offer IDs from a title that is deleted");
        }
        IContentClassService ccService = this.getService(IContentClassService.class);
        ContentClass titleContentClass = null;
        try {
            titleContentClass = ccService.getContentClassById(refTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get contentclass");
        }
        if (titleContentClass.getType() != ContentClass.Type.Package) {
            throw new IllegalArgumentException("Reference Title having id " + referenceTitleId + " is not a master title");
        }
        ArrayList<Long> associatedOfferIds = new ArrayList<Long>();
        ArrayList<String> referencedTitleIds = new ArrayList<String>();
        referencedTitleIds.add(referenceTitleId.toString());
        try {
            IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
            ExpList rootNode = new ExpList();
            PredicateRightValue predicate = new PredicateRightValue();
            SearchParameters params = new SearchParameters();
            params.setFields(Arrays.asList(new SearchParameters.FieldInfo("contentMapping", "string")));
            params.setPageSize(10000);
            params.setSortField("id");
            if (refTitle.isCopy()) {
                predicate.setFieldTypeLhs(FieldType.SITE);
                params.setTitleIndexType(ElasticSearchIndexType.SITE);
            } else {
                predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
                params.setTitleIndexType(ElasticSearchIndexType.MASTER);
            }
            predicate.setFieldLeft("referencedTitleIds");
            predicate.setDataType("long");
            predicate.setOperator(LogicalOperator.IN);
            predicate.setValue(referencedTitleIds);
            ExpValue node = new ExpValue((Predicate)predicate);
            rootNode.addItem((ExpNode)node);
            TitleSearchResult tsResult = elasticSearchService.advancedSearch((ExpNode)rootNode, params);
            for (TitleSearchResult.SearchRow row : tsResult.getRows()) {
                associatedOfferIds.add(row.getId());
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Get associated offer title ids list error", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Get associated offer title ids list error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return associatedOfferIds;
    }

    @Transactional
    public boolean isPackage(Long titleId) {
        boolean result = false;
        if (titleId == null) {
            throw new IllegalArgumentException(TITLE_ID_CANNOT_BE_NULL);
        }
        Title offerTitle = this.get(titleId);
        ContentClass offerContentClass = null;
        IContentClassService ccService = this.getService(IContentClassService.class);
        try {
            offerContentClass = ccService.getContentClassById(offerTitle.getContentClassId().longValue());
        }
        catch (ContentClassPersistenceException ex) {
            throw new IllegalArgumentException("Failed to get title contentclass");
        }
        if (offerContentClass.getType() == ContentClass.Type.Package) {
            result = true;
        }
        return result;
    }

    @Transactional
    public String getPriority(Long titleId) {
        String processPriority = "NORMAL";
        try {
            processPriority = RulesEngineFacade.getPriority(titleId);
            logger.debug((Object)("From Rules Engine, got ProcessPriority : " + processPriority + " for titleId : " + titleId));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting ProcessPriority for titleId : " + titleId + " : " + e), (Throwable)e);
        }
        return processPriority;
    }

    public long getClusterWideSearchCount(Set<String> fields, String value) throws TitleValidationException {
        IElasticSearchService elasticSearchService = this.getService(IElasticSearchService.class);
        long hits = 0L;
        try {
            hits = elasticSearchService.getClusterWideSearchCount(fields, value);
        }
        catch (Exception e) {
            logger.error((Object)("Error while searching all indexes for lookupKey association , fields : " + fields.toString() + " , searchValue : " + value), (Throwable)e);
            throw new RuntimeException(e);
        }
        return hits;
    }

    @Transactional
    private void syncElasticSearch(Title title) {
        ElasticSearchTitleCallback esCallback = new ElasticSearchTitleCallback();
        if (title != null && this.isExisting(title.getId())) {
            esCallback.onPersist(this.get(title.getId()));
        } else {
            esCallback.onDelete(title);
        }
    }
}

