/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleDistributionStatus;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.TitleOperationTypeEnum;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class TitleUtil {
    private static final String CONTENT_MGMT_UI_GROUP = "com.ericsson.cms.contentmgmt.ui";
    private static final String CASE_SENSITIVE_FILE_MAPPING = "ContentComponent.TitleView.CaseSensitiveFileMapping";
    private static final String CASE_SENSITIVE_PROVIDER_ID = "ContentComponent.TitleView.ProviderIdCaseSensitive";
    private static IConfigurationService configurationService;
    private static IPartnerManagement partnerManagement;
    private static final Logger logger;

    public static TitleDistributionStatus getAggregatedDistributionStatus(Map<String, String> sitesDistributionStatusMap) {
        if (sitesDistributionStatusMap == null || sitesDistributionStatusMap.size() == 0) {
            return TitleDistributionStatus.NONE;
        }
        boolean foundFailed = false;
        int distributedStatusCount = 0;
        for (String value : sitesDistributionStatusMap.values()) {
            if (value == TitleDistributionStatus.IN_PROGRESS.toString()) {
                return TitleDistributionStatus.IN_PROGRESS;
            }
            if (value == TitleDistributionStatus.FAILED.toString()) {
                foundFailed = true;
            }
            if (value != TitleDistributionStatus.DISTRIBUTED.toString()) continue;
            ++distributedStatusCount;
        }
        if (foundFailed) {
            return TitleDistributionStatus.FAILED;
        }
        if (sitesDistributionStatusMap.size() == distributedStatusCount) {
            return TitleDistributionStatus.DISTRIBUTED;
        }
        return TitleDistributionStatus.WAITING;
    }

    public static String getMetadataValue(Collection<Field> fields, String fieldName, String sectionName) {
        for (Field f : fields) {
            if (!f.getTtvXPath().equalsIgnoreCase(fieldName)) continue;
            if (sectionName != null && sectionName.trim().length() > 0) {
                if (!f.getParentAsset().getPath().equalsIgnoreCase(sectionName)) continue;
                return f.getValue();
            }
            return f.getValue();
        }
        return "";
    }

    public static String getFileName(Asset asset) {
        String fileName;
        Field fileNameField = asset.getFirstField(FieldName.URL.toString());
        String string = fileName = fileNameField != null ? fileNameField.getValue() : null;
        if (fileName != null && (fileName = fileName.trim()).length() == 0) {
            fileName = null;
        }
        return fileName;
    }

    public static Map<String, String> getContentMgmtUTSettings() {
        IConfigurationService configurationService = TitleUtil.getConfigurationService();
        return configurationService.getProperties(CONTENT_MGMT_UI_GROUP);
    }

    public static boolean isProviderIdCaseSensitive() {
        Map<String, String> progSettings = TitleUtil.getContentMgmtUTSettings();
        return Boolean.parseBoolean(progSettings.get(CASE_SENSITIVE_PROVIDER_ID));
    }

    public static boolean compareProviderId(String providerId1, String providerId2, boolean isCaseSensitive) {
        return isCaseSensitive ? providerId1.equals(providerId2) : providerId1.equalsIgnoreCase(providerId2);
    }

    public static boolean compareFileNames(String name1, String name2) {
        Map<String, String> progSettings = TitleUtil.getContentMgmtUTSettings();
        boolean isCaseSensitive = Boolean.parseBoolean(progSettings.get(CASE_SENSITIVE_FILE_MAPPING));
        return isCaseSensitive ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    public static boolean checkContainsWithNeptuneSetting(String filePath, String pathFilter) {
        return TitleUtil.isProviderIdCaseSensitive() ? filePath.contains(pathFilter) : filePath.toLowerCase().contains(pathFilter.toLowerCase());
    }

    public static IConfigurationService getConfigurationService() {
        if (configurationService == null) {
            return (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        }
        return configurationService;
    }

    public static void setConfigurationService(IConfigurationService configurationService) {
        TitleUtil.configurationService = configurationService;
    }

    public static File getValidIngestFolder(String folderPath) throws TitleIngestException {
        if (folderPath == null) {
            throw new IllegalArgumentException("folderPath can't be null");
        }
        File result = new File(folderPath);
        if (!result.exists()) {
            throw new TitleIngestException("The folder " + folderPath + " doesn't exist.");
        }
        if (!result.isDirectory()) {
            throw new TitleIngestException("The path " + folderPath + " is not a directory.");
        }
        return result;
    }

    public static void buildTitleMetricsLog(Title title, TitleOperationTypeEnum operationType) {
        try {
            StringBuilder sb = new StringBuilder("application-metrics.").append(partnerManagement.getPartner(title.getPartnerId().longValue()).getName().replaceAll("\\.", "_")).append(".titles_metrics.").append(title.getId()).append(".").append((Object)operationType).append(" ").append(title.isCopy() ? "0" : "1").append(" ").append(System.currentTimeMillis());
            logger.info((Object)sb.toString());
        }
        catch (Exception ex) {
            logger.error((Object)("Error generating title metrics log for title " + title.getId()));
        }
    }

    public static void buildTitleE2ELog(Title title, Long titleDistributionTime) {
        try {
            StringBuilder sb = new StringBuilder("application-metrics.").append(partnerManagement.getPartner(title.getPartnerId().longValue()).getName().replaceAll("\\.", "_")).append(".titles_e2etime_seconds.").append(title.getId()).append(" ").append(titleDistributionTime).append(" ").append(System.currentTimeMillis());
            logger.info((Object)sb.toString());
        }
        catch (Exception ex) {
            logger.error((Object)("Error generating title end to end log for title " + title.getId()));
        }
    }

    static {
        partnerManagement = (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
        logger = Logger.getLogger(TitleUtil.class);
    }
}

