/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.activity;

import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.ITitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivity;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivitySearchCriteria;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivitySortField;
import com.tandbergtv.watchpoint.pmm.entities.activity.TitleActivityType;
import com.tandbergtv.watchpoint.pmm.title.ITitleActivityService;
import com.tandbergtv.workflow.api.API;
import com.tandbergtv.workflow.api.Processes;
import com.tandbergtv.workflow.api.model.process.Process;
import com.tandbergtv.workflow.api.model.process.ProcessListResponse;
import com.tandbergtv.workflow.api.model.process.ProcessQueryBuilder;
import com.tandbergtv.workflow.api.model.process.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class TitleActivityService
implements ITitleActivityService {
    private static final String PROVIDER_ID = "providerId";
    private static final String SERVICE_NAME = "Title Activity Service";
    private static final Logger logger = Logger.getLogger(TitleActivityService.class);

    public List<ITitleActivity> getActivity(long titleId) {
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        return this.getActivity((ITitleActivitySearchCriteria)criteria);
    }

    public List<ITitleActivity> getActivity(long titleId, TitleActivityType activityType) {
        return this.getActivity(titleId, activityType, 100);
    }

    public List<ITitleActivity> getActivity(long titleId, TitleActivityType activityType, int maxWorkOrderCount) {
        if (activityType == null) {
            throw new IllegalArgumentException("The activityType cannot be null.");
        }
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        criteria.addActivityType(activityType);
        criteria.setRecordCount(Integer.valueOf(maxWorkOrderCount));
        return this.getActivity((ITitleActivitySearchCriteria)criteria);
    }

    public List<ITitleActivity> getActivity(ITitleActivitySearchCriteria criteria) {
        Processes request = this.createRequest();
        this.buildQuery(criteria, request.query());
        try {
            ProcessListResponse response = request.execute();
            return this.convertToTitleActivity(response);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title activity", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Long countActivity(long titleId) {
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        return this.countActivity((ITitleActivitySearchCriteria)criteria);
    }

    public Long countActivity(long titleId, TitleActivityType activityType) {
        if (activityType == null) {
            throw new IllegalArgumentException("The activityType cannot be null.");
        }
        TitleActivitySearchCriteria criteria = new TitleActivitySearchCriteria();
        criteria.addTitleID(titleId);
        criteria.addActivityType(activityType);
        return this.countActivity((ITitleActivitySearchCriteria)criteria);
    }

    public Long countActivity(ITitleActivitySearchCriteria criteria) {
        Processes request = this.createRequest();
        this.buildQuery(criteria, request.query());
        try {
            ProcessListResponse response = request.execute();
            return new Long(response.getTotal());
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get title activity", (Throwable)e);
            return 0L;
        }
    }

    private ProcessQueryBuilder buildQuery(ITitleActivitySearchCriteria criteria, ProcessQueryBuilder query) {
        if (criteria == null) {
            throw new IllegalArgumentException("The criteria cannot be null.");
        }
        if (!criteria.getProviderIds().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String providerId : criteria.getProviderIds()) {
                sb = sb.append(providerId).append(",");
            }
            query.providerId(sb.toString());
        }
        if (criteria.getTitleIDs() != null && !criteria.getTitleIDs().isEmpty()) {
            query.titleId(((Long)criteria.getTitleIDs().iterator().next()).toString());
        }
        query.status(this.getProcessStatus(criteria.getActivityTypes()));
        query.sortBy(this.getSortParameter(criteria));
        if (criteria.getStartRecord() != null) {
            query.start(criteria.getStartRecord().intValue());
        }
        if (criteria.getRecordCount() != null) {
            query.count(criteria.getRecordCount().intValue());
        }
        query.detail("summary");
        return query;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private ProcessStatus[] getProcessStatus(Set<TitleActivityType> activityTypes) {
        HashSet values = new HashSet();
        if (activityTypes == null || activityTypes.isEmpty()) {
            activityTypes.add(TitleActivityType.ACTIVE);
            activityTypes.add(TitleActivityType.HISTORICAL);
        }
        for (TitleActivityType activityType : activityTypes) {
            values.addAll(activityType.getAllCoveredProcessStatus());
        }
        return values.toArray(new ProcessStatus[0]);
    }

    private String getSortParameter(ITitleActivitySearchCriteria criteria) {
        TitleActivitySortField sortField = criteria.getSortField();
        if (sortField == null) {
            sortField = TitleActivitySortField.ACTIVITY_START_TIME;
        }
        switch (sortField) {
            case ACTIVITY_START_TIME: {
                return "start";
            }
            case ACTIVITY_END_TIME: {
                return "end";
            }
        }
        return "id";
    }

    private List<ITitleActivity> convertToTitleActivity(ProcessListResponse response) {
        ArrayList<ITitleActivity> activity = new ArrayList<ITitleActivity>();
        List list = response.getItems();
        for (Process process : list) {
            Long titleKey = null;
            if (process.getTitleId() != null && !process.getTitleId().isEmpty()) {
                titleKey = Long.valueOf(process.getTitleId());
            }
            TitleActivityType activityType = this.getActivityType(process);
            WFSearchResult result = this.getSearchResult(process);
            activity.add((ITitleActivity)new TitleActivity(titleKey, result, activityType));
        }
        return activity;
    }

    private WFSearchResult getSearchResult(Process process) {
        WFVariable variable;
        WFSearchResult result = new WFSearchResult();
        result.setProcessId((long)Integer.valueOf(process.getId()).intValue());
        result.setProcessDefinitionName(process.getTemplate());
        WFToken token = new WFToken();
        token.setNodeName(process.getCurrent());
        token.setStartTime(process.getStartDate());
        token.setEndTime(process.getEndDate());
        token.setErrorTime(process.getErrorDate());
        token.setErrorComment(process.getErrorMessage());
        token.setOperationalStatus(ProcessStatus.valueOf((String)process.getStatus()).ordinal());
        if (process.getTitleId() != null && !process.getTitleId().isEmpty()) {
            variable = new WFVariable();
            variable.setName("titleId");
            variable.addValue(process.getTitleId());
            result.addVariable(variable);
        }
        if (process.getProviderId() != null && !process.getProviderId().isEmpty()) {
            variable = new WFVariable();
            variable.setName(PROVIDER_ID);
            variable.addValue(process.getProviderId());
            result.addVariable(variable);
        }
        result.setToken(token);
        return result;
    }

    private Processes createRequest() {
        return new API.Builder().build().processes();
    }

    private TitleActivityType getActivityType(Process process) {
        ProcessStatus status = ProcessStatus.valueOf((String)process.getStatus());
        return TitleActivityType.mapStatusToActivityType((ProcessStatus)status);
    }
}

