/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.compare;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.metadatamanager.IAssetCompareService;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.compare.ITitleCompareReport;
import com.tandbergtv.watchpoint.pmm.title.ITitleCompareService;
import com.tandbergtv.watchpoint.pmm.title.ITitleCopyService;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.compare.TitleComparator;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;

public class TitleCompareService
implements ITitleCompareService {
    private static final String SERVICE_NAME = "Title Compare Service";
    private ITitleManager titleManager;
    private ITitleCopyService titleCopyService;
    private final IAssetCompareService assetCompareService;

    public TitleCompareService(IAssetCompareService assetCompareService) {
        this.assetCompareService = assetCompareService;
    }

    public ITitleCompareReport compareTitles(Title title1, Title title2) {
        TitleComparator comparator = new TitleComparator(this.assetCompareService);
        return comparator.compare(title1, title2);
    }

    @Transactional
    public ITitleCompareReport compareTitleWithVersion(long titleId, String version) {
        Title originalTitle = this.titleManager.get(Long.valueOf(titleId));
        Title versionedTitle = this.titleManager.get(Long.valueOf(titleId), version);
        return this.compareTitles(originalTitle, versionedTitle);
    }

    @Transactional
    public ITitleCompareReport compareTitleVersions(long titleId, String version1, String version2) {
        Title versionedTitle1 = this.titleManager.get(Long.valueOf(titleId), version1);
        Title versionedTitle2 = this.titleManager.get(Long.valueOf(titleId), version2);
        return this.compareTitles(versionedTitle1, versionedTitle2);
    }

    @Transactional
    public ITitleCompareReport compareTitleWithCopy(long copiedTitleId) {
        Title copy = this.titleManager.get(Long.valueOf(copiedTitleId));
        Title original = this.titleCopyService.getOriginalTitle(copiedTitleId);
        return this.compareTitles(original, copy);
    }

    public boolean areTitlesDifferent(Title title1, Title title2) {
        TitleComparator comparator = new TitleComparator(this.assetCompareService);
        return comparator.isDifferent(title1, title2);
    }

    @Transactional
    public boolean isTitleDifferentFromVersion(long titleId, String version) {
        Title originalTitle = this.titleManager.get(Long.valueOf(titleId));
        Title versionedTitle = this.titleManager.get(Long.valueOf(titleId), version);
        return this.areTitlesDifferent(originalTitle, versionedTitle);
    }

    @Transactional
    public boolean areTitleVersionsDifferent(long titleId, String version1, String version2) {
        Title versionedTitle1 = this.titleManager.get(Long.valueOf(titleId), version1);
        Title versionedTitle2 = this.titleManager.get(Long.valueOf(titleId), version2);
        return this.areTitlesDifferent(versionedTitle1, versionedTitle2);
    }

    @Transactional
    public boolean isTitleDifferentFromCopy(long copiedTitleId) {
        Title copy = this.titleManager.get(Long.valueOf(copiedTitleId));
        Title original = this.titleCopyService.getOriginalTitle(copiedTitleId);
        return this.areTitlesDifferent(original, copy);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.titleManager = this.getService(ITitleManager.class);
        this.titleCopyService = this.getService(ITitleCopyService.class);
    }

    public void stop() {
    }

    private <T extends Service> T getService(Class<T> serviceClass) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (T)((Service)registry.lookup(serviceClass));
    }
}

