/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class Relator {
    private Set<TitleConf> titleConfs = new HashSet<TitleConf>();

    Relator() {
    }

    public void relate(TitleConf newTC) {
        Iterator<TitleConf> titleSetIter = this.titleConfs.iterator();
        while (titleSetIter.hasNext()) {
            TitleConf tc = titleSetIter.next();
            if (!tc.getParentName().equals(newTC.getName())) continue;
            titleSetIter.remove();
            newTC.addChild(tc);
        }
        if (this.isNullOrEmpty(newTC.getParentName())) {
            this.titleConfs.add(newTC);
        } else {
            TitleConf parent = this.findByName(newTC.getParentName(), this.titleConfs);
            if (parent != null) {
                parent.addChild(newTC);
            } else {
                this.titleConfs.add(newTC);
            }
        }
    }

    private TitleConf findByName(String name, Collection<TitleConf> titleConfs) {
        for (TitleConf tc : titleConfs) {
            if (tc.getName().equals(name)) {
                return tc;
            }
            for (TitleConf descendant : tc.getAllDescendants()) {
                if (!descendant.getName().equals(name)) continue;
                return descendant;
            }
        }
        return null;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public Set<TitleConf> getFamilyTree() {
        return this.titleConfs;
    }
}

