/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import com.tandbergtv.watchpoint.pmm.title.conf.TitleConf;
import com.tandbergtv.watchpoint.pmm.title.conf.UISpecification;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class UISpecificationBuilder {
    private static final Logger logger = Logger.getLogger(UISpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID_PACKAGE = "provider";
    private static final String EXTENSION_POINT_ID_SERIES = "series_provider";
    private static final String DEFINITION_PATH_PARAMETER = "definitionResource";
    private static final String TABLE_CONFIG_PARAMETER = "tableConfigurationResource";
    private static final String BUNDLE_NAME = "resourcebundle";
    private PluginManager pluginManager;

    public UISpecificationBuilder(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public UISpecification buildPackageSpecification() {
        return this.buildUISpecification(EXTENSION_POINT_ID_PACKAGE);
    }

    public UISpecification buildSeriesSpecification(UISpecification packageSpec) {
        UISpecification seriesSpec = this.buildUISpecification(EXTENSION_POINT_ID_SERIES);
        HashMap<String, TitleConf> packageAssetMap = new HashMap<String, TitleConf>();
        List packageAssets = packageSpec.getAllTitleConf();
        for (TitleConf packageAsset : packageAssets) {
            packageAssetMap.put(packageAsset.getName(), packageAsset);
        }
        List seriesAssets = seriesSpec.getAllTitleConf();
        for (TitleConf seriesAsset : seriesAssets) {
            TitleConf packageAsset;
            if (!seriesAsset.getMetadata().isEmpty() || (packageAsset = (TitleConf)packageAssetMap.get(seriesAsset.getName())) == null) continue;
            seriesAsset.setMetadata(packageAsset.getMetadata());
        }
        return seriesSpec;
    }

    private UISpecification buildUISpecification(String extensionPointId) {
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, extensionPointId);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            try {
                if (!this.pluginManager.isPluginActivated(descriptor)) {
                    this.pluginManager.activatePlugin(descriptor.getId());
                }
                PluginClassLoader classloader = this.pluginManager.getPluginClassLoader(descriptor);
                UISpecification specification = this.buildSpecification(extension, classloader);
                logger.debug((Object)"Loaded UI Specification");
                return specification;
            }
            catch (Exception e) {
                e.printStackTrace();
                String key = descriptor.getId() + ":" + extension.getId();
                logger.error((Object)("Failed to load title specification extension: " + key), (Throwable)e);
            }
        }
        return null;
    }

    private UISpecification buildSpecification(Extension extension, PluginClassLoader classloader) throws SpecificationValidationException {
        String definitionPath = extension.getParameter(DEFINITION_PATH_PARAMETER).valueAsString();
        InputStream stream = classloader.getResourceAsStream(definitionPath);
        Extension.Parameter bundleparameter = extension.getParameter(BUNDLE_NAME);
        String bundleBaseName = "";
        if (bundleparameter != null) {
            bundleBaseName = bundleparameter.valueAsString();
            logger.debug((Object)("Bundle name " + bundleBaseName));
        }
        SpecificationReader reader = new SpecificationReader();
        UISpecification specification = reader.unmarshal(stream, (ClassLoader)classloader, bundleBaseName);
        String tableConfigPath = extension.getParameter(TABLE_CONFIG_PARAMETER).valueAsString();
        specification.setTableConfigurationPath(tableConfigPath);
        return specification;
    }
}

