/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldName;
import com.tandbergtv.watchpoint.pmm.core.AssetsManager;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleUtil;
import com.tandbergtv.watchpoint.pmm.title.ingest.FileMapResult;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FileToAssetMappingResolver {
    private static Logger logger = Logger.getLogger(FileToAssetMappingResolver.class);
    private static ITitleManager titleManager = FileToAssetMappingResolver.getService(ITitleManager.class);

    private FileToAssetMappingResolver() {
    }

    private static <T extends Service> T getService(Class<T> serviceClass) {
        return (T)((Service)ServiceRegistry.getDefault().lookup(serviceClass));
    }

    public static Map<String, FileMapResult> mapFilesForPackage(String metadataPath, String assetFolderPath, Title title) throws TitleIngestException {
        FileMapResult metadataMapping = FileToAssetMappingResolver.mapFile(title, title.getAsset(), metadataPath, true);
        List<String> assetFilePaths = FileToAssetMappingResolver.getAssetsInFolder(assetFolderPath);
        List<FileMapResult> contentMappings = FileToAssetMappingResolver.mapContentFiles(title, assetFilePaths, assetFolderPath);
        HashMap<String, FileMapResult> mappings = new HashMap<String, FileMapResult>();
        mappings.put(metadataPath, metadataMapping);
        for (FileMapResult fmr : contentMappings) {
            mappings.put(fmr.getPath(), fmr);
        }
        return mappings;
    }

    public static FileMapResult mapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        File file = new File(filePath);
        String size = null;
        try {
            size = String.valueOf(file.length());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        com.tandbergtv.metadatamanager.model.File newFile = titleManager.createOriginalFile();
        newFile.addField(new Field(FieldName.FILE_URL.toString(), filePath));
        if (size != null) {
            newFile.addField(new Field(FieldName.FILE_SIZE.toString(), size));
        }
        title.addFile(asset, newFile);
        return new FileMapResult(filePath, asset, newFile, isMetadata);
    }

    private static List<String> getAssetsInFolder(String assetFolderPath) throws TitleIngestException {
        File assetsFolder = TitleUtil.getValidIngestFolder(assetFolderPath);
        ArrayList<String> result = new ArrayList<String>();
        for (File f : assetsFolder.listFiles()) {
            if (f.isDirectory()) {
                result.addAll(FileToAssetMappingResolver.getAssetsInFolder(f.getAbsolutePath()));
                continue;
            }
            if (FileToAssetMappingResolver.isMetadataFile(f) || f.isDirectory()) continue;
            result.add(f.getAbsolutePath());
        }
        return result;
    }

    private static List<FileMapResult> mapContentFiles(Title title, List<String> assetFilePaths, String assetFolderPath) throws TitleIngestException {
        ArrayList<FileMapResult> result = new ArrayList<FileMapResult>();
        String folderPath = TitleUtil.getValidIngestFolder(assetFolderPath).getAbsolutePath();
        int indexOfRelativePath = folderPath.endsWith(File.separator) ? folderPath.length() : folderPath.length() + 1;
        for (String assetPath : assetFilePaths) {
            String relativeFilepath = assetPath.substring(indexOfRelativePath);
            Asset matchingAsset = FileToAssetMappingResolver.findAssetWithRelativeFilepath(title, relativeFilepath);
            if (matchingAsset == null) {
                FileMapResult noMappingResult = new FileMapResult(assetPath, null, null, false);
                result.add(noMappingResult);
                continue;
            }
            FileMapResult fileMappingResult = FileToAssetMappingResolver.mapFile(title, matchingAsset, assetPath, false);
            result.add(fileMappingResult);
        }
        return result;
    }

    private static Asset findAssetWithRelativeFilepath(Title title, String relativeFilepath) throws TitleIngestException {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        Asset result = null;
        for (Asset a : title.getAllAssets(false)) {
            if (!TitleUtil.compareFileNames(relativeFilepath, FileToAssetMappingResolver.getFieldValueOfAssetFile(a))) continue;
            if (result != null) {
                throw new TitleIngestException("Title has more than one asset with content file name: " + relativeFilepath);
            }
            result = a;
        }
        return result;
    }

    private static String getFieldValueOfAssetFile(Asset asset) {
        Field fileNameField = asset.getFirstField(FieldName.URL.toString());
        if (fileNameField == null || fileNameField.getValue() == null) {
            return null;
        }
        String value = fileNameField.getValue();
        if (value.startsWith("/") || value.startsWith("\\")) {
            value = value.replaceAll("^([/|\\\\]+)", "");
        }
        return value;
    }

    private static boolean isMetadataFile(File f) {
        return f.getName().toLowerCase().endsWith(".xml");
    }

    public static Map<String, FileMapResult> mapContent(Title title, Asset asset, String assetPath) throws TitleIngestException {
        HashMap<String, FileMapResult> result = new HashMap<String, FileMapResult>();
        FileMapResult mapping = FileToAssetMappingResolver.moveAndMapFile(title, asset, assetPath, false);
        result.put(assetPath, mapping);
        return result;
    }

    private static FileMapResult moveAndMapFile(Title title, Asset asset, String filePath, boolean isMetadata) throws TitleIngestException {
        File mappedFile = new File(filePath);
        if (FileToAssetMappingResolver.getAssetsManager().isUnmappedFilePath(filePath)) {
            mappedFile = FileToAssetMappingResolver.moveToMappedLocation(mappedFile);
        }
        return FileToAssetMappingResolver.mapFile(title, asset, mappedFile.getAbsolutePath(), isMetadata);
    }

    private static AssetsManager getAssetsManager() {
        return AssetsManager.getThreadLocalInstance();
    }

    private static File moveToMappedLocation(File file) throws TitleIngestException {
        try {
            return FileToAssetMappingResolver.getAssetsManager().moveToMappedFilesDirectory(file);
        }
        catch (IOException e) {
            throw new TitleIngestException("Failed to move file " + file.getAbsolutePath() + " to the mapped folder location, error:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static Collection<String> findUnmappedContentFiles(String providerId, Asset asset) throws TitleIngestException {
        String fileName = FileToAssetMappingResolver.getAssetFileName(asset);
        try {
            List<File> unmappedFiles = FileToAssetMappingResolver.getAssetsManager().getUnmappedFiles(fileName, providerId);
            ArrayList<String> result = new ArrayList<String>(unmappedFiles.size());
            for (File uf : unmappedFiles) {
                result.add(uf.getAbsolutePath());
            }
            return result;
        }
        catch (IOException e) {
            String msg = "Failed to get unmapped file paths for file name: " + fileName + ", error: " + e.getLocalizedMessage();
            throw new TitleIngestException(msg, (Throwable)e);
        }
    }

    public static Asset findAssetByFileName(Title title, String fileName) throws TitleIngestException {
        if (title == null || title.getAsset() == null) {
            return null;
        }
        Asset result = null;
        for (Asset a : title.getAllAssets(false)) {
            if (!TitleUtil.compareFileNames(fileName, FileToAssetMappingResolver.getAssetFileName(a))) continue;
            if (result != null) {
                throw new TitleIngestException("Title has more than one asset with content file name: " + fileName);
            }
            result = a;
        }
        return result;
    }

    public static String getAssetFileName(Asset asset) {
        String fileNameValue = FileToAssetMappingResolver.getFieldValueOfAssetFile(asset);
        if (fileNameValue == null) {
            return null;
        }
        int pathSeperaterIndex = fileNameValue.lastIndexOf(File.separator);
        if (pathSeperaterIndex < 0) {
            return fileNameValue;
        }
        return fileNameValue.substring(pathSeperaterIndex + 1, fileNameValue.length());
    }
}

