/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.ingest;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.core.ITitleStatusService;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationException;
import com.tandbergtv.watchpoint.pmm.core.TitleValidationMessage;
import com.tandbergtv.watchpoint.pmm.entities.ISavedTitle;
import com.tandbergtv.watchpoint.pmm.entities.ITitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.TitleStatusService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ContentMapping;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngestService;
import com.tandbergtv.watchpoint.pmm.title.ingest.ITitleIngester;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleAsset;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestException;
import com.tandbergtv.watchpoint.pmm.title.ingest.TitleIngestResult;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseManager;
import com.tandbergtv.watchpoint.pmm.util.NormalizedItem;
import com.tandbergtv.watchpoint.pmm.util.ProgressStatusHelper;
import com.tandbergtv.watchpoint.pmm.util.RulesEngineFacade;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.List;
import org.apache.log4j.Logger;

public class TitleIngester
implements ITitleIngester {
    private static final Logger logger = Logger.getLogger(TitleIngester.class);
    private static final String CONTENT_EVENT_NAME = "INGESTED";
    private ITitleIngestService titleIngestServiceInstance = null;
    private ITitleManager titleManagerInstance = null;
    private ITitleStatusService statusServiceInstance = null;

    @Transactional
    public ISavedTitle ingestMetadata(String metadataFilePath, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        TitleIngestResult ingestResult;
        ContentMapping contentMapping = this.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        if (contentMapping.hasNoMatch()) {
            this.checkLicense(contentClassName);
            ingestResult = this.titleIngestService().createTitleForMetadata(metadataFilePath, providerId, contentClassName, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = this.titleIngestService().updateTitleForMetadata(metadataFilePath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        NormalizedItem normalizedItem = this.titleManager().normalizeTitle(title, CONTENT_EVENT_NAME);
        ISavedTitle savedTitle = this.titleManager().save(title, source);
        this.statusService().sendStatus(title, ProgressStatusHelper.NORMALIZED, normalizedItem.getNormalizationChangeInfo(), true, source.getComponentName(), source.getEntityName(), source.getID());
        return savedTitle;
    }

    @Transactional
    public ISavedTitle ingestPackage(String metadataFilePath, String packageFolderPath, List<String> assetsNotInPackage, String providerId, String contentClassName, ITitleActionSource source) throws TitleIngestException, TitleValidationException {
        TitleIngestResult ingestResult;
        ContentMapping contentMapping = this.titleIngestService().getMappingForMetadata(metadataFilePath);
        if (contentMapping.hasDuplicateMatches()) {
            throw new TitleIngestException("Title has multiple matches in the system. Content Mapping: " + contentMapping);
        }
        if (contentMapping.hasNoMatch()) {
            this.checkLicense(contentClassName);
            ingestResult = this.titleIngestService().createTitleForPackage(metadataFilePath, packageFolderPath, providerId, contentClassName, source);
        } else {
            Long titleId = ((TitleAsset)contentMapping.getTitleAssets().iterator().next()).getTitleId();
            ingestResult = this.titleIngestService().updateTitleForPackage(metadataFilePath, packageFolderPath, titleId, source);
        }
        Title title = ingestResult.getSavedTitle().getTitle();
        for (String assetPath : assetsNotInPackage) {
            this.titleIngestService().updateTitleForContent(assetPath, title, source);
        }
        NormalizedItem normalizedItem = this.titleManager().normalizeTitle(title, CONTENT_EVENT_NAME);
        ISavedTitle savedTitle = this.titleManager().save(title, source);
        this.statusService().sendStatus(title, ProgressStatusHelper.NORMALIZED, normalizedItem.getNormalizationChangeInfo(), true, source.getComponentName(), source.getEntityName(), source.getID());
        return savedTitle;
    }

    private ITitleStatusService statusService() {
        if (this.statusServiceInstance == null) {
            this.statusServiceInstance = new TitleStatusService();
        }
        return this.statusServiceInstance;
    }

    public void sendIngestedEvent(Title title) {
        RulesEngineFacade.sendIngestedEvent(title);
    }

    public void sendIngestedEvent(Long titleId) {
        RulesEngineFacade.sendIngestedEvent(titleId);
    }

    private ITitleIngestService titleIngestService() {
        if (this.titleIngestServiceInstance == null) {
            this.titleIngestServiceInstance = (ITitleIngestService)ServiceRegistry.getDefault().lookup(ITitleIngestService.class);
        }
        return this.titleIngestServiceInstance;
    }

    @Transactional
    public List<TitleValidationMessage> validate(Title title) {
        try {
            return this.titleManager().validate(title, false);
        }
        catch (TitleValidationException e) {
            logger.error((Object)"Exception: ", (Throwable)e);
            return e.getMessages();
        }
    }

    private ITitleManager titleManager() {
        if (this.titleManagerInstance == null) {
            this.titleManagerInstance = (ITitleManager)ServiceRegistry.getDefault().lookup(ITitleManager.class);
        }
        return this.titleManagerInstance;
    }

    private void checkLicense(String contentClassName) {
        LicenseManager.getInstance().canIngestMasterTitle(LicenseFilter.newBuilder().setContentClassName(contentClassName).build());
    }

    public String getServiceName() {
        return "TitleIngester";
    }

    public void start() {
    }

    public void stop() {
    }
}

