/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.search;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.criteria.SearchColumn;
import com.ericsson.cms.criteria.info.PagingInfo;
import com.ericsson.cms.criteria.info.SortingInfo;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.cms.search.SearchParametersBuilder;
import com.ericsson.cms.search.TitleSearchResult;
import com.ericsson.cms.search.exception.TitleSearchException;
import com.ericsson.cms.search.util.ElasticSearchUtil;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.title.search.ITitleSearchService;
import com.tandbergtv.cms.title.search.InvalidSrchException;
import com.tandbergtv.cms.title.search.entities.FileSearchResult;
import com.tandbergtv.cms.title.search.entities.SiteType;
import com.tandbergtv.cms.titlefilter.CriteriaMode;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.metadatamanager.model.SeriesInfo;
import com.tandbergtv.metadatamanager.search.ConditionBuilderFactory;
import com.tandbergtv.metadatamanager.search.QueryBuilderFactory;
import com.tandbergtv.metadatamanager.search.SearchSchemaHelper;
import com.tandbergtv.neptune.util.GlobalDateFormatUtil;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.title.search.TitleQuickSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchQueryHelper;
import com.tandbergtv.watchpoint.pmm.title.search.TitleSearchWorkFactory;
import com.tandbergtv.watchpoint.pmm.title.search.binding.BindVariable;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.log4j.Logger;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.jdbc.Work;

public class TitleSearchService
implements ITitleSearchService {
    private static final Logger logger = Logger.getLogger((String)TitleSearchService.class.getName());
    private boolean isInited = false;
    private TitleSearchQueryHelper searchQueryHelper;
    private TitleQuickSearchQueryHelper qsQueryHelper;
    public static final String DATABASE_TIME_PATTERN = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}[.]{1}\\d{1} [+]{1}\\d{1}:\\d{2}";
    public static final int DATABASE_TIME_START_INDEX = 11;
    public static final int DATABASE_TIME_END_INDEX = 19;
    private static final int PAGESIZE = 1000;
    private static final String ADVANCED_SEARCH_ERROR = "Advanced search error";
    private static final String QUICK_SEARCH_ERROR = "Quick search error";
    private static final String ELASTICSEARCH_NOT_AVAILABLE = "Elastic Search not available.";
    private static final String FILE_FIELDS_NAME_WITH_WILDCARD = "*/FILE/Fields/Locator/Uri";

    protected SessionFactory getSessionFactory() {
        try {
            return HibernateContext.getContext().getSessionFactory();
        }
        catch (Exception e) {
            logger.error((Object)"Could not get SessionFactory", (Throwable)e);
            throw new IllegalStateException("Could not get SessionFactory");
        }
    }

    public String getServiceName() {
        return "Title Search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.isInited) {
            TitleSearchService titleSearchService = this;
            synchronized (titleSearchService) {
                SearchSchemaHelper searchSchemaHelper = new SearchSchemaHelper();
                ConditionBuilderFactory conditionBuilderFactory = new ConditionBuilderFactory();
                conditionBuilderFactory.setSearchSchemaHelper(searchSchemaHelper);
                QueryBuilderFactory queryBuilderFactory = new QueryBuilderFactory();
                queryBuilderFactory.setCondidtionBuilderFactory(conditionBuilderFactory);
                queryBuilderFactory.setSchemaHelper(searchSchemaHelper);
                queryBuilderFactory.setSessionFactory(this.getSessionFactory());
                queryBuilderFactory.init();
                this.getSearchQueryHelper().setConditionBuilderFactory(conditionBuilderFactory);
                this.getSearchQueryHelper().setAssetSearchQueryBuilder(queryBuilderFactory.getAssetSearchQueryBuilder());
                this.getQsQueryHelper().setAssetSearchQueryBuilder(queryBuilderFactory.getAssetSearchQueryBuilder());
                this.getQsQueryHelper().setConditionBuilderFactory(conditionBuilderFactory);
                this.isInited = true;
            }
        }
    }

    public void stop() {
    }

    public boolean checkExistenceIncludeAllcopies(ExpNode condition) {
        String queryStr = this.getSearchQueryHelper().getQuery(new TitleFilter(condition, null, new PagingInfo(0, 1)), true, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return !this.executeQuery(queryStr).isEmpty();
    }

    public List<Long> getTitleIdsIncludeAllcopies(ExpNode condition) {
        String queryStr = this.getSearchQueryHelper().getQuery(new TitleFilter(condition, null, null), true, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    @Transactional
    public List<Title> getTitleCopies(Long masterTitleId) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(masterTitleId));
        PredicateRightValue prv = new PredicateRightValue("originalId", "", FieldType.PMM_TITLE, values, LogicalOperator.EQUAL, "integer", Boolean.valueOf(false));
        final String queryStr = this.getSearchQueryHelper().getQuery(new TitleFilter((ExpNode)new ExpValue((Predicate)prv)), false, true, true, new ArrayList<Integer>(), SiteType.DISTRIBUTION_SITE, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        final ArrayList<Long> titleIds = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    titleIds.add(results.getLong(1));
                }
                statement.close();
            }
        };
        this.getSessionFactory().getCurrentSession().doWork(work);
        return this.getTitles(titleIds);
    }

    public List<Long> getTitleIds(ExpNode condition) {
        PagingInfo pagingInfo = new PagingInfo(0, 10000);
        return this.masterSearchHelper(condition, pagingInfo, null);
    }

    public List<Long> getMasterTitleIdsFromES(ExpNode condition) {
        List<Long> result;
        PagingInfo pagingInfo = new PagingInfo();
        int pageStart = 0;
        pagingInfo.setStartIndex(pageStart);
        pagingInfo.setMaxRecordCount(1000);
        List<Long> titleIds = result = this.masterSearchHelper(condition, pagingInfo, null);
        while (result != null && !result.isEmpty()) {
            logger.debug((Object)("PageStart: " + (pageStart += 1000)));
            pagingInfo.setStartIndex(pageStart);
            result = this.masterSearchHelper(condition, pagingInfo, null);
            if (result.isEmpty()) continue;
            titleIds.addAll(result);
        }
        return titleIds;
    }

    @Transactional
    public List<Title> getTitles(List<Long> titleIds) {
        if (titleIds == null || titleIds.isEmpty()) {
            return new ArrayList<Title>();
        }
        Criteria crit = this.getSessionFactory().getCurrentSession().createCriteria(Title.class);
        crit.add(Restrictions.in((String)"id", (Object[])titleIds.toArray()));
        crit.addOrder(Property.forName((String)"id").asc());
        return crit.list();
    }

    @Transactional
    public List<Title> search(ExpNode condition) {
        List<Long> titleIds = this.masterSearchHelper(condition, null, null);
        List<Title> titles = this.getTitles(titleIds);
        Title[] result = new Title[titleIds.size()];
        block0: for (Title t : titles) {
            Long id = t.getId();
            for (int i = 0; i < titleIds.size(); ++i) {
                if (!titleIds.get(i).equals(id)) continue;
                result[i] = t;
                continue block0;
            }
        }
        return Arrays.asList(result);
    }

    public TitleSearchResult getMasterTitleSearchResults(List<Long> titleIds, List<SearchColumn> searchColumns) {
        if (titleIds.isEmpty()) {
            return new TitleSearchResult();
        }
        ExpValue searchCriteria = this.getTitleIdsCriteria(titleIds);
        PagingInfo pagingInfo = new PagingInfo(0, 10000);
        TitleFilter filter = new TitleFilter((ExpNode)searchCriteria);
        filter.setPageInfo(pagingInfo);
        return this.getSearchResults(filter, null, searchColumns);
    }

    public TitleSearchResult getTitleSearchResults(List<Long> titleIds, List<SearchColumn> searchColumns, CriteriaMode criteriaMode) {
        if (titleIds.isEmpty()) {
            return new TitleSearchResult();
        }
        ExpValue searchCriteria = this.getTitleIdsCriteria(titleIds);
        PagingInfo pagingInfo = new PagingInfo(0, 10000);
        TitleFilter filter = new TitleFilter((ExpNode)searchCriteria);
        filter.setPageInfo(pagingInfo);
        filter.setCriteriaMode(criteriaMode);
        return this.getSearchResults(filter, null, searchColumns);
    }

    public TitleSearchResult getSearchResults(TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns) {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(filter.getPageInfo());
        bld.setSortingInfo(filter.getSortInfo());
        bld.setSearchColumns(searchColumns);
        bld.setCriteriaMode(filter.getCriteriaMode());
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        if (filter.getFilterSiteIds() != null && filter.getCriteriaMode().equals((Object)CriteriaMode.SITE) && !filter.getFilterSiteIds().isEmpty()) {
            ExpNode newNode = this.changeDistStatusToExcludeSiteTitle(filter.getRootNode());
            ExpList rootNode = new ExpList();
            rootNode.addItem(newNode);
            PredicateRightValue predicate = new PredicateRightValue();
            predicate.setFieldLeft("distributionSiteId");
            predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
            predicate.setDataType("integer");
            predicate.setOperator(LogicalOperator.IN);
            ArrayList<String> siteIdsList = new ArrayList<String>();
            Iterator iterator = filter.getFilterSiteIds().iterator();
            while (iterator.hasNext()) {
                int siteId = (Integer)iterator.next();
                siteIdsList.add(String.valueOf(siteId));
            }
            predicate.setValue(siteIdsList);
            rootNode.addItem((ExpNode)new ExpValue((Predicate)predicate));
            filter.setRootNode((ExpNode)rootNode);
        }
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.advancedSearch(filter.getRootNode(), params);
        }
        catch (RuntimeException ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private ExpNode changeDistStatusToExcludeSiteTitle(ExpNode rootNode) {
        List listNode;
        if (rootNode != null && rootNode instanceof ExpList && (listNode = ((ExpList)rootNode).getNodes()) != null && !listNode.isEmpty()) {
            for (ExpNode node : listNode) {
                if (node instanceof ExpValue && ((ExpValue)node).getPredicate().getFieldLeft().equals("distributionStatus")) {
                    ((ExpValue)node).getPredicate().setFieldLeft("siteDistributionStatus");
                }
                if (!(node instanceof ExpList)) continue;
                this.changeDistStatusToExcludeSiteTitle(node);
            }
        }
        return rootNode;
    }

    public long getTitleCount(TitleFilter filter, List<Long> partnerIds) {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setCriteriaMode(filter.getCriteriaMode());
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.getTitleCount(filter.getRootNode(), params);
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Get title count error", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Get title count error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private List<Long> masterSearchHelper(ExpNode condition, PagingInfo pagingInfo, SortingInfo sortInfo) {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(pagingInfo);
        bld.setSortingInfo(sortInfo);
        bld.setCriteriaMode(CriteriaMode.MASTER);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.advancedSearchIds(condition, params);
        }
        catch (RuntimeException ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public List<Long> getSiteTitleIds(ExpNode condition, Collection<Integer> siteIds, SiteType siteType) {
        String queryStr = this.getSearchQueryHelper().getQuery(new TitleFilter(condition), false, false, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    public List<Long> getSiteTitleIdsfromES(ExpNode condition, Collection<Integer> siteIds, SiteType siteType) {
        PagingInfo pagingInfo = new PagingInfo();
        int pageStart = 0;
        pagingInfo.setStartIndex(pageStart);
        pagingInfo.setMaxRecordCount(1000);
        SortingInfo sortInfo = null;
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(pagingInfo);
        bld.setSortingInfo(sortInfo);
        bld.setCriteriaMode(CriteriaMode.SITE);
        SearchParameters params = bld.build();
        ArrayList<String> siteIdsList = new ArrayList<String>();
        for (int siteId : siteIds) {
            siteIdsList.add(String.valueOf(siteId));
        }
        ExpList rootNode = new ExpList();
        if (condition != null) {
            rootNode.addItem(condition);
        }
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("distributionSiteId");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("integer");
        predicate.setOperator(LogicalOperator.IN);
        predicate.setValue(siteIdsList);
        rootNode.addItem((ExpNode)new ExpValue((Predicate)predicate));
        try {
            List<Long> list;
            IElasticSearchService service = this.getElasticSearchService();
            List<Long> titleIds = list = service.advancedSearchIds((ExpNode)rootNode, params);
            while (list != null && !list.isEmpty()) {
                logger.debug((Object)("PageStart: " + (pageStart += 1000)));
                pagingInfo.setStartIndex(pageStart);
                bld.setPagingInfo(pagingInfo);
                params = bld.build();
                list = service.advancedSearchIds((ExpNode)rootNode, params);
                if (list.isEmpty()) continue;
                titleIds.addAll(list);
            }
            return titleIds;
        }
        catch (RuntimeException ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public List<Title> getSiteTitle(ExpNode condition, Collection<Integer> siteIds, SiteType siteType) {
        return this.getTitles(this.getSiteTitleIds(condition, siteIds, siteType));
    }

    public List<Long> geAllTitlesIds(TitleFilter filter, Collection<Integer> siteIds, SiteType siteType) {
        String queryStr = this.getSearchQueryHelper().getQuery(filter, true, true, true, siteIds, siteType, false, new ArrayList<SearchColumn>(), new ArrayList<Long>(), false);
        return this.executeQuery(queryStr);
    }

    public TitleSearchResult getSiteTitleIds(TitleFilter filter, List<SearchColumn> searchColumns, Collection<Integer> siteIds, SiteType siteType, List<Long> partnerIds) {
        boolean getExtraRow = filter.getPageInfo() != null && filter.getPageInfo().getMaxRecordCount() < Integer.MAX_VALUE;
        String queryStr = this.getSearchQueryHelper().getQuery(filter, false, false, true, siteIds, siteType, true, searchColumns, partnerIds, getExtraRow);
        try {
            return this.executeQuery(queryStr, searchColumns, true, filter.getPageInfo(), new ArrayList<BindVariable>(0));
        }
        catch (InvalidSrchException e) {
            throw new RuntimeException(e);
        }
    }

    private IElasticSearchService getElasticSearchService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (IElasticSearchService)registry.lookup(IElasticSearchService.class);
    }

    public TitleSearchResult getTitlesQuickSearchWithAdditionalFilters(String searchText, TitleFilter filter, List<Long> partnerIds, List<SearchColumn> searchColumns) throws InvalidSrchException {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(filter.getPageInfo());
        bld.setSortingInfo(filter.getSortInfo());
        bld.setSearchColumns(searchColumns);
        bld.setCriteriaMode(filter.getCriteriaMode());
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.quickSearchWithAdditionalFilters(searchText, params, filter.getRootNode());
        }
        catch (NoNodeAvailableException ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException(ELASTICSEARCH_NOT_AVAILABLE);
        }
        catch (SearchPhaseExecutionException ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException("Invalid search criteria. Please consult the user guide for quick search syntax.");
        }
        catch (Exception ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException("Error occured while performing quick search. Please check logs for more details.");
        }
    }

    public TitleSearchResult getTitlesQuickSearch(String searchText, List<Long> partnerIds, PagingInfo pagingInfo, SortingInfo sortInfo, List<SearchColumn> searchColumns, CriteriaMode criteriaMode) throws InvalidSrchException {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(pagingInfo);
        bld.setSortingInfo(sortInfo);
        bld.setSearchColumns(searchColumns);
        bld.setCriteriaMode(criteriaMode);
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.quickSearch(searchText, params);
        }
        catch (NoNodeAvailableException ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException(ELASTICSEARCH_NOT_AVAILABLE);
        }
        catch (SearchPhaseExecutionException ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException("Invalid search criteria. Please consult the user guide for quick search syntax.");
        }
        catch (Exception ex) {
            logger.error((Object)QUICK_SEARCH_ERROR, (Throwable)ex);
            throw new InvalidSrchException("Error occured while performing quick search. Please check logs for more details.");
        }
    }

    protected TitleSearchResult getTitlesMultiFieldSearch(String searchText, List<String> searchFieldNames, PagingInfo pagingInfo, SortingInfo sortInfo, CriteriaMode criteriaMode) throws TitleSearchException {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(pagingInfo);
        bld.setSortingInfo(sortInfo);
        bld.setCriteriaMode(criteriaMode);
        bld.setSearchFiledNames(searchFieldNames);
        SearchParameters params = bld.build();
        IElasticSearchService service = this.getElasticSearchService();
        return service.multiFieldSearch(searchText, params);
    }

    private List<Long> executeQuery(final String queryStr) {
        final ArrayList<Long> ids = new ArrayList<Long>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet results = statement.executeQuery();
                while (results.next()) {
                    ids.add(results.getLong(1));
                }
                statement.close();
            }
        };
        this.doWork(work);
        return ids;
    }

    private TitleSearchResult executeQuery(final String queryStr, final List<SearchColumn> searchColumns, final boolean includeCount, final PagingInfo pagingInfo, final List<BindVariable> bindVariables) throws InvalidSrchException {
        final TitleSearchResult tsr = new TitleSearchResult();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                for (BindVariable bv : bindVariables) {
                    bv.setInStatement(statement);
                }
                ResultSet results = statement.executeQuery();
                boolean fetchedCount = false;
                int maxRecordCnt = Integer.MAX_VALUE;
                if (pagingInfo != null && pagingInfo.getMaxRecordCount() > 0) {
                    maxRecordCnt = pagingInfo.getMaxRecordCount();
                }
                int pageCount = 0;
                while (maxRecordCnt > pageCount && results.next()) {
                    ++pageCount;
                    ArrayList<String> fields = new ArrayList<String>(searchColumns.size());
                    Long id = results.getLong(1);
                    int offset = 2;
                    for (int i = 0; i < searchColumns.size(); ++i) {
                        SearchColumn sc = (SearchColumn)searchColumns.get(i);
                        if ("id".equals(sc.getFieldName())) {
                            fields.add(id.toString());
                            offset = 1;
                            continue;
                        }
                        if (results.getObject(i + offset) == null) {
                            fields.add("");
                            continue;
                        }
                        if (sc.getDataType().equals("date")) {
                            fields.add(TitleSearchService.this.processDateColumn(sc, i + offset, results));
                            continue;
                        }
                        fields.add(results.getString(i + offset));
                    }
                    if (includeCount && !fetchedCount) {
                        tsr.setCount((long)results.getInt("cnt"));
                        fetchedCount = true;
                    }
                    tsr.addRow(new TitleSearchResult.SearchRow(id.longValue(), fields));
                }
                if (results.next()) {
                    tsr.setHasMoreResults(true);
                }
            }
        };
        this.doWork(work);
        return tsr;
    }

    private void doWork(Work work) {
        try (Session session = this.getSessionFactory().openSession();){
            session.doWork(work);
        }
    }

    public List<FileSearchResult> findAssetWithFileName(String filePath, String providerId) {
        final ArrayList<FileSearchResult> searchResults = new ArrayList<FileSearchResult>();
        final String queryStr = TitleSearchWorkFactory.getFileSearchQuery(filePath, providerId);
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    Long titleId = resultSet.getLong(1);
                    Long assetId = resultSet.getLong(2);
                    searchResults.add(new FileSearchResult(titleId.longValue(), assetId.longValue()));
                }
                statement.close();
            }
        };
        this.doWork(work);
        return searchResults;
    }

    private ExpValue getTitleIdsCriteria(List<Long> titleIds) {
        ArrayList<String> titleIdsStr = new ArrayList<String>();
        for (Long id : titleIds) {
            titleIdsStr.add(String.valueOf(id));
        }
        PredicateRightValue condition = new PredicateRightValue("id", "", FieldType.PMM_TITLE, titleIdsStr, LogicalOperator.IN, "integer", Boolean.valueOf(false));
        return new ExpValue((Predicate)condition);
    }

    public List<String> findFieldMatchingCriteria(SearchColumn field, ExpNode criteria) {
        final String queryStr = this.getSearchQueryHelper().getQuery(criteria, field);
        final ArrayList<String> result = new ArrayList<String>();
        Work work = new Work(){

            public void execute(Connection conn) throws SQLException {
                PreparedStatement statement = conn.prepareStatement(queryStr);
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
                statement.close();
            }
        };
        this.doWork(work);
        return result;
    }

    public List<SeriesInfo> getSeriesInfos(ExpNode seasonConditions) {
        ArrayList<SeriesInfo> infos = new ArrayList<SeriesInfo>();
        SearchParameters params = new SearchParameters();
        params.setTitleIndexType(ElasticSearchIndexType.SEASON);
        params.setPageSize(1000);
        params.setFields(Arrays.asList(new SearchParameters.FieldInfo("seriesDocumentId", "string")));
        try {
            IElasticSearchService service = this.getElasticSearchService();
            TitleSearchResult result = service.advancedSearch(seasonConditions, params);
            for (TitleSearchResult.SearchRow row : result.getRows()) {
                SeriesInfo info = new SeriesInfo();
                info.seriesDocumentId = row.getFirstValueAsString(0);
                info.seasonAssetId = String.valueOf(row.getId());
                infos.add(info);
            }
            return infos;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Get seiries info error", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Get seiries info error", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    protected String processDateColumn(SearchColumn sc, int pos, ResultSet results) throws SQLException {
        if (sc.isMultiValue()) {
            String list = results.getString(pos);
            String[] dates = list.split(",");
            StringJoiner joiner = new StringJoiner(",");
            for (String date : dates) {
                try {
                    joiner.add(GlobalDateFormatUtil.changeDateTimeFormat((String)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSSSSS", (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (DateTimeException e) {
                    logger.error((Object)("fail to format the date " + date), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            return joiner.toString();
        }
        return GlobalDateFormatUtil.formatDateTime((Date)results.getTimestamp(pos));
    }

    public TitleSearchResult getTargetedTitlesQuickSearch(String searchText, List<Long> partnerIds, PagingInfo pagingInfo, SortingInfo sortInfo, List<SearchColumn> searchColumns, SiteType siteType, Integer siteId, Integer siteStatus) throws InvalidSrchException {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(pagingInfo);
        if ("statusUpdateTime".equalsIgnoreCase(sortInfo.getSortItemName())) {
            sortInfo.setSortItemName(ElasticSearchUtil.createSiteStatusUpdatedTimeKey(siteId));
        }
        if ("status".equalsIgnoreCase(sortInfo.getSortItemName())) {
            sortInfo.setSortItemName(ElasticSearchUtil.createSiteStatusKey(siteId));
        }
        bld.setSortingInfo(sortInfo);
        bld.setSearchColumns(searchColumns, siteId);
        bld.setCriteriaMode(CriteriaMode.SITE);
        bld.setSiteId(siteId);
        bld.setSiteStatus(siteType, siteStatus);
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.quickSearch(searchText, params);
        }
        catch (NoNodeAvailableException ex) {
            logger.error((Object)"Targeted Titles search error", (Throwable)ex);
            throw new InvalidSrchException(ELASTICSEARCH_NOT_AVAILABLE);
        }
        catch (SearchPhaseExecutionException ex) {
            logger.error((Object)"Targeted Title search error", (Throwable)ex);
            throw new InvalidSrchException("Invalid search criteria. Please consult the user guide for Targeted Title search syntax.");
        }
        catch (Exception ex) {
            logger.error((Object)"Site title Quick search error", (Throwable)ex);
            throw new InvalidSrchException("Error occured while performing Targeted Title search. Please check logs for more details.");
        }
    }

    public Map<Long, Long> getCountBySite(TitleFilter filter, List<Long> partnerIds) {
        SearchParametersBuilder bld = new SearchParametersBuilder();
        bld.setPagingInfo(filter.getPageInfo());
        bld.setSortingInfo(filter.getSortInfo());
        bld.setCriteriaMode(filter.getCriteriaMode());
        bld.setPartnerIds(partnerIds);
        SearchParameters params = bld.build();
        try {
            IElasticSearchService service = this.getElasticSearchService();
            return service.countSiteById(filter.getRootNode(), params);
        }
        catch (RuntimeException ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ADVANCED_SEARCH_ERROR, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean isSharedFilePathAllcopies(String filePath, Long titleId) {
        return this.isSharedFilePathAllcopies(filePath, titleId, null) || this.isSharedFilePathAllcopies(filePath, titleId, CriteriaMode.SITE);
    }

    public boolean isSharedFilePathAllcopies(String filePath, Long titleId, CriteriaMode criteriaMode) {
        if (criteriaMode == null) {
            return this.multiFieldSearchFileInIndex(filePath, titleId, CriteriaMode.MASTER) || this.multiFieldSearchFileInIndex(filePath, titleId, CriteriaMode.SERIES);
        }
        return this.multiFieldSearchFileInIndex(filePath, titleId, criteriaMode);
    }

    private boolean multiFieldSearchFileInIndex(String filePath, Long titleId, CriteriaMode criteriaMode) {
        TitleSearchResult tsr = null;
        try {
            tsr = this.getTitlesMultiFieldSearch(filePath, Arrays.asList(FILE_FIELDS_NAME_WITH_WILDCARD), new PagingInfo(0, 2), null, criteriaMode);
        }
        catch (Exception ex) {
            logger.error((Object)"Multiple Field search error:", (Throwable)ex);
        }
        long count = tsr.getCount();
        if (count > 1L) {
            return true;
        }
        if (count == 0L) {
            return false;
        }
        return count == 1L && (titleId == null || tsr.getRow(titleId.longValue()) == null);
    }

    private TitleSearchQueryHelper getSearchQueryHelper() {
        if (this.searchQueryHelper == null) {
            this.searchQueryHelper = new TitleSearchQueryHelper();
        }
        return this.searchQueryHelper;
    }

    private TitleQuickSearchQueryHelper getQsQueryHelper() {
        if (this.qsQueryHelper == null) {
            this.qsQueryHelper = new TitleQuickSearchQueryHelper();
        }
        return this.qsQueryHelper;
    }
}

