/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class DistributedCountHelper {
    private static final Logger logger = Logger.getLogger(DistributedCountHelper.class);
    private static final String BASE_SQL = " select count(1) from sites_distribution_history sdh  where exists ( select 1 from pmm_title pt, pmm_content_class pcc  where pt.id_ = sdh.titleid and pt.content_class_id = pcc.id  and pcc.content_class_type_id not in ({0})) ";

    public static DistributedCountHelper getInstance() {
        return SingletonHelper.instance;
    }

    private DistributedCountHelper() {
    }

    private String getDistributedCountSql() {
        StringBuilder contentClassTypeId = new StringBuilder();
        int separator = 32;
        for (ContentClass.Type type : LicenseFilter.CONTENT_CLASS_FILTER) {
            contentClassTypeId.append((char)separator).append(type.ordinal());
            separator = 44;
        }
        return MessageFormat.format(BASE_SQL, contentClassTypeId.toString());
    }

    @Transactional
    public long getTotalDistributedCount(Date startDate) {
        Object result = null;
        try {
            result = HibernateContext.getContext().getCurrentSession().createSQLQuery(this.getDistributedCountSql()).uniqueResult();
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception occurs in DistributedCountHelper#getTotalDistributedCount", (Throwable)e);
        }
        if (null == result) {
            return 0L;
        }
        return ((BigInteger)result).longValue();
    }

    @Transactional
    public void cleanup(Date endDate) {
        try {
            HibernateContext.getContext().getCurrentSession().createSQLQuery(" delete from sites_distribution_history where createdate < ? ").setDate(0, endDate).executeUpdate();
        }
        catch (HibernateException e) {
            logger.error((Object)"Exception occurs in DistributedCountHelper#cleanup.", (Throwable)e);
        }
    }

    private static class SingletonHelper {
        private static final DistributedCountHelper instance = new DistributedCountHelper();

        private SingletonHelper() {
        }
    }
}

