/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.usagemonitor;

import com.ericsson.cms.criteria.ExpList;
import com.ericsson.cms.criteria.ExpNode;
import com.ericsson.cms.criteria.ExpValue;
import com.ericsson.cms.criteria.FieldType;
import com.ericsson.cms.criteria.LogicalOperator;
import com.ericsson.cms.criteria.Predicate;
import com.ericsson.cms.criteria.PredicateRightValue;
import com.ericsson.cms.neptune.cluster.Cluster;
import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.search.ElasticSearchIndexType;
import com.ericsson.cms.search.IElasticSearchService;
import com.ericsson.cms.search.SearchParameters;
import com.ericsson.neptune.clustermgmt.service.ClusterConstant;
import com.tandbergtv.cms.titlefilter.TitleFilter;
import com.tandbergtv.content.contentclass.entities.ContentClass;
import com.tandbergtv.content.contentclass.service.ContentClassPersistenceException;
import com.tandbergtv.content.contentclass.service.IContentClassService;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.entities.TitleStatus;
import com.tandbergtv.watchpoint.pmm.title.license.LicenseFilter;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.DistributedCountHelper;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.ILicenseMonitor;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.IngestCountHelper;
import com.tandbergtv.watchpoint.pmm.title.usagemonitor.LicenseMonitor;
import com.tandbergtv.watchpoint.pmm.util.TitleDateUtil;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LicenseMonitorService
implements ILicenseMonitor {
    private static final String MASTER_TITLES = "master.titles";
    private static final String SITES_TITLES = "sites.titles";
    private static final String DIST_THRUPUT = "dist.thruput";
    private static final String INGEST_THRUPUT = "ingest.thruput";
    private static final String INFORMATIONAL = "cms.usagemonitor.informational";
    private static final String WARNING = "cms.usagemonitor.warning";
    private static final String CRITICAL = "cms.usagemonitor.critical";
    private static final String THRESHOLD_GOOD = "Good";
    private static final String THRESHOLD_INFORMATIONAL = "Informational";
    private static final String THRESHOLD_WARNING = "Warning";
    private static final String THRESHOLD_CRITICAL = "Critical";
    private static final String SERVICE_NAME = "License Monitor";
    private static final Logger logger = Logger.getLogger(LicenseMonitorService.class);
    private boolean becameMaster = false;
    private LicenseMonitor licenseMonitor = LicenseMonitor.getInstance();
    private long infoThreshold;
    private long warnThreshold;
    private long criticalThreshold;
    private Map<String, String> preferences;
    private IClusterService hzcs;

    public LicenseMonitorService() {
        IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        this.preferences = configurationService.getProperties("com.ericsson.cms.usagemonitor");
        this.hzcs = Cluster.getService((String)ClusterConstant.CLUSTER_CONFIG_PATH);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        try {
            this.activate();
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#activate().", (Throwable)e);
        }
    }

    public void stop() {
    }

    public void activate() {
        logger.info((Object)("LicenseMonitorService: activate: clusterIP:" + this.hzcs.getLocalMember().getAddress().getHost()));
        if (this.hzcs.isMaster() && !this.becameMaster) {
            this.becameMaster = true;
        }
        Scheduler scheduler = new Scheduler("LicenseMonitor", 1, 2);
        scheduler.start();
        int scheduleTimerForCount = this.parseScheduleTimer(this.preferences.get("cms.usagemonitor.refreshTime"));
        scheduler.schedule(() -> {
            try {
                this.recountTitles();
            }
            catch (Exception e) {
                logger.error((Object)"Exception occurs in LicenseMonitorService#recountTitles().", (Throwable)e);
            }
        }, 0L, (long)scheduleTimerForCount);
        int scheduleTimerForCleanup = 1000 * this.parseScheduleTimer(this.preferences.get("cms.usagemonitor.cleanupInterval"));
        scheduler.schedule(() -> DistributedCountHelper.getInstance().cleanup(TitleDateUtil.getCurrentMonthStart()), 0L, (long)scheduleTimerForCleanup);
    }

    private int parseScheduleTimer(String s) {
        if (null == s || "".equals(s)) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#parseInt() when parse string to int.", (Throwable)e);
            return 0;
        }
    }

    private long getMax(String key) {
        long val = 0L;
        ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);
        try {
            val = Long.parseLong(neptuneLicenseManager.getProperty(key));
        }
        catch (InvalidLicenseException | NumberFormatException e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#getMax() when parse string to long.", e);
        }
        return val;
    }

    private double getPercentage(long max, long current) {
        if (0L == max) {
            return 0.0;
        }
        return (double)(current * 100L) / (double)max;
    }

    private void recountTitles() throws Exception {
        long ingestPreviousThreshold;
        long distributedPreviousThreshold;
        long sitePreviousThreshold;
        String thresholdName;
        logger.debug((Object)"=======Time to recountTitles=======");
        long masterTitleCount = this.getMasterTitleCount();
        long siteTitleCount = this.getSiteTitleCount();
        long distributedTitleCount = this.getDistributedTitleCount();
        long ingestTitleCount = this.getIngestTitleCount();
        logger.debug((Object)("---->masterTitleCount:" + masterTitleCount));
        logger.debug((Object)("---->siteTitleCount:" + siteTitleCount));
        logger.debug((Object)("---->distributedTitleCount:" + distributedTitleCount));
        logger.debug((Object)("---->ingestTitleCount:" + ingestTitleCount));
        long maxMasterTitleCount = this.getMax(MASTER_TITLES);
        long maxSiteTitleCount = this.getMax(SITES_TITLES);
        long maxDistributedTitleCount = this.getMax(DIST_THRUPUT);
        long maxIngestTitleCount = this.getMax(INGEST_THRUPUT);
        double percentMasterTitleCount = this.getPercentage(maxMasterTitleCount, masterTitleCount);
        double percentSiteTitleCount = this.getPercentage(maxSiteTitleCount, siteTitleCount);
        double percentDistributedTitleCount = this.getPercentage(maxDistributedTitleCount, distributedTitleCount);
        double percentIngestTitleCount = this.getPercentage(maxIngestTitleCount, ingestTitleCount);
        this.setThresholds();
        long masterCurrentThreshold = this.getCurrentThreshold(percentMasterTitleCount);
        long siteCurrentThreshold = this.getCurrentThreshold(percentSiteTitleCount);
        long distributedCurrentThreshold = this.getCurrentThreshold(percentDistributedTitleCount);
        long ingestCurrentThreshold = this.getCurrentThreshold(percentIngestTitleCount);
        long masterPreviousThreshold = this.licenseMonitor.getThresholdMasterTitleCount();
        if (masterCurrentThreshold != masterPreviousThreshold) {
            this.licenseMonitor.setThresholdMasterTitleCount(masterCurrentThreshold);
            thresholdName = this.getThresholdName(masterCurrentThreshold);
            if (this.becameMaster) {
                logger.info((Object)("new master title threshold detected: " + thresholdName));
            }
        }
        if (siteCurrentThreshold != (sitePreviousThreshold = this.licenseMonitor.getThresholdSiteTitleCount())) {
            this.licenseMonitor.setThresholdSiteTitleCount(siteCurrentThreshold);
            thresholdName = this.getThresholdName(siteCurrentThreshold);
            if (this.becameMaster) {
                logger.info((Object)("new site title threshold detected: " + thresholdName));
            }
        }
        if (distributedCurrentThreshold != (distributedPreviousThreshold = this.licenseMonitor.getThresholdDistributionTitleCount())) {
            this.licenseMonitor.setThresholdDistributionTitleCount(distributedCurrentThreshold);
            thresholdName = this.getThresholdName(distributedCurrentThreshold);
            if (this.becameMaster) {
                logger.info((Object)("new distributed title threshold detected: " + thresholdName));
            }
        }
        if (ingestCurrentThreshold != (ingestPreviousThreshold = this.licenseMonitor.getThresholdIngestTitleCount())) {
            this.licenseMonitor.setThresholdIngestTitleCount(ingestCurrentThreshold);
            thresholdName = this.getThresholdName(ingestCurrentThreshold);
            if (this.becameMaster) {
                logger.info((Object)("new ingest title threshold detected: " + thresholdName));
            }
        }
        this.licenseMonitor.setMasterTitleCount(masterTitleCount);
        this.licenseMonitor.setSiteTitleCount(siteTitleCount);
        this.licenseMonitor.setDistributionTitleCount(distributedTitleCount);
        this.licenseMonitor.setIngestTitleCount(ingestTitleCount);
        this.licenseMonitor.setMaxMasterTitleCount(maxMasterTitleCount);
        this.licenseMonitor.setMaxSiteTitleCount(maxSiteTitleCount);
        this.licenseMonitor.setMaxDistributionTitleCount(maxDistributedTitleCount);
        this.licenseMonitor.setMaxIngestTitleCount(maxIngestTitleCount);
    }

    private String getThresholdName(long currentThreshold) {
        switch ((int)currentThreshold) {
            case 0: {
                return THRESHOLD_GOOD;
            }
            case 1: {
                return THRESHOLD_INFORMATIONAL;
            }
            case 2: {
                return THRESHOLD_WARNING;
            }
            case 3: {
                return THRESHOLD_CRITICAL;
            }
        }
        return null;
    }

    private long getCurrentThreshold(double percent) {
        int currentThreshold = percent < (double)this.infoThreshold ? 0 : (percent < (double)this.warnThreshold ? 1 : (percent < (double)this.criticalThreshold ? 2 : 3));
        return currentThreshold;
    }

    private long getThreshold(String key) {
        long val = 0L;
        try {
            val = Long.parseLong(this.preferences.get(key));
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurs in LicenseMonitorService#getThreshold() when parse string to long.", (Throwable)e);
        }
        return val;
    }

    private void setThresholds() {
        this.infoThreshold = this.getThreshold(INFORMATIONAL);
        this.warnThreshold = this.getThreshold(WARNING);
        this.criticalThreshold = this.getThreshold(CRITICAL);
    }

    private List<String> getContentClassFilterIds(ContentClass.Type ... filters) {
        if (null == filters) {
            return new ArrayList<String>();
        }
        ArrayList<String> contentClassFilterIds = new ArrayList<String>();
        List contentClasses = null;
        try {
            contentClasses = ((IContentClassService)ServiceRegistry.getDefault().lookup(IContentClassService.class)).getAllContentClassesWithoutMetadata();
        }
        catch (ContentClassPersistenceException e) {
            logger.error((Object)"Cannot get all content classes from DB.", (Throwable)e);
        }
        if (null == contentClasses) {
            return contentClassFilterIds;
        }
        for (ContentClass.Type filter : filters) {
            for (ContentClass cc : contentClasses) {
                if (filter != cc.getType()) continue;
                contentClassFilterIds.add(String.valueOf(cc.getId()));
            }
        }
        return contentClassFilterIds;
    }

    private ExpValue getTitleContentClassTypeCriteria() {
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("contentClassId");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("integer");
        predicate.setOperator(LogicalOperator.IN);
        predicate.setNot(Boolean.valueOf(true));
        predicate.setValue(this.getContentClassFilterIds(LicenseFilter.CONTENT_CLASS_FILTER));
        return new ExpValue((Predicate)predicate);
    }

    private PredicateRightValue buildTitleStatusPredicate(TitleStatus ... statuses) {
        PredicateRightValue predicate = new PredicateRightValue();
        predicate.setFieldLeft("status");
        predicate.setFieldTypeLhs(FieldType.PMM_TITLE);
        predicate.setDataType("string");
        predicate.setOperator(LogicalOperator.IN);
        if (null == statuses) {
            predicate.setValue(new ArrayList());
        } else {
            for (TitleStatus ts : statuses) {
                predicate.addValue(ts.name());
            }
        }
        return predicate;
    }

    private ExpValue getMasterTitleStatusCriteria() {
        return new ExpValue((Predicate)this.buildTitleStatusPredicate(TitleStatus.DRAFT, TitleStatus.COMMITTED, TitleStatus.READY, TitleStatus.APPROVED));
    }

    private ExpValue getSiteTitleStatusCriteria() {
        return new ExpValue((Predicate)this.buildTitleStatusPredicate(TitleStatus.DRAFT, TitleStatus.COMMITTED, TitleStatus.READY, TitleStatus.APPROVED));
    }

    private TitleFilter getMasterTitleFilter() {
        ExpList rootNode = new ExpList();
        rootNode.addItem((ExpNode)this.getMasterTitleStatusCriteria());
        rootNode.addItem((ExpNode)this.getTitleContentClassTypeCriteria());
        return new TitleFilter((ExpNode)rootNode);
    }

    private TitleFilter getSiteTitleFilter() {
        ExpList rootNode = new ExpList();
        rootNode.addItem((ExpNode)this.getSiteTitleStatusCriteria());
        rootNode.addItem((ExpNode)this.getTitleContentClassTypeCriteria());
        return new TitleFilter((ExpNode)rootNode);
    }

    private long getTitleCount(TitleFilter filter, ElasticSearchIndexType ... types) throws Exception {
        if (null == types) {
            return 0L;
        }
        long val = 0L;
        SearchParameters params = new SearchParameters();
        IElasticSearchService esService = (IElasticSearchService)ServiceRegistry.getDefault().lookup(IElasticSearchService.class);
        for (ElasticSearchIndexType type : types) {
            params.setTitleIndexType(type);
            val += esService.getTitleCount(filter.getRootNode(), params);
        }
        return val;
    }

    private long getMasterTitleCount() throws Exception {
        return this.getTitleCount(this.getMasterTitleFilter(), ElasticSearchIndexType.MASTER, ElasticSearchIndexType.SERIES);
    }

    private long getIngestTitleCount() {
        return IngestCountHelper.getInstance().getTotalIngestCount(TitleDateUtil.getCurrentMonthStart(), TitleDateUtil.getCurrentMonthEnd());
    }

    private long getSiteTitleCount() throws Exception {
        return this.getTitleCount(this.getSiteTitleFilter(), ElasticSearchIndexType.SITE);
    }

    private long getDistributedTitleCount() {
        return DistributedCountHelper.getInstance().getTotalDistributedCount(TitleDateUtil.getCurrentMonthStart());
    }
}

