/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.ContextHDAO;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Context;
import com.tandbergtv.watchpoint.pmm.util.IContextManager;
import org.apache.log4j.Logger;
import org.hibernate.Session;

public class ContextManager
implements IContextManager {
    private static IContextManager instance;
    private static final Logger logger;

    public static synchronized IContextManager getInstance() {
        if (instance == null) {
            instance = new ContextManager();
        }
        return instance;
    }

    @Transactional
    public Context getContext(long contextId) {
        Session session = null;
        Context context = new Context();
        try {
            session = HibernateContext.getContext().getCurrentSession();
            ContextHDAO contextDAO = new ContextHDAO(session);
            context = (Context)contextDAO.findByKey(Long.valueOf(contextId));
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting context(id: " + contextId + "): " + e.getMessage()));
        }
        return context;
    }

    static {
        logger = Logger.getLogger(ContextManager.class);
    }
}

