/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TableConfigHelper {
    private static final String PACKAGE_NAME = "com/tandbergtv/watchpoint/pmm/util/";
    private static final String TMP_TABLE_CONFIG_FILE = "pmm-table-config.xml";
    private static final String TABLE_CONFIG_FILE = "table-config.xml";
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PMM_CONFIG_DIR = "pmm";

    private static File getTempFile() {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + TMP_TABLE_CONFIG_FILE);
        return file;
    }

    public static File getTableConfigFile() {
        String dir = System.getProperty(PRODUCT_DIR) + File.separator + "conf";
        String filename = dir + File.separator + PMM_CONFIG_DIR + File.separator + TABLE_CONFIG_FILE;
        File file = new File(filename);
        if (file.exists()) {
            return file;
        }
        file = TableConfigHelper.getTempFile();
        if (file.exists()) {
            return file;
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = TableConfigHelper.class.getClassLoader().getResourceAsStream("com/tandbergtv/watchpoint/pmm/util/table-config.xml");
            fos = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    static {
        File file = TableConfigHelper.getTempFile();
        if (file.exists()) {
            file.delete();
        }
    }
}

