/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.email;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.util.email.EmailNotificationUtility;
import com.tandbergtv.watchpoint.pmm.util.email.EmailProperties;
import com.tandbergtv.watchpoint.pmm.util.email.MailServiceProperties;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.management.modelmbean.XMLParseException;
import org.apache.log4j.Logger;

public class EmailNotificationHandler {
    private static final Logger logger = Logger.getLogger(EmailNotificationHandler.class);
    private static ScheduledExecutorService service = null;
    private static final String MAIL_SMTP_HOST = "mail.smtp.host";
    private static final String MAIL_SMTP_PORT = "mail.smtp.port";

    public EmailNotificationHandler() {
        if (service == null) {
            service = Executors.newSingleThreadScheduledExecutor();
        }
    }

    public void sendNotificationEmail(List<String> recipients, Title title, String errorMsg) throws MessagingException, IOException, XMLParseException {
        Map<Object, Object> emailDetails = new HashMap();
        String emailSubject = null;
        String emailBody = null;
        emailDetails = this.getEmailSubjectBodyDetails(title, errorMsg);
        for (Map.Entry<Object, Object> email : emailDetails.entrySet()) {
            emailSubject = (String)email.getKey();
            emailBody = (String)email.getValue();
        }
        this.sendEmailAsync(recipients, emailSubject, emailBody);
    }

    private void sendEmailAsync(final List<String> recipients, final String emailSubject, final String emailBody) {
        Runnable sendEmailTask = new Runnable(){

            @Override
            public void run() {
                try {
                    EmailNotificationHandler.this.sendEmail(recipients, emailSubject, emailBody);
                }
                catch (MessagingException e) {
                    logger.error((Object)("Failed to Send email to " + recipients + ", subject: " + emailSubject + ", body: " + emailBody));
                }
            }
        };
        service.schedule(sendEmailTask, 0L, TimeUnit.SECONDS);
    }

    private Map<String, String> getEmailSubjectBodyDetails(Title title, String errorMsg) throws IOException, XMLParseException {
        EmailNotificationUtility enu = new EmailNotificationUtility();
        Map<Object, Object> aliasValuePairs = new HashMap();
        aliasValuePairs = enu.getAliasValueDetailsFromXml(title, errorMsg);
        String subject = null;
        String body = null;
        try {
            if (errorMsg == null || errorMsg.isEmpty()) {
                errorMsg = "";
                subject = EmailProperties.getSuccessfulIngestEmailSubject();
                body = EmailProperties.getSuccessfulIngestEmailBody();
            } else {
                subject = EmailProperties.getValidationFailureEmailSubject();
                body = EmailProperties.getValidationFailureEmailBody();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot read Email properties from Neptune Settings");
            throw new IOException();
        }
        for (Map.Entry<Object, Object> aliasValue : aliasValuePairs.entrySet()) {
            if (subject.contains((CharSequence)aliasValue.getKey())) {
                subject = subject.replace((CharSequence)aliasValue.getKey(), (CharSequence)aliasValue.getValue());
            }
            if (!body.contains((CharSequence)aliasValue.getKey())) continue;
            body = body.replace((CharSequence)aliasValue.getKey(), (CharSequence)aliasValue.getValue());
        }
        HashMap<String, String> subjectBodyPair = new HashMap<String, String>();
        subjectBodyPair.put(subject, body);
        return subjectBodyPair;
    }

    private void sendEmail(List<String> recipients, String subject, String body) throws MessagingException {
        if (recipients == null || recipients.isEmpty()) {
            return;
        }
        try {
            Properties properties = System.getProperties();
            MailServiceProperties p = new MailServiceProperties();
            properties.setProperty(MAIL_SMTP_HOST, p.getSmtpHostAddressValue());
            properties.setProperty(MAIL_SMTP_PORT, p.getSmtpPortValue());
            Session session = Session.getDefaultInstance((Properties)properties);
            String fromAddress = p.getFromAddress();
            if (fromAddress == null || fromAddress.isEmpty()) {
                fromAddress = "";
                logger.warn((Object)"Sender address is not configured in Neptune settings");
            }
            InternetAddress from = new InternetAddress(fromAddress, p.getFromAddressName());
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            for (String recipient : recipients) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            }
            if (subject != null) {
                message.setSubject(subject);
            }
            MimeMultipart multipart = new MimeMultipart();
            if (body != null) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setText(body);
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
            message.setSentDate(new Date());
            Transport.send((Message)message);
            logger.info((Object)("Sent email notification to " + recipients));
            logger.debug((Object)("Sent email to " + recipients + ", subject: " + subject + ", body: " + body));
        }
        catch (Exception e) {
            String errorMsg = "Email to " + recipients + " failed." + e;
            logger.error((Object)errorMsg);
            throw new MessagingException(errorMsg);
        }
    }
}

