/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.tandbergtv.workflow.adaptor.conf.DispatcherParameter;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.AbstractDispatcher;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MessageBuilder;
import com.tandbergtv.workflow.comm.HTTPDevice;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageAttachment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;

public class SOAPDispatcher
extends AbstractDispatcher {
    private static final Logger LOGGER = Logger.getLogger(SOAPDispatcher.class);

    public SOAPDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    @Override
    public IMessage send(IMessage msg) throws DispatcherException {
        IMessage responseMessage = null;
        int count = 0;
        int retryInterval = Integer.valueOf(this.getConfiguration().getParameterValue(DispatcherParameter.ADAPTOR_RETRY_INTERVAL));
        int retryCount = Integer.valueOf(this.getConfiguration().getParameterValue(DispatcherParameter.ADAPTOR_RETRY_MAX));
        IOException exception = null;
        do {
            try {
                SOAPMessage message = MessageFactory.newInstance().createMessage();
                if (msg.getAttachment() != null) {
                    this.buildAttachment(message, msg.getAttachment());
                }
                MimeHeaders headers = message.getMimeHeaders();
                String soapAction = this.getConfiguration().getParameterValue(DispatcherParameter.SOAP_ACTION);
                soapAction = soapAction == null ? "" : soapAction;
                headers.addHeader("SOAPAction", soapAction);
                SOAPPart soapPart = message.getSOAPPart();
                String msgContent = msg.getPayload().getContent();
                soapPart.setContent((Source)new StreamSource(new StringReader(msgContent)));
                SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
                String url = ((HTTPDevice)this.getDestination()).getUrl();
                LOGGER.debug((Object)("Making SOAP call to " + url));
                SOAPMessage reply = connection.call(message, (Object)url);
                SOAPBody body = reply.getSOAPBody();
                if (body.getFault() != null) {
                    SOAPFault fault = body.getFault();
                    LOGGER.warn((Object)fault.getFaultString());
                }
                responseMessage = new MessageBuilder().toIMessage(reply.getSOAPPart());
                LOGGER.debug((Object)("responsemessage: " + responseMessage));
                connection.close();
                return responseMessage;
            }
            catch (SOAPException ex) {
                if (ex.getCause() != null && ex.getCause().getCause() instanceof IOException) {
                    if (++count > retryCount) {
                        exception = (IOException)ex.getCause().getCause();
                        break;
                    }
                    try {
                        LOGGER.warn((Object)("Request to URL " + this.getDestination() + " failed, retrying attempt " + count + " of " + retryCount));
                        Thread.sleep(retryInterval * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new DispatcherException(ex);
                    }
                }
                throw new DispatcherException(ex);
            }
            catch (Exception ex) {
                throw new DispatcherException(ex);
            }
        } while (count <= retryCount);
        throw new DispatcherException(exception);
    }

    private void buildAttachment(SOAPMessage message, IMessageAttachment messageAttachment) {
        AttachmentPart attachment = message.createAttachmentPart();
        Object content = messageAttachment.getContent();
        String contentType = messageAttachment.getContentType();
        if (content instanceof byte[]) {
            ByteArrayDataSource source = new ByteArrayDataSource(null, contentType, (byte[])content);
            attachment.setDataHandler(new DataHandler((DataSource)source));
        } else {
            attachment.setContent(content, contentType);
        }
        message.addAttachmentPart(attachment);
    }

    private class ByteArrayDataSource
    implements DataSource {
        String contentName;
        String contentType;
        byte[] content;

        ByteArrayDataSource(String name, String contentType, byte[] content) {
            this.contentName = name;
            this.contentType = contentType;
            this.content = content;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.contentName;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.content);
        }

        public OutputStream getOutputStream() {
            throw new RuntimeException("No Output Stream available for this datasource.");
        }
    }
}

