/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.XMLTemplateHandler;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SOAPHandler
extends XMLTemplateHandler {
    private static final Logger LOGGER = Logger.getLogger(SOAPHandler.class);
    private static final String SOAP_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>";
    private static final String SOAP_FOOTER = "</soapenv:Body></soapenv:Envelope>";

    public SOAPHandler() {
    }

    public SOAPHandler(IHandlerConfiguration conf) throws HandlerException {
        super(conf);
    }

    @Override
    public IMessage process(IMessage message) throws HandlerException {
        LOGGER.debug((Object)("Processing message: " + message));
        HTTPMessage xmlMessage = (HTTPMessage)super.process(message);
        HTTPPayload payload = (HTTPPayload)xmlMessage.getPayload();
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append(SOAP_HEADER);
        stringBuilder.append(payload.getContent());
        stringBuilder.append(SOAP_FOOTER);
        payload.setContent(stringBuilder.toString());
        LOGGER.debug((Object)("Output: " + xmlMessage));
        return xmlMessage;
    }

    @Override
    protected Document getDOMDocumentFromFilePath(String fileName) throws HandlerException {
        Document doc = null;
        try {
            ClassLoader classloader = this.getConfiguration().getClassLoader();
            String filePath = this.getConfigPath() + fileName;
            doc = XMLDocumentUtility.loadFile((ClassLoader)classloader, (String)filePath, (boolean)false, (boolean)true);
        }
        catch (IOException ex) {
            throw new HandlerException("Could not read from template file.", ex);
        }
        catch (Exception ex) {
            throw new HandlerException("Could not parse DOM document.", ex);
        }
        return doc;
    }
}

