/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IXPathPairParameter;
import com.tandbergtv.workflow.adaptor.handler.XPathPairLoader;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.util.XMLDocumentUtility;
import java.io.IOException;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTemplateHandler
extends AbstractHandler {
    private static final String XPATH_TAG = "xPath";
    private static final String XPATH_VALUE_TAG = "value";
    private static final String MAPPING_FILE_PATH_TAG = "MappingFilepath";
    private static final String TEMPLATE_FILE_PATH_TAG = "TemplateFilepath";
    private static final String ROUTE_TAG = "Route";
    private static final String DEFAULT_ROUTE_TAG = "DefaultRoute";
    private static final String RULE_TAG = "Rule";
    private static final String REQ_TEMPLATE_FILE_PATH_PARAM = "TemplateFilePath";
    private static final String RESP_TYPE_CONFIG_PATH_PARAM = "ResponseRouterPath";
    private static final String REQ_MAPPING_PATH_PARAM = "RequestMappingPath";
    private static final ThreadLocal<XPath> XPATH = new ThreadLocal<XPath>(){

        @Override
        protected XPath initialValue() {
            return XPathFactory.newInstance().newXPath();
        }
    };
    private static final Logger LOGGER = Logger.getLogger(XMLTemplateHandler.class);

    public XMLTemplateHandler() {
    }

    public XMLTemplateHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    @Override
    public IMessage process(IMessage message) throws HandlerException {
        LOGGER.debug((Object)("Input: " + message));
        IMessage ret = this.prepareXMLFromTemplate(message);
        LOGGER.debug((Object)("Output: " + ret));
        return ret;
    }

    @Override
    public IMessage postProcess(IMessage message) throws HandlerException {
        LOGGER.debug((Object)("Post Processing Message: " + message));
        String[] responseConfig = this.getResponseConfigPath(message);
        if (responseConfig == null) {
            String errMsg = "Failed to get the Output Mapping and Template File Paths for message: " + message;
            throw new HandlerException(errMsg);
        }
        String mappingFilePath = this.trimFilepath(responseConfig[0]);
        String templatePath = this.trimFilepath(responseConfig[1]);
        String inputContent = message.getPayload().getContent();
        String outputContent = this.generateOutputXML(inputContent, mappingFilePath, templatePath);
        HTTPMessage result = this.constructMessage(outputContent, message);
        LOGGER.debug((Object)("Post Processed Message: " + result));
        return result;
    }

    protected IMessage prepareXMLFromTemplate(IMessage message) throws HandlerException {
        String mapping = this.getConfiguration().getParameterValue(REQ_MAPPING_PATH_PARAM);
        String template = this.getConfiguration().getParameterValue(REQ_TEMPLATE_FILE_PATH_PARAM);
        String inputContent = message.getPayload().getContent();
        String outputContent = this.generateOutputXML(inputContent, mapping, template);
        return this.constructMessage(outputContent, message);
    }

    protected HTTPMessage constructMessage(String content, IMessage originalMessage) {
        HTTPPayload payload = new HTTPPayload(content);
        HTTPAttachment attachment = null;
        if (originalMessage.getAttachment() != null) {
            Object attachContent = originalMessage.getAttachment().getContent();
            String attachType = originalMessage.getAttachment().getContentType();
            attachment = new HTTPAttachment(attachContent, attachType);
        }
        return new HTTPMessage(payload, attachment);
    }

    private String trimFilepath(String filePath) {
        filePath = filePath.replaceAll("\n", "");
        return filePath.replaceAll("\t", "");
    }

    protected String generateOutputXML(String content, String mappingFilePath, String templatePath) throws HandlerException {
        XPathPairLoader loader = new XPathPairLoader(this.getConfiguration());
        List<IXPathPairParameter> parameters = loader.loadXPathPairs(mappingFilePath);
        Document destination = this.getDOMDocumentFromFilePath(templatePath);
        Document source = this.getDOMDocumentFromString(content);
        XPath xPath = XPATH.get();
        xPath.reset();
        try {
            for (IXPathPairParameter param : parameters) {
                this.transform(source, destination, param, xPath);
            }
        }
        catch (Exception e) {
            throw new HandlerException("Failed to transform document", e);
        }
        return this.getXMLFromDocument(destination);
    }

    private void transform(Node source, Node destination, IXPathPairParameter pair, XPath xPath) throws HandlerException {
        String value = this.getNodeValue(pair.getSourceXPath(), xPath, source);
        this.setNodeValue(pair.getDestinationXPath(), value, xPath, destination);
    }

    private boolean setNodeValue(String expression, String value, XPath xPath, Node n) throws HandlerException {
        try {
            Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
            if (node == null) {
                throw new HandlerException("Destination XPath <" + expression + "> does not exist.");
            }
            if (value != null && value.length() > 0) {
                node.setTextContent(value);
            }
        }
        catch (XPathExpressionException ex) {
            throw new HandlerException("Could not evaluate xpath expression.", ex);
        }
        return true;
    }

    protected String getNodeValue(String expression, XPath xPath, Node n) throws HandlerException {
        String value = null;
        try {
            if (expression.substring(0, 1).equals("$")) {
                return expression.substring(1);
            }
            Node node = (Node)xPath.evaluate(expression, n, XPathConstants.NODE);
            if (node != null) {
                value = node.getTextContent();
            }
        }
        catch (XPathExpressionException ex) {
            throw new HandlerException("Could not evaluate xpath expression.", ex);
        }
        return value;
    }

    private NodeList getNodeSet(String expression, XPath xPath, Document doc) throws HandlerException {
        NodeList nodeSet = null;
        try {
            nodeSet = (NodeList)xPath.evaluate(expression, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new HandlerException("Could not evaluate xpath expression.", ex);
        }
        return nodeSet;
    }

    protected String getXMLFromDocument(Document doc) throws HandlerException {
        try {
            return XMLDocumentUtility.convertToString((Node)doc, (boolean)true);
        }
        catch (Exception ex) {
            throw new HandlerException("Could not transform DOM document.", ex);
        }
    }

    protected Document getDOMDocumentFromString(String xmlString) throws HandlerException {
        try {
            return XMLDocumentUtility.loadXml((String)xmlString);
        }
        catch (Exception ex) {
            throw new HandlerException("Could not parse DOM document", ex);
        }
    }

    protected Document getDOMDocumentFromFilePath(String fileName) throws HandlerException {
        Document doc = null;
        try {
            ClassLoader classloader = this.getConfiguration().getClassLoader();
            String filePath = this.getConfigPath() + fileName;
            doc = XMLDocumentUtility.loadFile((ClassLoader)classloader, (String)filePath);
        }
        catch (IOException ex) {
            throw new HandlerException("Could not read from template file.", ex);
        }
        catch (Exception ex) {
            throw new HandlerException("Could not parse DOM document.", ex);
        }
        return doc;
    }

    private String[] getResponseConfigPath(IMessage message) throws HandlerException {
        String[] result = null;
        XPath xPath = XPATH.get();
        xPath.reset();
        Document messageDoc = this.getDOMDocumentFromString(message.getPayload().getContent());
        String path = this.getConfiguration().getParameterValue(RESP_TYPE_CONFIG_PATH_PARAM);
        Document responseTypeDoc = this.getDOMDocumentFromFilePath(path);
        NodeList nodeSet = this.getNodeSet("//Route", xPath, responseTypeDoc);
        for (int i = 0; i < nodeSet.getLength(); ++i) {
            String routeXPath = "//Route[" + (i + 1) + "]//";
            NodeList ruleSet = this.getNodeSet(routeXPath + RULE_TAG, xPath, responseTypeDoc);
            if (!this.evaluateRules(ruleSet, messageDoc, xPath)) continue;
            String templatePath = this.getNodeValue(routeXPath + TEMPLATE_FILE_PATH_TAG, xPath, responseTypeDoc);
            String mappingPath = this.getNodeValue(routeXPath + MAPPING_FILE_PATH_TAG, xPath, responseTypeDoc);
            return new String[]{mappingPath, templatePath};
        }
        if (!this.getNodeValue("//DefaultRoute", xPath, responseTypeDoc).equals("")) {
            String routeXPath = "//DefaultRoute//";
            String templatePath = this.getNodeValue(routeXPath + TEMPLATE_FILE_PATH_TAG, xPath, responseTypeDoc);
            String mappingPath = this.getNodeValue(routeXPath + MAPPING_FILE_PATH_TAG, xPath, responseTypeDoc);
            return new String[]{mappingPath, templatePath};
        }
        return result;
    }

    private boolean evaluateRules(NodeList ruleSet, Document doc, XPath xPath) throws HandlerException {
        for (int i = 0; i < ruleSet.getLength(); ++i) {
            if (this.evaluateRule(ruleSet.item(i), doc, xPath)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateRule(Node currRule, Document doc, XPath xPath) throws HandlerException {
        NamedNodeMap nodeMap = currRule.getAttributes();
        String xPathExpr = ((Attr)nodeMap.getNamedItem(XPATH_TAG)).getTextContent();
        String value = ((Attr)nodeMap.getNamedItem(XPATH_VALUE_TAG)).getTextContent();
        if (value == null) {
            throw new HandlerException("The Rule value is invalid for expression: " + xPathExpr);
        }
        if (value.length() > 2) {
            if (value.substring(0, 2).equals("||")) {
                return this.checkAnyNodeMatch(this.getNodeSet(xPathExpr, xPath, doc), value.substring(2));
            }
            if (value.substring(0, 2).equals("##")) {
                return this.checkAllNodeMatch(this.getNodeSet(xPathExpr, xPath, doc), value.substring(2));
            }
        }
        if (value.startsWith("%") && value.endsWith("%")) {
            String innerValue = value.substring(1, value.length() - 1);
            return this.checkAnyNodeSubstringMatch(this.getNodeSet(xPathExpr, xPath, doc), innerValue);
        }
        if (value.equals("!null")) {
            return this.getNodeValue(xPathExpr, xPath, doc) != null;
        }
        if (value.equals("null")) {
            return this.getNodeSet(xPathExpr, xPath, doc).getLength() == 0;
        }
        if (value.length() > 0 && value.substring(0, 1).equals("$")) {
            String innerValue = value.substring(1);
            return innerValue.equals(this.getNodeValue(xPathExpr, xPath, doc));
        }
        throw new HandlerException("Rule could not be evaluated. Expression: " + xPathExpr + " value: " + value);
    }

    private boolean checkAnyNodeSubstringMatch(NodeList nodeList, String val) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getTextContent().indexOf(val) == -1) continue;
            return true;
        }
        return false;
    }

    private boolean checkAnyNodeMatch(NodeList nodeList, String val) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getTextContent().equals(val)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAllNodeMatch(NodeList nodeList, String val) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getTextContent().equals(val)) continue;
            return false;
        }
        return true;
    }
}

