/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message;

import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.message.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.graph.exe.Token;

public class WorkflowMessageBuilder {
    public static final String WORKFLOW_ACTIONS_UID = "010150";
    public static final String CREATE_COMMAND = "create";
    public static final String RETRY_COMMAND = "retry";
    public static final String RESUME_COMMAND = "resume";
    public static final String RESTART_COMMAND = "restart";
    public static final String RECOVER_COMMAND = "recover";
    public static final String SUB_PROCESS_TOKENS = "subProcessTokens";
    public static List<String> SUPPORT_COMMANDS = new ArrayList<String>();
    WorkflowMessage wfsMessage;

    public WorkflowMessageBuilder createMessage(String uid) {
        this.wfsMessage = WorkflowMessageFactory.createControlMessage(uid);
        return this;
    }

    public WorkflowMessageBuilder createMessage() {
        this.wfsMessage = WorkflowMessageFactory.createControlMessage(WORKFLOW_ACTIONS_UID);
        return this;
    }

    public WorkflowMessageBuilder createCommand() {
        return this.addCommand(CREATE_COMMAND);
    }

    public WorkflowMessageBuilder retryCommand() {
        return this.addCommand(RETRY_COMMAND);
    }

    public WorkflowMessageBuilder resumeCommand() {
        return this.addCommand(RESUME_COMMAND);
    }

    public WorkflowMessageBuilder restartCommand() {
        return this.addCommand(RESTART_COMMAND);
    }

    public WorkflowMessageBuilder recoverCommand() {
        return this.addCommand(RECOVER_COMMAND);
    }

    private WorkflowMessageBuilder addCommand(String cmdName) {
        WPCLCommand command = new WPCLCommand(cmdName);
        this.wfsMessage.setCommand(command);
        return this;
    }

    public WorkflowMessageBuilder token(Token token) {
        this.wfsMessage.setKey(new MessageKeyImpl(token.getId()));
        return this;
    }

    public WorkflowMessageBuilder token(long tokenId) {
        this.wfsMessage.setKey(new MessageKeyImpl(tokenId));
        return this;
    }

    public WorkflowMessageBuilder templateName(String name) {
        this.wfsMessage.getCommand().addParameter("_template", name);
        return this;
    }

    public WorkflowMessageBuilder priority(String priority) {
        this.wfsMessage.getCommand().addParameter("priority", priority);
        return this;
    }

    public WorkflowMessageBuilder variables(Map<String, Object> variables) {
        WorkflowPayload payload = this.wfsMessage.getPayload();
        for (String name : variables.keySet()) {
            String value = variables.get(name).toString();
            payload.putValue(name, value);
        }
        return this;
    }

    public WorkflowMessage build() {
        return this.wfsMessage;
    }

    public WorkflowMessageBuilder createId(String createId) {
        if (StringUtils.isNotBlank(createId)) {
            this.wfsMessage.setCreateId(createId);
        }
        return this;
    }

    public WorkflowMessageBuilder subTokens(String tokens) {
        if (StringUtils.isNotBlank(tokens)) {
            this.wfsMessage.getCommand().addParameter(SUB_PROCESS_TOKENS, tokens);
        }
        return this;
    }

    static {
        SUPPORT_COMMANDS.add(RETRY_COMMAND);
        SUPPORT_COMMANDS.add(RESUME_COMMAND);
        SUPPORT_COMMANDS.add(RESTART_COMMAND);
        SUPPORT_COMMANDS.add(RECOVER_COMMAND);
        SUPPORT_COMMANDS.add(CREATE_COMMAND);
    }
}

