/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.command;

import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.command.ICommand;

public abstract class AbstractCommand
implements ICommand {
    private static final long serialVersionUID = 6907541723879377648L;
    protected WorkflowMessage message;
    protected boolean throttle;

    protected AbstractCommand() {
    }

    protected AbstractCommand(WorkflowMessage message) {
        this.message = message;
    }

    @Override
    public WorkflowMessage getMessage() {
        return this.message;
    }

    public boolean isThrottle() {
        return this.throttle;
    }

    public void setThrottle(boolean throttle) {
        this.throttle = throttle;
    }

    protected WorkflowMessage createErrorResponse(String errorMessage) {
        WorkflowMessage response = WorkflowMessageFactory.createNackMessage(this.message);
        response.setErrorMessage(errorMessage);
        response.setCommand(this.message.getCommand());
        return response;
    }

    protected WorkflowMessage createSuccessResponse() {
        WorkflowMessage response = WorkflowMessageFactory.createAckMessage(this.message);
        response.setCommand(this.message.getCommand());
        return response;
    }
}

