/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.ratelimiter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.process.ratelimiter.NumberUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ThresholdSetting {
    private static final int MAX_THRADS = 1024;
    public static final int DEFAULT_ACTIVE_WO_THRESHOLD = 256;
    public static final int DEFAULT_ACTIVE_WO_RATIO_THRESHOLD = 70;
    public static final int DEFAULT_CPU_LOAD_THRESHOLD = 95;
    private Map<String, Object> thresHolds = Maps.newConcurrentMap();
    private static Map<String, Object> defaultThresHolds = Maps.newConcurrentMap();
    private static final Logger LOGGER = Logger.getLogger(ThresholdSetting.class);

    public static void registerThreshold(String key, Object defaultValue) {
        defaultThresHolds.put(key, defaultValue);
    }

    public static Map<String, Object> build(Map<String, String> setting) {
        HashMap<String, Object> thresholds = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaultThresHolds.entrySet()) {
            String newValue = setting.get(entry.getKey());
            if (entry.getValue() instanceof Double) {
                Double value = Configuration.toDouble((String)newValue, (Double)((Double)entry.getValue()));
                thresholds.put(entry.getKey(), value);
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                int value = Configuration.toInteger((String)newValue, (int)((Integer)entry.getValue()));
                thresholds.put(entry.getKey(), value);
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            thresholds.put(entry.getKey(), newValue);
        }
        Object componets = thresholds.get("ratelimiter.byPass.components");
        thresholds.put("ratelimiter.byPass.components", ThresholdSetting.loadByPassComponents(componets));
        if (thresholds.isEmpty()) {
            LOGGER.warn((Object)("Cannot find valid threshold setting fro RateLimiter: " + Watch.toString(setting)));
        }
        return thresholds;
    }

    public void setThresholds(Map<String, Object> thresHolds) {
        this.thresHolds = thresHolds;
    }

    public Integer getCpuLoadThreshold() {
        Integer cpuLoad = Configuration.toInteger((Object)this.thresHolds.get("rateLimiter.cpuload.threshold"), (int)-1);
        return ThresholdSetting.isValidCPUThreasHold(cpuLoad) ? cpuLoad : 100;
    }

    public Integer getConcurrencyThreshold() {
        Integer concurrency = Configuration.toInteger((Object)this.thresHolds.get("ratelimiter.WOConcurrency.threshold"), (int)-1);
        return ThresholdSetting.isValidConcurrentWO(concurrency) ? concurrency : 256;
    }

    public Integer getConcurrencyRatioThreshold() {
        Object value = this.thresHolds.get("ratelimiter.WOConcurrency.ratio.threshold");
        Integer ratio = Configuration.toInteger((Object)value, (int)-1);
        return ThresholdSetting.isValidConcurrencyRatioWO(ratio) ? ratio : 100;
    }

    public List<ComponentType> getByPassComponents() {
        Object value = this.thresHolds.get("ratelimiter.byPass.components");
        return value == null ? ThresholdSetting.loadByPassComponents(defaultThresHolds.get("ratelimiter.byPass.components")) : (List<ComponentType>)value;
    }

    private static List<ComponentType> loadByPassComponents(Object value) {
        ArrayList componentTypes = Lists.newArrayList();
        if (value != null) {
            String[] names;
            for (String name : names = StringUtils.split((String)((String)value), (String)",")) {
                ComponentType type = ComponentType.toType((String)name);
                if (type == null) continue;
                componentTypes.add(type);
            }
        }
        return componentTypes;
    }

    public Map<String, Object> getProps() {
        return this.thresHolds;
    }

    public static boolean isValidCPUThreasHold(int cpuLoadThreshold) {
        return cpuLoadThreshold >= 10 && cpuLoadThreshold <= 100;
    }

    public static boolean isValidConcurrentWO(int activeWOThreshold) {
        return activeWOThreshold >= 32 && activeWOThreshold <= 4096;
    }

    public static boolean isValidConcurrencyRatioWO(int ratio) {
        return ratio >= 20 && ratio <= 200;
    }

    public int calculateThreadPoolSize() {
        int allowToActiveWOCount = this.getAllowActiveWorkOrderCount();
        int threadPoolMaxSize = allowToActiveWOCount > 1024 ? 1024 : allowToActiveWOCount;
        threadPoolMaxSize = NumberUtils.getPercentage(threadPoolMaxSize, 150);
        return threadPoolMaxSize;
    }

    public int getAllowActiveWorkOrderCount() {
        int activeWOThreshold = this.getConcurrencyThreshold();
        int activeWORatio = this.getConcurrencyRatioThreshold();
        return NumberUtils.getPercentage(activeWOThreshold, activeWORatio);
    }

    static {
        defaultThresHolds.put("rateLimiter.cpuload.threshold", 95);
        defaultThresHolds.put("ratelimiter.WOConcurrency.threshold", 256);
        defaultThresHolds.put("ratelimiter.WOConcurrency.ratio.threshold", 70);
        defaultThresHolds.put("ratelimiter.byPass.components", ComponentType.RESOURCE_01VF14.toString());
    }
}

