/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessConvertor;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import com.tandbergtv.workflow.message.producer.MessagePublishException;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public final class CrashRecovery
implements Callable<Void> {
    private static final Logger LOGGER = Logger.getLogger(CrashRecovery.class);
    private static final long RECOVER_DELAY = 10000L;

    @Override
    public Void call() throws Exception {
        List<WorkflowProcess> processes = this.search();
        LOGGER.info((Object)("Performing crash recovery for " + processes.size() + " process(es)"));
        if (this.isHalted()) {
            this.suspend(processes);
            return null;
        }
        this.doRecover(processes);
        this.addFailedProcessIntoCache();
        return null;
    }

    private void suspend(List<WorkflowProcess> processes) {
        Map<Long, List<Long>> childrenTokens = this.populateChildrenTokens(processes);
        for (WorkflowProcess process : processes) {
            CustomToken token = process.getRootToken();
            if (token.getRequestedStatus() == ProcessStatus.PAUSED || token.getRequestedStatus() == ProcessStatus.CANCELLED) {
                if (process.getSuperProcessToken() != null) continue;
                this.sendRecoveryMessage(token, childrenTokens.get(process.getId()));
                continue;
            }
            ServiceLookup.findProcessManagerService().pause(token);
        }
    }

    protected void doRecover(Collection<WorkflowProcess> processes) throws InterruptedException {
        Map<Long, List<Long>> childrenTokens = this.populateChildrenTokens(processes);
        HashSet<WorkflowProcess> queued = new HashSet<WorkflowProcess>();
        for (WorkflowProcess process : processes) {
            boolean isChildProcess = process.getSuperProcessToken() != null;
            if (isChildProcess) continue;
            if (process.hasTokens(ProcessStatus.QUEUED)) {
                queued.add(process);
                continue;
            }
            this.sendRecoveryMessage(process.getRootToken(), childrenTokens.get(process.getId()));
        }
        if (!queued.isEmpty()) {
            Thread.sleep(10000L);
            for (WorkflowProcess process : queued) {
                this.sendRecoveryMessage(process.getRootToken(), childrenTokens.get(process.getId()));
            }
        }
    }

    private Map<Long, List<Long>> populateChildrenTokens(Collection<WorkflowProcess> processes) {
        ConcurrentMap childrenTokens = Maps.newConcurrentMap();
        for (WorkflowProcess process : processes) {
            if (process.getSuperProcessToken() == null) continue;
            long parentId = process.getSuperProcessToken().getProcessInstance().getId();
            if (!childrenTokens.containsKey(parentId)) {
                childrenTokens.put(parentId, Lists.newArrayList());
            }
            ((List)childrenTokens.get(parentId)).add(process.getRootToken().getId());
        }
        return childrenTokens;
    }

    private void addFailedProcessIntoCache() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<WorkflowProcess> failedProcesses = this.findFailedProcesses();
        LOGGER.info((Object)("Found " + failedProcesses.size() + " failed process(es) for recovery in " + Watch.cost((Stopwatch)stopwatch)));
        if (!failedProcesses.isEmpty()) {
            LOGGER.info((Object)("Adding " + failedProcesses.size() + " failed process(es) to the cache "));
        }
        WorkflowProcessCache cache = ServiceLookup.findProcessCacheService();
        for (WorkflowProcess process : failedProcesses) {
            cache.add((Serializable)Long.valueOf(process.getId()), process);
        }
    }

    public void sendRecoveryMessage(CustomToken rootToken, List<Long> subTokens) {
        WorkflowMessage message = WorkflowProcessConvertor.toRecoveryMessage(rootToken, subTokens);
        try {
            IMessageProducer producer = ServiceLookup.findMessageProducerService();
            producer.publish(ComponentType.WORKFLOW_RECOVERY, message);
        }
        catch (MessagePublishException e) {
            LOGGER.error((Object)("Failed to recover process:" + rootToken), (Throwable)e);
        }
    }

    private List<WorkflowProcess> search() {
        try {
            return this.getSearchService().findAllByStatus(ProcessStatus.ACTIVE, ProcessStatus.BRANCHED, ProcessStatus.QUEUED);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Fail to load active process for recovery", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private SearchCriteria createSearchFailedCriteria() {
        SearchCriteria criteria = new SearchCriteria();
        criteria.setRecordsCount(1000);
        ListParameter parameter = new ListParameter("operationalStatus", SearchType.PROCESSSTATUS);
        parameter.addValues(new Object[]{ProcessStatus.ERROR});
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.addParameter(RangeParameter.createDate((String)"startTime", (Date)this.getExpiredDate()));
        criteria.addParameter((SearchParameterBase)new SortParameter("id", SortingOrder.DESCENDING));
        return criteria;
    }

    private IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    private List<WorkflowProcess> findFailedProcesses() {
        try {
            SearchCriteria criteria = this.createSearchFailedCriteria();
            List<WorkflowProcess> result = this.getSearchService().search(criteria);
            if (result.isEmpty()) {
                LOGGER.info((Object)("Cannot find failed Processes to recovery after " + this.getExpiredDate()));
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Fail to load failed process for recovery", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Date getExpiredDate() {
        int expiryDays = Configuration.toInteger((String)ServiceLookup.findProcessManagerService().getProperties().getProperty("time_interval"), (int)2);
        return new Date(System.currentTimeMillis() - (long)expiryDays * 86400000L);
    }

    private boolean isHalted() {
        return Boolean.parseBoolean(ServiceLookup.findProcessManagerService().getProperties().getProperty("isDriverHalted"));
    }
}

